#*************************************************************************
#*
#*  $RCSfile: start_fcns.tcl,v $
#*
#*  $Revision: 1.10 $
#*
#*  last change: $Author: wiede $ $Date: 2005/12/05 12:22:57 $
#*
#*  The Contents of this file are made available subject to the terms of
#*  the following license
#*
#* 	- BSD License
#*
#*	see file license.terms in this directory
#*
#*  Copyright 2005 Arnulf Wiedemann
#*
#*  Author: Arnulf Wiedemann
#*
#*  Contributor(s): 
#*
#************************************************************************/

namespace eval ::tclUrtpBridge {

# **************************** getComponentContext *********************

proc getComponentContext {flag} {
	# the flag parameter is only for compatibility with the tcluno implementation
	variable data
	variable local_thread_cache
	variable local_thread_cache_names

	if {[string length $data(localContext)] == 0} {
		set data(handle_index) 0
		set data(localContext) [getNextHandle]
		set my_thread_id_str "[format {0x%04x} $data(local_thread_cache_index)][clock format [clock seconds] -format {%Y%m%d%H%M%S}]"
		set sep ""
		set my_thread_id ""
		foreach ch [split $my_thread_id_str ""] {
			switch $ch {
			x {
				set ch 120
			  }
			}
			append my_thread_id "$sep[format {0x%02x} $ch]"
			set sep " "
		}
		set local_thread_cache_names($data(local_thread_cache_index)) $my_thread_id
		incr data(local_thread_cache_index)
	}
	return [namespace current]::LocalContext
}

# **************************** UnoResolve ******************************

proc UnoResolve {} {
	variable data
	variable object_interfaces
	variable remote_object_cache
	variable remote_object_cache_names
	variable remote_type_cache

	set data(in_introspection) 0
	set data(remote_context) [queryInterface [list] com.sun.star.uno.XInterface]
	set my_oid $data(remote_context)
	set data(remote_component_context) [queryInterface $data(remote_context) com.sun.star.uno.XComponentContext]
	set my_oid $data(remote_component_context)
	set remote_component_context_oid $my_oid

	# create the service for the types rdb
	set result_info [callMethod $data(remote_component_context) com.sun.star.uno.XComponentContext getValueByName [list STRING /singletons/com.sun.star.reflection.theTypeDescriptionManager]]
	set my_info [getInterfaceAndObject $result_info]
	foreach {my_interface_name my_oid} $my_info break
	set data(type_description_manager) $my_oid
	set data(hierarchical_name_access) [queryInterface $data(type_description_manager) com.sun.star.container.XHierarchicalNameAccess]

	# create the service for the core reflection
	set result_info [callMethod $data(remote_component_context) com.sun.star.uno.XComponentContext getValueByName [list STRING /singletons/com.sun.star.reflection.theCoreReflection]]
	set my_info [getInterfaceAndObject $result_info]
	foreach {my_interface_name my_oid} $my_info break
	set data(core_reflection) $my_oid
	set data(idl_reflection) [queryInterface $data(core_reflection) com.sun.star.reflection.XIdlReflection]
	set my_idx [queryInterface $data(idl_reflection) com.sun.star.reflection.XIdlClass]

	# next line is needed to get the values for method_return_types type classes
	getInterfaceEnumInfos com.sun.star.uno.TypeClass
	# next line is needed to get all container infos
	# otherwise problems with some methods!!

	# next line is needed for all the PropertyValue code
	getInterfaceStructInfos com.sun.star.beans.Property
	set result_info [callMethod $data(remote_component_context) com.sun.star.uno.XComponentContext getServiceManager]
	set my_oid [storeObjectInfo com.sun.star.uno.XComponentContext [lindex $result_info 0]]
	set data(remoteServiceManager) $my_oid
	queryInterface $data(remoteServiceManager) com.sun.star.lang.XMultiComponentFactory

	# create the service for the invocation
	set oid_cache_idx $remote_object_cache($data(remote_component_context))
	set result_info [callMethod $data(remoteServiceManager) com.sun.star.lang.XMultiComponentFactory createInstanceWithContext [list STRING com.sun.star.script.Invocation] [list OBJECT_ID [list]] [list OBJECT_CACHE_INDEX $oid_cache_idx]]
	set my_oid [storeObjectInfo com.sun.star.script.Invocation [lindex $result_info 0]]
	set data(invocation) $my_oid
	set data(invocation_service_factory) [queryInterface $data(invocation) com.sun.star.lang.XSingleServiceFactory]

if {0} {
puts stderr "SSF:0:"
set result_infos [callMethod $data(invocation) com.sun.star.script.XInvocation getIntrospection]
puts stderr "SSF:01:$result_infos:"
}

	# create the remote component handle
	set oid_cache_idx $remote_object_cache($data(remote_component_context))
	set return_object_value [list [list OBJECT_CACHE_INDEX $oid_cache_idx] [list OBJECT_ID $remote_component_context_oid]]
	set return_type_value [list [list TYPE_CLASS INTERFACE] [list CLASS_NAME com.sun.star.uno.XComponentContext]]
	set type_idx $remote_type_cache(com.sun.star.uno.XComponentContext)
	set oid_cache_idx $remote_object_cache($data(remote_component_context))
	set result_infos [callMethod $data(invocation_service_factory) com.sun.star.lang.XSingleServiceFactory createInstanceWithArguments [list SEQUENCE_SIZE 1] [list TYPE_CLASS INTERFACE] [list TYPE_CACHE_INDEX $type_idx] [list OBJECT_ID $remote_component_context_oid] [list OBJECT_CACHE_INDEX $oid_cache_idx]]
	set my_invocation_oid [storeObjectInfo com.sun.star.uno.XInterface [lindex $result_infos 0]]
	set invocation_oid [queryInterface $my_invocation_oid com.sun.star.script.XInvocation2]
	set result_infos [callMethod $invocation_oid com.sun.star.script.XInvocation getIntrospection]
	set my_introspection_oid [storeObjectInfo com.sun.star.uno.XIntrospectionAccess [lindex $result_infos 0]]
#puts stderr "UO:$return_object_value:$return_type_value:$invocation_oid:$my_introspection_oid:"
	set ret [CreateCommand handle [list $return_object_value $return_type_value [list invocation_oid $invocation_oid] [list introspection_oid $my_introspection_oid]]]
if {0} {
puts stderr "SSF:1:"
#set data(handle_introspection_oid) $my_introspection_oid
set return_type_name [getMethodReturnTypeName com.sun.star.lang.XSingleServiceFactory createInstance]
puts stderr "SSF:2:$return_type_name:"
}

if {0} {
puts stderr "QQ:1:"
set data(handle_introspection_oid) $my_introspection_oid
queryMethodInfos com.sun.star.uno.XInterface queryInterface
queryMethodInfos com.sun.star.uno.XInterface release
puts stderr "QQ:2:"
}

	set oid_cache_idx $remote_object_cache($data(remote_component_context))
	set result_info [callMethod $data(remoteServiceManager) com.sun.star.lang.XMultiComponentFactory createInstanceWithContext [list STRING com.sun.star.ucb.PropertiesManager] [list OBJECT_ID [list]] [list OBJECT_CACHE_INDEX $oid_cache_idx]]
	set my_oid [storeObjectInfo com.sun.star.ucb.PropertiesManager [lindex $result_info 0]]
	set data(properties_manager) $my_oid
	queryInterface $data(properties_manager) com.sun.star.lang.XTypeProvider

	set oid_cache_idx $remote_object_cache($data(remote_component_context))
	set result_info [callMethod $data(remoteServiceManager) com.sun.star.lang.XMultiComponentFactory createInstanceWithContext [list STRING com.sun.star.beans.Property] [list OBJECT_ID [list]] [list OBJECT_CACHE_INDEX $oid_cache_idx]]
	set my_oid [storeObjectInfo com.sun.star.beans.Property [lindex $result_info 0]]
	set data(property_server) $my_oid
	queryInterface $data(property_server) com.sun.star.beans.XPropertySetInfo
#puts stderr "UnoResolve END:remoteServiceManager:$data(remoteServiceManager):$data(properties_manager):$ret:"
	return $ret
}

# **************************** LocalUnoUrlResolver *********************

proc LocalUnoUrlResolver {args} {
	variable data

	set ok 0
	switch [lindex $args 0] {
	resolve {
	  	set connect_infos [split [lindex $args 1] {:}]
		foreach {protocol_type socket_infos} $connect_infos break
		switch $protocol_type {
		uno {
	  		set infos [split $socket_infos {;}]
			set remoteComponentContext ""
			foreach {protocol_infos uno_protocol remoteComponentContext} $infos break
			if {[string length $remoteComponentContext] > 0} {
				set data(inital_object_id_name) $remoteComponentContext
			}
			switch $uno_protocol {
			urp -
			urtp {
		  		set infos [split $protocol_infos {,}]
				foreach {protocol_type host_info port_info} $infos break
		  		switch $protocol_type {
				socket {
					set ok 1
			  		if {![regexp {^host=(.*)$} $host_info dummy host_name]} {
						set ok 0
						puts stderr "bad host_info:$host_info:"
					}
			  		if {![regexp {^port=(.*)$} $port_info dummy port_number]} {
						set ok 0
						puts stderr "bad host_info:$host_info:"
					}
			  		if {$ok} {
						set ok [openConnection $host_name $port_number]
						if {$ok} {
							return [UnoResolve]
						}
					}
				  }
				default {
					puts stderr "bad protocol_type:$protocol_type"
				  }
				}
			  }
			default {
				puts stderr "bad uno_protocol_type:$uno_protocol"
			  }
		  	}
		  }
		}

	  }
	}
eval puts stderr \"bad command:LocalUnoUrlResolver $args\"
	return $data(unknown_info)
}

# **************************** LocalServiceManager *********************

proc LocalServiceManager {args} {
	variable data

	switch [lindex $args 0] {
	createInstanceWithContext {
		switch [lindex $args 1] {
		com.sun.star.bridge.UnoUrlResolver {
			return [namespace current]::LocalUnoUrlResolver
	  	  }
		}
	  }
	}
eval puts stderr \"bad command:LocalServiceManager $args\"
	return $data(unknown_info)
}

# **************************** LocalContext ****************************

proc LocalContext {args} {
	variable data

	switch [lindex $args 0] {
	getServiceManager -
	ServiceManager {
		return [namespace current]::LocalServiceManager
	  }
	}
puts stderr "bad command:LocalContext [lindex $args 0]:"
	return $data(unknown_info)
}

}
