#*************************************************************************
#*
#*  $RCSfile: send_receive.tcl,v $
#*
#*  $Revision: 1.20 $
#*
#*  last change: $Author: wiede $ $Date: 2005/12/05 12:22:57 $
#*
#*  The Contents of this file are made available subject to the terms of
#*  the following license
#*
#* 	- BSD License
#*
#*	see file license.terms in this directory
#*
#*  Copyright 2005 Arnulf Wiedemann
#*
#*  Author: Arnulf Wiedemann
#*
#*  Contributor(s): 
#*
#************************************************************************/

# ***************** Start of low level brige routines *************************

namespace eval ::tclUrtpBridge {

# **************************** getNextHandle ***************************

proc getNextHandle {} {
	variable data

	set my_handle ::tclUrtpBridge::handle_[format {0x%04x} $data(handle_index)]
	incr data(handle_index)
	return $my_handle
}

# **************************** releaseTypeObject **************************

proc releaseTypeObject {interface_name oid} {
	variable data
	variable remote_object_cache
	variable remote_object_types
	variable released_objects
	variable method_modes

#puts stderr "releaseTypeObject:$oid:$interface_name:"
	if {![info exists remote_object_cache($oid)]} {
		puts stderr "FUNNY release OID:$oid!!"
	} else {
		if {! [info exists method_modes($interface_name,release)]} {
			set method_modes($interface_name,release) ONEWAY
		}
		callMethod $oid $interface_name release
	}
	catch {unset remote_object_types($oid)}
	set my_remote_idx $remote_object_cache($oid)
}

# **************************** getNextRemoteTypeCacheIndex *************

proc getNextRemoteTypeCacheIndex {} {
	variable data
	variable remote_type_cache_names

	set my_idxs [lsort -integer [array names remote_type_cache_names]]
#puts stderr "my_idxs:$my_idxs:"
	if {[llength $my_idxs] == 0} {
		set my_idx 0
	} else {
		set my_idx [lindex $my_idxs end]
		incr my_idx
	}
	if {$my_idx > 254} {
		set my_idx 0
	}
#puts stderr "getNextRemoteTypeCacheIndex:$my_idx:"
	return $my_idx
}

# **************************** getRemoteTypeCacheIndex *****************

proc getRemoteTypeCacheIndex {name} {
	variable data
	variable remote_type_cache

	if {[info exists remote_type_cache($name)]} {
		return $remote_type_cache($name)
	}
	return -1
}

# **************************** getLastRemoteObject *********************

proc xgetLastRemoteObject {} {
	variable data
	variable remote_objects

	set my_object_cache_idx $data(remote_object_cache_index)
	incr my_object_cache_idx -1
	return $remote_objects($my_object_cache_idx)
}

# **************************** openConnection **************************

proc openConnection {{host localhost} {port 2002}} {
	variable data

	if {[catch {socket $host $port} data(connection_fd)]} {
		puts stderr "ERROR: open connection to host:$host:port:$port:"
		return false
	}
	fconfigure $data(connection_fd) -buffering none
	return true
}

# **************************** closeConnection *************************

proc closeConnection {} {
	variable data

	if {[string length $data(connection_fd)] > 0} {
		close $data(connection_fd)
		return true
	}
	return false
}

# **************************** makeHeader ******************************

proc makeHeader {_newtid _newtype _newoid method_id {_longheader 1} {_request 1}} {
	variable data
	variable headers
	variable hdrflag_names

	set headers [list]
	set data(binary_header) 0
	set data(binary_request) ""
	set data(binary_request_size) 0
	foreach name $hdrflag_names {
		set hdr_flag_name $name
		set var_name [string tolower $name]
		regsub {hdrflag} $var_name {} var_name
		set val 0
		if {[info exists $var_name]} {
			eval set val \$$var_name
			if {$data(send_binary)} {
				if {$val} {
					set data(binary_header) [expr {$data(binary_header) + $data($hdr_flag_name)}]
				}
			}
		}
		set data(sent_hdr_value,$hdr_flag_name) $val
		lappend headers [list $name $val]
	}
	if {$data(send_binary)} {
		packInt8 $data(binary_header)
		packInt8 $method_id
	}
	set data(sent_method_id) $method_id
	lappend headers [list METHOD_ID $method_id]
	set headers [list $headers]
	set data(request) $headers
	return $headers
}

# **************************** makeShortHeader *************************

proc makeShortHeader {method_id} {
	variable data

	makeHeader 0 0 0 $method_id 0 1
}

# **************************** startLongRequest ************************

proc startLongRequest {new_tid new_type new_oid method_id} {
	makeHeader $new_tid $new_type $new_oid $method_id
}

# **************************** startShortRequest ***********************

proc startShortRequest {method_id} {
	makeShortHeader method_id
}

# **************************** storeRemoteThreadInfo *******************

proc storeRemoteThreadInfo {info} {
	variable data
	variable remote_thread_cache
	variable remote_thread_cache_names

	foreach entry $info {
		foreach {type value} $entry break
		switch $type {
		THREAD_ID_SIZE {
		  	set thread_id_size $value
		  }
		THREAD_ID {
		  	set thread_id $value
		  }
		THREAD_CACHE_INDEX {
		  	set data(remote_thread_cache_index) $value
		  }
		default {
			puts stderr "funny type in ThreadIdInfo:$type:$value:"
		  }
		}
	}
	# TO BE DONE: need to check if all three values are filled!!
	# and if the contents is ok
	set remote_thread_cache_names($data(remote_thread_cache_index)) [list $thread_id_size $thread_id]
	set remote_thread_cache($thread_id) data(remote_thread_cache_index)
}

# **************************** storeRemoteTypeInfo *********************

proc xstoreRemoteTypeInfo {info is_new} {
	variable data
	variable remote_type_cache
	variable remote_type_cache_names

#puts stderr "storeRemoteTypeInfo:$info:"
	if {$is_new} {
		foreach {type_info type_cache_info class_name_info} $info break
	} else {
		set class_name_info [list]
		foreach {type_info type_cache_info} $info break
	}
	foreach {type1 type_class} $type_info break
	if {[string compare $type1 TYPE_CLASS] != 0} {
		puts stderr "ERROR: storeRemoteTypeInfo: expected TYPE_CLASS got:$type1:$type_info:$info:"
	}
	foreach {type2 type_cache_index} $type_cache_info break
	if {[string compare $type2 TYPE_CACHE_INDEX] != 0} {
		puts stderr "ERROR: storeRemoteTypeInfo: expected TYPE_CACHE_INDEX got:$type2:$type_cache_info:$info:"
	}
	set data(remote_type_cache_index) $type_cache_index
	if {[string length $class_name_info] > 0} {
		foreach {type3 class_name} $class_name_info break
		if {[string compare $type3 CLASS_NAME] != 0} {
			puts stderr "ERROR: storeRemoteTypeInfo: expected CLASS_NAME got:$type3:$class_name_info:$info:"
		}
	}
#if {!$data(no_log)} {
if {[info exists class_name]} {
#puts stderr "STORE NEWTYPE:$data(remote_type_cache_index):$class_name:"
} else {
#puts stderr "STORE TYPE:$data(remote_type_cache_index):$remote_type_cache_names($data(remote_type_cache_index)):"
}
#}
	if {![info exists type_class]} {
		puts stderr "MISSING type_class in: $info!!"
		set type_class $data(unknown_info)
	}
	if {[info exists class_name]} {
		set remote_type_cache_names($data(remote_type_cache_index)) $class_name
		set remote_type_cache($class_name) $data(remote_type_cache_index)
	}
	return $remote_type_cache_names($data(remote_type_cache_index))
}

# **************************** storeRemoteTypeObjects ******************

proc xstoreRemoteTypeObjects {infos} {
	variable data
	variable remote_object_interfaces
	variable remote_interface_objects
	variable remote_type_cache_names
	variable remote_type_cache
	variable loaded_interfaces

	if {[llength $infos] == 0} {
		return
	}
	foreach {type info} $infos break
	if {[string compare $type SEQUENCE] != 0} {
		puts stderr "storeRemoteTypeObjects:expected:SEQUENCE:got:$type:infos:$infos:"
		return
	}
	foreach {size_entry infos} $info break
	set num_entries [getSequenceSize $size_entry]
	if {[llength $infos] != $num_entries} {
		puts stderr "storeRemoteTypeObjects:SEQUENCE_SIZE is:$num_entries:list has only num_entries:$num_entries:"
	}
	set my_oid $data(call_method_object)
 	if {![info exists remote_object_interfaces($my_oid)]} {
		set remote_object_interfaces($my_oid) [list]
	}
	foreach entry $infos {
		foreach {type_str dummy} $entry break
		switch $type_str {
		NEW_TYPE {
			set type_cache_infos [getRemoteTypeCacheInfo $entry]
			foreach {my_class_name my_idx} $type_cache_infos break
			set remote_type_cache_names($my_idx) $my_class_name
			if {![info exists loaded_interfaces($my_class_name)]} {
				lappend data(needed_interfaces) $my_class_name
			}
			set remote_type_cache($my_class_name) $my_idx
#puts stderr "NEWT:$my_idx:$my_class_name:$my_idx:"
			if {[lsearch $remote_object_interfaces($my_oid) $my_idx] < 0} {
				lappend remote_object_interfaces($my_oid) $my_idx
			}
	  		if {![info exists remote_interface_objects($my_class_name)]} {
				set remote_interface_objects($my_class_name) [list]
			}
			if {[lsearch $remote_interface_objects($my_class_name) $my_oid] < 0} {
				lappend remote_interface_objects($my_class_name) $my_oid
			}
		  }
		TYPE {
			set type_cache_infos [getRemoteTypeCacheInfo $entry]
			foreach {my_class_name my_idx} $type_cache_infos break
			if {[lsearch $remote_object_interfaces($my_oid) $my_idx] < 0} {
				lappend remote_object_interfaces($my_oid) $my_idx
			}
		  }
		}
	}
}

# **************************** storeObjectInfo *************************

proc storeObjectInfo {interface_name lst} {
	variable data
	variable remote_object_cache
	variable remote_object_cache_names

	set my_infos [checkForNewObject $lst]
	foreach {object_info dummy} $my_infos break
#puts stderr "object_info:$object_info:"
	foreach {type my_oid} [lindex $object_info 0] break
#puts stderr "my_oid:$my_oid:"
	storeObjectTypeIndex $my_oid $interface_name
	return $my_oid
}

# **************************** handleMessageHeader *********************

proc handleMessageHeader {reply} {
	variable data

SendDebug 1 "RESULT:$data(message_id):$reply:"
	set reply_headers [lindex $reply 0]
	set reply_body [lrange $reply 1 end]
	set data(is_new_object) 0
	set data(had_request) 0
	set have_new_type 0
	set have_new_object 0
	set have_new_thread 0
	set have_exception 0
	foreach entry $reply_headers {
		foreach {flag value} $entry break
		switch $flag {
		HDRFLAG_NEWTID {
			set have_new_thread $value
		  }
		HDRFLAG_NEWTYPE {
			set have_new_type $value
		  }
		HDRFLAG_NEWOID {
			set have_new_object $value
		  }
		HDRFLAG_EXCEPTION {
			set have_exception $value
		  }
		HDRFLAG_REQUEST {
			set data(had_request) $value
		  }
		}
	}
	if {$data(had_request)} {
		set have_exception 0
	}
	if {$have_exception} {
		set have_new_type 0
		set have_new_object 0
		set have_new_thread 0
		set new_type_info [lindex $reply_body 0]
		set my_infos [checkForNewType $new_type_info]
		set my_infos [lindex $my_infos 0]
		set my_infos [getInterfaceAndObject $my_infos]
		foreach {my_type_name dummy} $my_infos break
		# should get [list TYPE_CLASS STRING] [list VALUE xxxx]
		# instead of [list STRING xxxx] (to be fixed in binary_unmarshal.tcl!!
#		set exception_str [getStringValue [lindex $reply_body 1]]
		foreach {type exception_str} [lindex $reply_body 1] break
		set my_str "EXCEPTION:class_name:$my_type_name:$exception_str:"
# puts stderr $my_str
		error $my_str $my_str
		set reply_body [list]
	}
	# from the server we get eventually type,oid,tid in that order!!
	if {$have_new_type} {
		set new_type_info [lindex $reply_body 0]
		set reply_body [lrange $reply_body 1 end]
		foreach {type info} $new_type_info break
		switch $type {
		NEW_TYPE {
			set is_new 1
		  }
		TYPE {
		  	set is_new 0
		  }
		}
		# to be fixed !! use checkForNewTypeAndObject instead!!
		storeRemoteTypeInfo $info $is_new
	}
	if {$have_new_object} {
		set new_object_info [lindex $reply_body 0]
		set reply_body [lrange $reply_body 1 end]
		foreach {type info} $new_object_info break
	}
	if {$have_new_thread} {
		set new_thread_info [lindex $reply_body 0]
		set reply_body [lrange $reply_body 1 end]
		foreach {type info} $new_thread_info break
		storeRemoteThreadInfo $info
	}
	if {$have_new_object && $have_new_type && !$data(had_request)} {
		set my_object $data(last_remote_object)
		set my_type $remote_type_cache_names($data(last_remote_type_id))
		storeObjectTypeIndex $my_object $my_type
	}
	return $reply_body
}

# **************************** readTextReply *******************************

proc readTextReply {} {
	variable data

	while {1} {
		set ret [read $data(connection_fd) 23]
		scan $ret "%s 0x%04x 0x%04x " ret_magic reply_size ret_msg_id
		set reply [read $data(connection_fd) $reply_size]
		set reply [handleMessageHeader $reply]
		if {!$data(had_request)} {
			break
		}
	}
	return $reply
}

# **************************** buildTextSendMessage ********************

proc buildTextSendMessage {} {
	variable data

	set lgth [format "0x%04x" [string length $data(request)]]
	set my_message_id [format "0x%04x" $data(message_id)]
	set send_str "ffffffff $lgth $my_message_id $data(request)"
SendDebug 1 "SENDING:$data(message_id):$send_str:"
	return $send_str
}

# **************************** checkForNewType *************************

proc checkForNewType {infos} {
	variable data
	variable remote_type_cache_names
	variable remote_type_cache
	variable local_requested_type_names

	set data(new_type_name) [list]
	set my_result [list]
	set idx 0
	set type_info [lindex $infos $idx]
	incr idx
	set is_new 0
	set new_str [list]
	if {[llength $type_info] == 3} {
		foreach {type type_str new_str} $type_info break
		set is_new 1
		if {[string compare $new_str NEW] != 0} {
			puts stderr "ERROR: checkForNewType:expected NEW got:$new_str:$type_info:$infos:"
		}
	} else {
		foreach {type type_str} $type_info break
	}
	if {[string compare $type TYPE_CLASS] == 0} {
		switch $type_str {
		VOID {
			set my_result $infos
			return $my_result
		  }
		EXCEPTION -
		INTERFACE -
		SEQUENCE {
		  }
		default {
			puts stderr "ERROR: checkForNewType:expected INTERFACE/SEQUENCE/EXCEPTION got:$type_str:$type_info:$infos:"
		  }
		}
		set type_cache_info [lindex $infos $idx]
		incr idx
		foreach {type type_cache_index} $type_cache_info break
		if {[string compare $type TYPE_CACHE_INDEX] != 0} {
			puts stderr "ERROR: checkForNewType:expected TYPE_CACHE_INDEX got:$type:$type_cache_info:$infos:"
		}
		if {! [string is integer $type_cache_index]} {
			puts stderr "ERROR: checkForNewType:expected integer value for TYPE_CACHE_INDEX got:$type_cache_index:$type_cache_info:$infos:"
		}
		set data(remote_type_cache_index) $type_cache_index
		if {$is_new} {
			set type_name_info [lindex $infos $idx]
			incr idx
			foreach {type type_name} $type_name_info break
			if {[string compare $type TYPE_NAME] != 0} {
				puts stderr "ERROR: checkForNewType:expected TYPE_NAME got:$type:$type_name_info:$infos:"
			}
			set remote_type_cache_names($type_cache_index) $type_name
			set remote_type_cache($type_name) $type_cache_index
			set local_requested_type_names($type_name) 0
		}
		lappend my_result [list TYPE_CLASS $type_str]
		set type_name $remote_type_cache_names($type_cache_index)
		set data(new_type_name) $type_name
		lappend my_result [list VALUE $type_name]
		set infos [lrange $infos $idx end]
	}
	return [list $my_result $infos]
}

# **************************** checkForNewObject ***********************

proc checkForNewObject {infos} {
	variable data
	variable remote_object_cache_names
	variable remote_object_cache
	variable remote_object_types

	set my_result [list]
	set idx 0
	set oid_info [lindex $infos $idx]
	incr idx
	foreach {type oid} $oid_info break
	if {[string compare $type OBJECT_ID] != 0} {
		puts stderr "ERROR: checkForNewObject:expected OBJECT_ID got:$type:$oid_info:$infos:"
	}
	set oid_cache_info [lindex $infos $idx]
	incr idx
	foreach {type oid_cache_index} $oid_cache_info break
	if {[string compare $type OBJECT_CACHE_INDEX] != 0} {
		puts stderr "ERROR: checkForNewObject:expected OBJECT_CACHE_INDEX got:$type:$oid_cache_info:$infos:"
	}
	if {! [string is integer $oid_cache_index]} {
		puts stderr "ERROR: checkForNewObject:expected integer value for OBJECT_CACHE_INDEX got:$oid_cache_index:$oid_cache_info:$infos:"
	}
	if {$oid_cache_index == 65535} {
		set data(is_tmp_object) 1
SendDebug 1 "WARNING:OBJECT_CACHE_INDEX:$oid_cache_index"
		lappend my_result [list OBJECT_ID [list]]
	} else {
	  	set data(remote_object_cache_index) $oid_cache_index
		if {[string length $oid] > 0} {
			set remote_object_cache_names($oid_cache_index) $oid
#puts stderr "STORE OID:rem:$oid_cache_index:$oid:"
			set remote_object_cache($oid) $oid_cache_index
		}
		set oid $remote_object_cache_names($oid_cache_index)
		lappend my_result [list OBJECT_ID $oid]
		if {[string length $data(new_type_name)] > 0} {
			set type_name $data(new_type_name)
			if {![info exists remote_object_types($oid)]} {
				set remote_object_types($oid) [list]
			}
			if {[lsearch $remote_object_types($oid) $type_name] < 0} {
				lappend remote_object_types($oid) $type_name
			}
		}
		set infos [lrange $infos $idx end]
	}
SendDebug 1 "checkForNewObject:END:my_result:$my_result:infos:$infos:"
	return [list $my_result $infos]
}

# **************************** checkForNewTypeAndObject ****************

proc checkForNewTypeAndObject {infos} {
	set my_infos [checkForNewType $infos]
	foreach {my_type_result infos} $my_infos break
	set my_infos [checkForNewObject $infos]
	foreach {my_object_result infos} $my_infos break
	if {[llength $my_type_result] > 0} {
		set my_result [concat $my_type_result $my_object_result]
	} else {
		set my_result $my_object_result
	}
#puts stderr "checkForNewTypeAndObject:END:$my_result:"
	return [list $my_result $infos]
}

# **************************** sendRequest *****************************

proc sendRequest {} {
	variable data
	variable reply
	variable reply_headers
	variable reply_body
	variable method_modes

	if {$data(had_error)} {
		return [list]
	}
	incr data(message_id)

	set data(primary_return_type_name) [list]
	set data(send_str) [$data(buildSendMessage)]
	puts -nonewline $data(connection_fd) $data(send_str)
	flush $data(connection_fd)
	if {[string length $data(request)] == 0} {
		# close connection
		closeConnection
puts stderr "CLOSE"
		return [list]
	}
	set curr_method_name $data(curr_method_name)
	set curr_interface_name $data(curr_interface_name)
SendDebug 2 "sendRequest:$curr_method_name:$curr_interface_name:"
	if {[info exists method_modes($curr_interface_name,$curr_method_name)]} {
		switch $method_modes($curr_interface_name,$curr_method_name) {
		ONEWAY {
SendDebug 2 "ONEWAY:$curr_interface_name,$curr_method_name:"
			return [list]
		  }
		}
	}
	set reply [$data(readReply)]
SendDebug 1 "sendRequest:reply:$data(primary_return_type_name):$reply:"
	switch $data(primary_return_type_name) {
	INTERFACE {
	  	set my_infos [checkForNewTypeAndObject $reply]
		foreach {reply infos} $my_infos break
	  }
	}
SendDebug 1 "sendRequest:END:$reply:"
	return $reply
}

# **************************** getReplyHeaderFlag **********************

proc getReplyHeaderFlag {name} {
	variable data
	variable reply_headers

	foreach entry $reply_headers {
		foreach {fld_name value} $entry break
		if {[string compare $name $flag_name] == 0} {
			return $value
		}
	}
	return [list]
}

# **************************** getLocalThread **************************

proc xgetLocalThread {cache_idx} {
	variable data
	variable local_thread_cache_names

	if {[info exists local_thread_cache_names($cache_idx)]} {
		return $local_thread_cache_names($cache_idx)
	}
	return [list]
}

# **************************** getRemoteThread *************************

proc getRemoteThread {cache_idx} {
	variable data
	variable remote_thread_cache_names

	if {[info exists remote_thread_cache_names($cache_idx)]} {
		return $remote_thread_cache_names($cache_idx)
	}
	return [list]
}

# **************************** getRemoteObject *************************

proc getRemoteObject {cache_idx} {
	variable data
	variable remote_object_cache_names

#puts stderr "getRemoteObject:[array names remote_object_cache_names]:"
	if {[info exists remote_object_cache_names($cache_idx)]} {
		return $remote_object_cache_names($cache_idx)
	}
	return [list]
}

# **************************** appendRequestElement ********************

proc appendRequestElement {args} {
	variable data

	if {$data(send_binary)} {
		set req_type [lindex $args 0]
		set value [lindex $args 1]
		switch $req_type {
		OBJECT_ID {
		  	packStringBinary $value
		  }
		OBJECT_CACHE_INDEX {
			packInt16 $value
		  }
		THREAD_ID_SIZE {
		  }
		THREAD_ID {
		  }
		THREAD_CACHE_INDEX {
			packInt16 $value
		  }
		TYPE_CLASS {
		  	set type_class_value $data(typeclass,$value)
			if {[llength $args] > 2} {
				set is_new [lindex $args 2]
				switch $is_new {
				NEW {
				  	set type_class_value [expr {$type_class_value + 0x80}]
				  }
				default {
					puts stderr "ERROR: funny is_new: $is_new:"
				  }
				}
		  	}
			packInt8 $type_class_value
		  }
		TYPE_CACHE_INDEX {
			packInt16 $value
		  }
		CLASS_NAME {
		  	packStringBinary $value
		  }
		default {
		  	puts stderr "funny request type:$req_type:"
		  }
		}
	}
	set my_lst [eval list $args]
	append data(request) " [list $my_lst]"
}
	
# **************************** appendNewInterfaceRequestElement ********

proc appendNewInterfaceRequestElement {name} {
	variable data

	set my_idx [getNextRemoteTypeCacheIndex]
if {!$data(no_log)} {
puts stderr "NEW Interface:$name:$my_idx:"
}
	appendRequestElement TYPE_CLASS INTERFACE NEW
	appendRequestElement TYPE_CACHE_INDEX $my_idx
	appendRequestElement CLASS_NAME $name
	return $my_idx
}

# **************************** makeNewTypeCacheEntry *******************

proc makeNewTypeCacheEntry {name} {
	variable data
	variable remote_type_cache
	variable remote_type_cache_names

	set my_rem_type_cache_idx [getNextRemoteTypeCacheIndex]
	set remote_type_cache_names($my_rem_type_cache_idx) $name
	set remote_type_cache($name) $my_rem_type_cache_idx
	return $my_rem_type_cache_idx
}

# **************************** appendInterfaceRequestElement ***********

proc appendInterfaceRequestElement {name} {
	variable data
	variable remote_type_cache
	variable remote_type_cache_names
	variable local_requested_type_names
	variable remote_object_types

if {!$data(no_log)} {
puts stderr "Interface:$name:$data(curr_oid):"
}
	set is_new 1
	if {[info exists remote_object_types($data(curr_oid))]} {
#puts stderr "ROT:$name:[join $remote_object_types($data(curr_oid)) \n]:"
		if {[lsearch $remote_object_types($data(curr_oid)) $name] >= 0} {
#puts stderr "FOUND:$name:$data(curr_oid):"
			# don't know why that does not work!!
#			set is_new 0
		}
	}
	set my_rem_type_cache_idx [getRemoteTypeCacheIndex $name]
	if {$my_rem_type_cache_idx < 0} {
if {!$data(no_log)} {
		puts stderr "no type_cache entry for:$name:"
}
if {!$data(no_log)} {
puts stderr "NEW Interface:$name:"
}
#		set local_requested_type_names($name) 1
		set my_rem_type_cache_idx [makeNewTypeCacheEntry $name]
		set is_new 1
	} 
	if {$is_new} {
		appendRequestElement TYPE_CLASS INTERFACE NEW
		appendRequestElement TYPE_CACHE_INDEX $my_rem_type_cache_idx
		appendRequestElement CLASS_NAME $name
	} else {
		appendRequestElement TYPE_CLASS INTERFACE
		appendRequestElement TYPE_CACHE_INDEX $my_rem_type_cache_idx
	}
	return $my_rem_type_cache_idx
}

# **************************** appendRequestInfos **********************

proc appendRequestInfos {lst} {
	variable data

	foreach my_lst $lst {
		packMethodArgument $my_lst
		append data(request) " [list $my_lst]"
	}
}

# **************************** checkMethodIdExists *********************

proc checkMethodIdExists {name1 name2 op} {
	variable data
	variable method_ids

	set flds [split $name2 {,}]
	foreach {my_class_name my_method_name} $flds break
	if {[string is integer $my_method_name]} {
		return $my_method_name
	}
	if {![info exists ${name1}($name2)]} {
		switch -glob $name2 {
		*,queryInterface {
			set ${name1}($name2) 0
		  }
		*,release {
			set ${name1}($name2) 2
		  }
		default {
			set flds [split $name2 {,}]
			foreach {my_class_name my_method_name} $flds break
			set class_name $data(class_name)
#puts stderr "==== getInterfaceMethodInfos:1: $class_name:$name2:"
			set my_oid $data(curr_oid)
			getInterfaceMethodInfos $class_name $my_oid
			if {![info exists ${name1}($name2)]} {
				# to be filled
		  	}
		  }
		}
	}
}

# **************************** getMethodId *****************************

proc getMethodId {class_name name} {
	variable data
	variable method_ids

ReflectionDebug 2 "Method:$class_name:$name:"
	set data(class_name) $class_name
	set data(curr_method_name) $name
	set ret $method_ids($class_name,$name)
ReflectionDebug 2 "Method2:$class_name:$name:$method_ids($class_name,$name):"
	return $ret
}

# **************************** getSequenceInfoElement ******************

proc getSequenceInfoElement {infos idx} {
	variable data

	set infos [lindex $infos 0]
	# SEQUENCE <sequence_infos>
	foreach {type infos1} $infos break
	if {[string compare $type SEQUENCE] != 0} {
		puts stderr "ERROR: that is no SEQUENCE:$infos:"
		return [list]
	}
	# {SEQUENCE_SIZE <nn>} <object_infos>
	foreach {size_info infos2} $infos1 break
	foreach {str num_elems} $size_info break
	if {[string compare $str SEQUENCE_SIZE] != 0} {
		puts stderr "ERROR: expected:SEQUENCE_SIZE:got:$str:"
		return [list]
	}
	if {$idx >= $num_elems} {
		puts stderr "SEQUENCE has not so much elements:$idx:max:[expr $num_elems - 1]:"
		return [list]
	}
	return [lindex $infos2 $idx]
}

}
# ***************** End of low level bridge routines *************************
