#*************************************************************************
#*
#*  $RCSfile: log_fcns.tcl,v $
#*
#*  $Revision: 1.9 $
#*
#*  last change: $Author: wiede $ $Date: 2005/12/20 18:26:35 $
#*
#*  The Contents of this file are made available subject to the terms of
#*  the following license
#*
#* 	- BSD License
#*
#*	see file license.terms in this directory
#*
#*  Copyright 2005 Arnulf Wiedemann
#*
#*  Author: Arnulf Wiedemann
#*
#*  Contributor(s): 
#*
#************************************************************************/

namespace eval ::tclUrtpBridge {

# **************************** dumpRemoteObjectTypes *******************

proc dumpRemoteObjectTypes {} {
	variable data
	variable remote_object_types
	variable remote_object_cache
	variable remote_object_cache_names
	variable remote_type_cache
	variable remote_type_cache_names

	puts stderr "REMOTE_OBJECT_TYPES:"
	catch {unset my_infos}
	set idx_lst [list]
	foreach my_object [array names remote_object_types] {
		set my_type $remote_object_types($my_object)
		set type_idx $remote_type_cache($my_type)
		if {![info exists remote_object_cache($my_object)]} {
			puts stderr "missing remote_object_cache:$my_object:"
			set idx -1
		} else {
			set idx $remote_object_cache($my_object)
		}
		set my_infos($idx) "$idx!$my_object!$type_idx!$my_type!"
		lappend idx_lst $idx
	}
	foreach idx [lsort -integer -unique $idx_lst] {
		puts stderr $my_infos($idx)
	}
	catch {unset my_infos}
}

# **************************** dumpRemoteObjects ***********************

proc dumpRemoteObjects {} {
	variable data
	variable remote_object_cache_names
	variable object_ref_counts

	puts stderr "REMOTE_OBJECTS:"
	foreach idx [lsort -integer [array names remote_object_cache_names]] {
		set ref_cnt -1
		if {[info exists object_ref_counts($remote_object_cache_names($idx))]} {
			set ref_cnt $object_ref_counts($remote_object_cache_names($idx))
		}
		puts stderr "$idx:$ref_cnt:$remote_object_cache_names($idx)"
	}
}

# **************************** dumpRemoteTypeObjects *******************

proc dumpRemoteTypeObjects {} {
	variable data
	variable remote_type_objects
	variable remote_object_cache_names

	puts stderr "REMOTE_TYPE_OBJECTS:"
	foreach class_name [array names remote_type_objects] {
		set my_oid $remote_type_objects($class_name)
		puts stderr "$class_name $my_oid"
	}
}

# **************************** dumpObjectCache *************************

proc dumpObjectCache {} {
	variable data
	variable object_cache

	set lst [list]
	foreach name [array names object_cache] {
		lappend lst "$name $object_cache($name)"
	}
	set lst [lsort $lst]
	puts stderr [join $lst \n]
}

# **************************** dumpRemoteTypeCache *********************

proc dumpRemoteTypeCache {} {
	variable data
	variable remote_type_cache_names

	puts stderr "REMOTE_TYPES:"
	set lst [list]
	foreach idx [lsort -integer [array names remote_type_cache_names]] {
		lappend lst "$idx:$remote_type_cache_names($idx):"
	}
	puts stderr [join $lst \n]
}

# **************************** dumpRemoteThreadCache *******************

proc dumpRemoteThreadCache {} {
	variable data
	variable remote_thread_cache_names

	puts stderr "REMOTE_THREADS:"
	set lst [list]
	foreach idx [lsort -integer [array names remote_thread_cache_names]] {
		lappend lst "$idx:$remote_thread_cache_names($idx):"
	}
	puts stderr [join $lst \n]
}

# **************************** dumpRemoteObjectInterfaces **************

proc dumpRemoteObjectInterfaces {object_id} {
	variable data
	variable remote_object_interfaces
	variable remote_type_cache_names

	puts stderr "REMOTE_OBJECT_INTERFACES oid_id:$object_id"
	if {[info exists remote_object_interfaces($object_id)]} {
		foreach interface_idx [lsort -integer $remote_object_interfaces($object_id)] {
			if {[info exists remote_type_cache_names($interface_idx)]} {
				puts stderr "$interface_idx:$remote_type_cache_names($interface_idx):"
			}
		}
	}
}

# **************************** dumpAllRemoteObjectInterfaces ***********

proc dumpAllRemoteObjectInterfaces {} {
	variable data
	variable remote_object_interfaces

	foreach oid [lsort [array names remote_object_interfaces]] {
		puts stderr "OBJ_ID:$oid:"
		dumpRemoteObjectInterfaces $oid
	}
}

# the following debug procs exist with and without an "_" 
# if the debugging is used the version with an "_" is renamed to
# the version without an "_" because that version has a none empty body

# **************************** _CommandDebug ***************************

#proc CommandDebug {level msg} {}

proc CommandDebug {level msg} {
	variable data

	if {$level <= $data(command_debug)} {
		puts stderr "COM:$msg:"
	}
}

# **************************** _InvokeDebug ***************************

#proc InvokeDebug {level msg} {}

proc InvokeDebug {level msg} {
	variable data

	if {$level <= $data(invoke_debug)} {
		puts stderr "INV:$msg:"
	}
}

# **************************** _SendDebug ******************************

#proc SendDebug {level msg} {}

proc SendDebug {level msg} {
	variable data

	if {$level <= $data(send_debug)} {
		puts stderr "SEND:$msg:"
	}
}

# **************************** _BinarySendDebug ************************

#proc BinarySendDebug {level msg} {}

proc BinarySendDebug {level msg} {
	variable data

	if {$level <= $data(binary_send_debug)} {
		puts stderr "BIN_SEND:$msg:"
	}
}

# **************************** _UnmarshalDebug *************************

#proc UnmarshalDebug {level msg} {}

proc UnmarshalDebug {level msg} {
	variable data

	if {$level <= $data(unmarshal_debug)} {
		puts stderr "UNMSH:$msg:"
	}
}

# **************************** _ReflectionDebug ************************

#proc ReflectionDebug {level msg} {}

proc ReflectionDebug {level msg} {
	variable data

	if {$level <= $data(reflection_debug)} {
		puts stderr "REFL:$msg:"
	}
}

# **************************** _TclfcnsDebug ************************

#proc TclfcnsDebug {level msg} {}

proc TclfcnsDebug {level msg} {
	variable data

	if {$level <= $data(tclfcns_debug)} {
		puts stderr "TCLFCN:$msg:"
	}
}

# **************************** InitLog *********************************

proc InitLog {} {
	variable data

	set data(send_debug) 0
	set data(binary_send_debug) 0
	set data(_debug) 0
	set data(send_binary) 1
	set data(reflection_debug) 0
	set data(command_debug) 0
	set data(invoke_debug) 0
	set data(tclfcns_debug) 0
	set data(unmarshal_debug) 0
	set rest_args [list]
	foreach arg $::argv {
		set have_rest_arg 1
		if {[string compare $arg "-urtp_binary"] == 0} {
			set data(send_binary) 1
			set have_rest_arg 0
		}
		if {[string compare $arg "-urtp_debug"] == 0} {
			set data(_debug) 1
			set have_rest_arg 0
		}
		if {[string compare $arg "-urtp_send_debug"] == 0} {
			set data(send_debug) 1
#			rename [namespace current]::SendDebug {}
#			rename [namespace current]::_SendDebug [namespace current]::SendDebug
			set have_rest_arg 0
		}
		if {[string compare $arg "-urtp_binary_send_debug"] == 0} {
			set data(binary_send_debug) 1
#			rename [namespace current]::BinarySendDebug {}
#			rename [namespace current]::_BinarySendDebug [namespace current]::BinarySendDebug
			set have_rest_arg 0
		}
		if {[string compare $arg "-urtp_command_debug"] == 0} {
			set data(command_debug) 1
#			rename [namespace current]::CommandDebug {}
#			rename [namespace current]::_CommandDebug [namespace current]::CommandDebug
			set have_rest_arg 0
		}
		if {[string compare $arg "-urtp_unmarshal_debug"] == 0} {
			set data(unmarshal_debug) 1
#			rename [namespace current]::UnmarshalDebug {}
#			rename [namespace current]::_UnmarshalDebug [namespace current]::UnmarshalDebug
			set have_rest_arg 0
		}
		if {[string compare $arg "-urtp_reflection_debug"] == 0} {
			set data(reflection_debug) 1
#			rename [namespace current]::ReflectionDebug {}
#			rename [namespace current]::_ReflectionDebug [namespace current]::ReflectionDebug
			set have_rest_arg 0
		}
		if {[string compare $arg "-urtp_invoke_debug"] == 0} {
			set data(invoke_debug) 1
#			rename [namespace current]::InvokeDebug {}
#			rename [namespace current]::_InvokeDebug [namespace current]::InvokeDebug
			set have_rest_arg 0
		}
		if {[string compare $arg "-urtp_tclfcns_debug"] == 0} {
			set data(tclfcns_debug) 1
#			rename [namespace current]::TclfcnsDebug {}
#			rename [namespace current]::_TclfcnsDebug [namespace current]::TclfcnsDebug
			set have_rest_arg 0
		}
		if {$have_rest_arg} {
			lappend rest_args $arg
		}
	}
	set ::argv $rest_args
}

}
