#*************************************************************************
#*
#*  $RCSfile: invoke.tcl,v $
#*
#*  $Revision: 1.16 $
#*
#*  last change: $Author: wiede $ $Date: 2005/12/21 20:36:53 $
#*
#*  The Contents of this file are made available subject to the terms of
#*  the following license
#*
#* 	- BSD License
#*
#*	see file license.terms in this directory
#*
#*  Copyright 2005 Arnulf Wiedemann
#*
#*  Author: Arnulf Wiedemann
#*
#*  Contributor(s): 
#*
#************************************************************************/

namespace eval ::tclUrtpBridge {

# **************************** _HandleSequenceArg **********************

proc _HandleSequenceArg {arg param_type} {
	variable data
	variable remote_type_cache
	variable remote_type_cache_names
	variable remote_object_cache
	variable remote_type_cache_names
	variable remote_object_types
	variable generated_command_infos
	variable generated_sequence_sizes

	set cmd [list]
  	regsub {::tclUrtpBridge::sequence_} $arg {} my_cmd_idx
	set sequence_infos $generated_command_infos($my_cmd_idx)
	foreach {size_info type_info} [lindex $sequence_infos 0] break
	set num_dimensions 0
	foreach {type1 name1} $type_info break
	switch $param_type {
	any {
	  	set name $name1
	  }
	default {
		set name $param_type
		set open_bracket "\["
		set close_bracket "\]"
		while {[regexp "^\[$open_bracket\]\[$close_bracket\]" $name]} {
			set name [string range $name 2 end]
			incr num_dimensions
		}
	  }
	}
	foreach {type1 my_seq_id} $size_info break
	set sequence_size $generated_sequence_sizes($my_seq_id)
	switch $name {
	long -
	double -
	string {
		if {![info exists remote_type_cache($name)]} {
			set my_type_idx [makeNewTypeCacheEntry $name]
		}
		set my_type_idx $remote_type_cache($name)
		lappend cmd [list TYPE_CLASS SEQUENCE NEW]
		lappend cmd [list TYPE_CACHE_INDEX $my_type_idx]
		set cnt $num_dimensions
		set prefix [string repeat "\[\]" $num_dimensions]

		lappend cmd [list CLASS_NAME ${prefix}$name]
		set my_entry_infos [list]
		set entry_infos [lrange $sequence_infos 1 end]
		set my_lgth [llength $entry_infos]
		lappend cmd [list SEQUENCE_SIZE $my_lgth]
		set my_upper_type [string toupper $name]
		foreach entry $entry_infos {
			if {$num_dimensions > 1} {
				lappend cmd [list SEQUENCE_SIZE $num_dimensions]
				set idx 0
InvokeDebug 1 "SEQ:ENTRY:$entry:"
				while {$idx < $num_dimensions} {
					set sub_entry [lindex $entry $idx]
InvokeDebug 1 "SEQ:SUB_ENTRY:$sub_entry:"
					foreach {entry1 entry2} $sub_entry break
					foreach {my_type my_value} $entry2 break
					set my_entry [list $my_upper_type $my_value]
InvokeDebug 1 "SEQ:MY_ENTRY:2:$my_entry:"
					lappend cmd $my_entry
					incr idx
				}
			} else {
				foreach {entry1 entry2} $entry break
				foreach {my_type my_value} $entry2 break
				set my_entry [list $my_upper_type $my_value]
InvokeDebug 1 "SEQ:MY_ENTRY:3:$my_entry:"
				lappend cmd $my_entry
			}
		}
	  }
	default {
		if {![info exists remote_type_cache($name)]} {
			set my_type_idx [makeNewTypeCacheEntry $name]
		}
		set my_type_idx $remote_type_cache($name)
		lappend cmd [list TYPE_CLASS SEQUENCE NEW]
		lappend cmd [list TYPE_CACHE_INDEX $my_type_idx]
		lappend cmd [list CLASS_NAME \[\]$name]
		set entry_infos [lrange $sequence_infos 1 end]
		lappend cmd [list SEQUENCE_SIZE [llength $entry_infos]]
		foreach entry $entry_infos {
InvokeDebug 1 "SEQ:ENTRY:$entry:"
			foreach sub_entry $entry {
InvokeDebug 1 "SEQ:SUB_ENTRY:$sub_entry:"
				foreach {my_type my_value} $sub_entry break
				switch $my_type {
				SEQUENCE {
				  	switch -glob $my_value {
					::tclUrtpBridge::sequence_* {
						set cmd [lrange $cmd 0 end-1]
						set my_cmd [_HandleSequenceArg $my_value $param_type]
						set cmd [concat $cmd $my_cmd]
					  }
					default {
					  	puts stderr "ERROR: STRUCT $my_value not yet implemented"
					  }
					}
				  }
				STRUCT {
				  	switch -glob $my_value {
					::tclUrtpBridge::struct_* {
						set cmd [lrange $cmd 0 end-1]
						set my_cmd [handleStructParam $my_value 1]
						set cmd [concat $cmd $my_cmd]
					  }
					default {
					  	puts stderr "ERROR: STRUCT $my_value not yet implemented"
					  }
					}
				  }
				default {
					lappend cmd $sub_entry
				  }
				}
			}
		}
	  }
	}
	return $cmd
}

# **************************** tclArg2Any ******************************

proc tclArg2Any {value param_mode param_type} {
	variable data
	variable remote_object_cache
	variable remote_type_cache

	set my_result [list]
	switch $param_mode {
	OUT {
		lappend my_result [list TYPE_CLASS STRING]
	  	lappend my_result [list STRING [list]]
	  }
	default {
	  	switch $param_type {
		short -
		long -
		hyper -
		float -
		double -
		enum {
			set my_type [string toupper $param_type]
			lappend my_result [list TYPE_CLASS $my_type]
		  	lappend my_result [list $my_type $value]
		  }
		byte -
		char -
		string {
			set value [encoding convertto utf-8 $value]
			set my_type [string toupper $param_type]
			lappend my_result [list TYPE_CLASS $my_type]
		  	lappend my_result [list $my_type $value]
		   }
		boolean {
		  	if {$value} {
				set value True
			} else {
				set value False
			}
			set my_type [string toupper $param_type]
			lappend my_result [list TYPE_CLASS $my_type]
		  	lappend my_result [list $my_type $value]
		  }
		"unsigned short" -
		"unsigned long" -
		"unsigned hyper" {
		  	regsub { } $param_type {_} my_type
			set my_type [string toupper $my_type]
			lappend my_result [list TYPE_CLASS $my_type]
		  	lappend my_result [list $my_type $value]
		  }
		type {
#		  	puts stderr "ERROR: tclArg2Any:param_type:$param_type not yet implemented!! param_mode:$param_mode:value:$value:"
			foreach {type_class type_value} $value break
			if {![info exists remote_type_cache($type_value)]} {
				set my_result_infos [queryInterface $data(handle_oid) $type_value]
puts stderr "MM:$my_result_infos:"
			}
			set my_type_cache_idx $remote_type_cache($type_value)
			lappend my_result [list TYPE_CLASS TYPE]
			lappend my_result [list TYPE_CLASS $type_class]
			lappend my_result [list TYPE_CACHE_INDEX $my_type_cache_idx]
		  }
		any {
			if {[string is integer $value]} {
				# should optimize for short etc!!
				# need handling of HYPER !!
				set type LONG
				if {($value > -32767) && ($value < 32767)} {
					set type SHORT
				}
				lappend my_result [list TYPE_CLASS $type]
				lappend my_result [list $type $value]
			} else {
			    if {[string is double $value]} {
				# should optimize for float etc!!
				lappend my_result [list TYPE_CLASS DOUBLE]
				lappend my_result [list DOUBLE $value]
			    } else {
				# need to check for special ::tclUrtpBridge::* !!
				switch -glob $value {
				True -
				False {
					lappend my_result [list TYPE_CLASS BOOLEAN]
					lappend my_result [list BOOLEAN $value]
				  }
				::tclUrtpBridge::handle_* {
puts stderr "ERROR:tclarg2Any:ANY:$value: not yet implemented completly!!"
					set my_oid [getHandleObjectInfo $value]
					lappend my_result [list TYPE_CLASS ANY]
					lappend my_result [list OBJECT_ID $my_oid]
					lappend my_result [list OBJECT_CACHE_INDEX $remote_object_cache($oid)]
				  }
				default {
					set value [encoding convertto utf-8 $value]
					lappend my_result [list TYPE_CLASS STRING]
					lappend my_result [list STRING $value]
			    	  }
				}
			    }
			}
		  }
		typedef {
		  	puts stderr "ERROR: tclArg2Any:param_type:$param_type not yet implemented!!"
		  }
		struct {
		  	puts stderr "ERROR: tclArg2Any:param_type:$param_type not yet implemented!!"
		  }
		exception {
		  	puts stderr "ERROR: tclArg2Any:param_type:$param_type not yet implemented!!"
		  }
		sequence {
		  	puts stderr "ERROR: tclArg2Any:param_type:$param_type not yet implemented!!"
		  }
		interface {
		  	puts stderr "ERROR: tclArg2Any:param_type:$param_type not yet implemented!!"
		  }
		default {
		  	puts stderr "ERROR: in tclArg2Any: bad param_type:$param_type:"
		  }
		}
	  }
	}
	return $my_result
}

# **************************** callableCall ****************************

proc callableCall {method_name args} {
	variable data
	variable remote_type_cache
	variable remote_type_cache_names
	variable remote_object_cache
	variable remote_type_cache_names
	variable remote_object_types
	variable generated_command_infos
	variable generated_sequence_sizes

if {0} {
	# next block only for TESTING!!
	set idx 0
	foreach arg $args {
puts stderr "ARG:$idx:$arg:"
		incr idx
		if {[string match "*insertControlCharacter*" $arg]} {
			set my_tmp_oid [queryInterface $data(handle_oid) com.sun.star.text.XSimpleText]
puts stderr "TMP_OID:$my_tmp_oid:"
#			set remote_type_cache_names(23) com.sun.star.sheet.XDataPilotTablesSupplier
#puts stderr "RTC:[join [array names remote_type_cache_names] \n]:"
#			set ret [list [list TYPE [list [list TYPE_CLASS INTERFACE] [list TYPE_CACHE_INDEX 23]]] [list NEW_OBJECT_ID [list [list OBJECT_ID $my_tmp_oid] [list OBJECT_CACHE_INDEX 158]]]]
#puts stderr "RET:$ret:"
#			return $ret
		}
	}
}
	set param_infos [list]
	set method_handle_type $data(handle_type)
	set num_params [getNumMethodParameters $method_handle_type $method_name]
	set return_type_name [getMethodReturnTypeName $method_handle_type $method_name]
	set return_type_class [getMethodReturnTypeClass $method_handle_type $method_name]
	set method_mode [getMethodMode $method_handle_type $method_name]
	set data(handle_type) $method_handle_type
	if {[llength $args] != $num_params} {
			return error "wrong number args: [llength $args]: should be [llength $parameter_infos]!"
	}
	switch $method_name {
	queryInterface {
		set interface_infos [lindex $args 0]
		foreach {type my_interface_name} $interface_infos break
	  	set my_oid [queryInterface $data(handle_oid) $my_interface_name]
		set my_result_infos [list]
		lappend my_result_infos [list TYPE_CLASS INTERFACE]
		lappend my_result_infos [list VALUE $my_interface_name]
		lappend my_result_infos [list OBJECT_ID $my_oid]
		return $my_result_infos
	  }
	}
	set cmd [list]
	lappend cmd callMethod
	lappend cmd $data(invocation_oid)
	lappend cmd com.sun.star.script.XInvocation
	lappend cmd invoke 
	lappend cmd [list STRING $method_name]
	lappend cmd [list SEQUENCE_SIZE $num_params]
	set idx 0
	foreach arg $args {
InvokeDebug 1 "Handle Arg:$idx:$arg:$method_handle_type:$method_name:"
		set parameter_info [getMethodParameterInfo $method_handle_type $method_name $idx]
		foreach {param_type param_name param_mode} $parameter_info break
InvokeDebug 1 "MEARG:$arg:PARAM_NAME:$param_name:PARAM_TYPE:$param_type:"
		switch -glob -- $arg {
		::tclUrtpBridge::handle_* {
			set my_oid2 [getHandleObject $arg]
			switch $param_type {
			string {
				lappend cmd [list TYPE_CLASS STRING]
				lappend cmd [list STRING $arg]
			  }
			any {
				lappend cmd [list TYPE_CLASS INTERFACE]
				set my_type_cache_index $remote_type_cache($data(handle_type))
				lappend cmd [list TYPE_CACHE_INDEX $my_type_cache_index]
				lappend cmd [list OBJECT_ID $my_oid2]
				set my_oid_idx $remote_object_cache($my_oid2)
				lappend cmd [list OBJECT_CACHE_INDEX $my_oid_idx]
			  }
			default {
			set is_new 0
			if {![info exists remote_type_cache($param_type)]} {
				set my_oid [queryInterface $my_oid2 $param_type]
				set is_new 1
			} else {
			    if {![info exists remote_object_types($param_type)]} {
				set my_oid [queryInterface $my_oid2 $param_type]
				set is_new 1
			    } else {
				set my_oid $data(handle_oid)
			    }
			}
			if {$is_new} {
				lappend cmd [list TYPE_CLASS INTERFACE NEW]
			} else {
				lappend cmd [list TYPE_CLASS INTERFACE]
			}
			set type_idx $remote_type_cache($param_type)
			lappend cmd [list TYPE_CACHE_INDEX $type_idx]
			if {$is_new} {
				lappend cmd [list CLASS_NAME $param_type]
			}
			lappend cmd [list OBJECT_ID [list]]
			set my_oid_idx $remote_object_cache($my_oid)
			lappend cmd [list OBJECT_CACHE_INDEX $my_oid_idx]
			  }
			}
InvokeDebug 1 "MEARG:$arg:handle handled:"
		  }
		::tclUrtpBridge::struct_* {
			set cmd [concat $cmd [handleStructParam $arg 1]]
InvokeDebug 1 "MEARG:$arg:struct handled:"
		  }
		::tclUrtpBridge::special_* {
		  	regsub {::tclUrtpBridge::special_} $arg {} my_cmd_idx
			set special_infos $generated_specials($my_cmd_idx)
		  }
		::tclUrtpBridge::sequence_* {
			set cmd [concat $cmd [_HandleSequenceArg $arg $param_type]]
InvokeDebug 1 "MEARG:$arg:sequence handled:$cmd:"
		  }
		default {
			set param [tclArg2Any $arg $param_mode $param_type]
			set cmd [concat $cmd $param]
		  }
		}
InvokeDebug 1 "PARAM:$idx:END"
		incr idx
	}
InvokeDebug 1 "INVOKE:1:$cmd:"
	set result_infos [eval $cmd]
InvokeDebug 1 "INVOKE:RESULT:[llength $result_infos]:$result_infos:"
	if {!$data(send_binary)} {
		set data(out_params_infos) [lrange $result_infos end-1 end]
		if {[string compare "[list SEQUENCE [list [list SEQUENCE_SIZE 0] [list [list]]]]" [lindex $data(out_params_infos) 0]] != 0} {
			puts stderr "ERROR: need to handle out_param_info!!:[llength $result_infos]:$result_infos:$data(out_params_infos):"
		}
		set result_infos [lrange $result_infos 0 end-2]
	} else {
		# FIXME for data(send_binary)!!
		set data(out_params_infos) [list]
	}
InvokeDebug 1 "INVOKE:result_infos:$result_infos:"
	return $result_infos
}

}
