#*************************************************************************
#*
#*  $RCSfile: helpers.tcl,v $
#*
#*  $Revision: 1.14 $
#*
#*  last change: $Author: wiede $ $Date: 2005/11/26 22:21:19 $
#*
#*  The Contents of this file are made available subject to the terms of
#*  the following license
#*
#* 	- BSD License
#*
#*	see file license.terms in this directory
#*
#*  Copyright 2005 Arnulf Wiedemann
#*
#*  Author: Arnulf Wiedemann
#*
#*  Contributor(s): 
#*
#************************************************************************/

namespace eval ::tclUrtpBridge {

# **************************** _getValueFromTypeValueEntry ************

proc _getValueFromTypeValueEntry {lst type fcn_name} {
	variable data

	set my_type [lindex $lst 0]
#puts stderr "_getValueFromTypeValueEntry:$type:$my_type:$lst:$fcn_name:"
	switch -glob -- $type {
	unsigned* -
	UNSIGNED* {
		set value [lrange $lst 1 2]
	  }
	default {
		set value [lindex $lst 1]
	  }
	}
	if {[llength $lst] == 3} {
		# special case of "unsigned ..." !!
		set value [lrange $lst 1 2]
	}
	regsub -all UNSIGNED_ $my_type {UNSIGNED } my_type
	regsub -all unsigned_ $my_type {unsigned } my_type
	if {[string compare $my_type $type] != 0} {
		puts stderr "ERROR: $fcn_name:expected type:$type:got:$my_type:infos:$lst:"
		error "" "$fcn_name:expected type:$type:got:$my_type:infos:$lst:"
	}
	return $value
}

# **************************** getTypeClassName ************************

proc _getTypeClassName {lst} {
	variable data

	foreach {type_info value_info} $lst break
	return [_getValueFromTypeValueEntry $type_info TYPE_CLASS getTypeClassName]
}

# **************************** getTypeClassValue ***********************

proc _getTypeClassValue {lst} {
	variable data
	
	foreach {type_info value_info} $lst break
	return [_getValueFromTypeValueEntry $value_info VALUE getTypeClassValue]
}

# **************************** getObjectCacheIndex *********************

proc getObjectCacheIndex {lst} {
	variable data

	set ret [getValueFromTypeValueEntry $lst OBJECT_CACHE_INDEX getObjectCacheIndex]
	return $ret
}

# **************************** getTypeClassedValue *********************

proc getTypeClassedValue {type_class lst} {
	variable data

	foreach {type_info value_info} $lst break
#puts stderr "getTypeClassedValue:$type_class:$type_info:$lst:"
	set value [_getValueFromTypeValueEntry $type_info TYPE_CLASS get${type_class}Value]
	regsub UNSIGNED_ $value {UNSIGNED } value
	regsub unsigned_ $value {unsigned } value
	regsub UNSIGNED_ $type_class {UNSIGNED } type_class
	regsub unsigned_ $type_class {unsigned } type_class
	if {[string compare $value $type_class] != 0} {
		puts stderr "ERROR: get${type_class}Value:expected:$type_class:got:$value:info:$lst:"
	}
	return [_getValueFromTypeValueEntry $value_info VALUE get${type_class}Value]
}

# **************************** getStringValue **************************

proc getStringValue {lst} {
	variable data

	return [getTypeClassedValue STRING $lst]
}

# **************************** getDoubleValue **************************

proc getDoubleValue {lst} {
	variable data

	return [getTypeClassedValue DOUBLE $lst]
}

# **************************** getShortValue ****************************

proc getShortValue {lst} {
	variable data

	return [getTypeClassedValue SHORT $lst]
}

# **************************** getLongValue ****************************

proc getLongValue {lst} {
	variable data

	return [getTypeClassedValue LONG $lst]
}

# **************************** getBooleanValue *************************

proc getBooleanValue {lst} {
	variable data

	return [getTypeClassedValue BOOLEAN $lst]
}

# **************************** getEnumValue ****************************

proc getEnumValue {lst} {
	variable data

	return [getTypeClassedValue ENUM $lst]
}

# **************************** getNextObjectTypeIndex ******************

proc getNextObjectTypeIndex {} {
	variable data

#	if {[llength $data(free_object_type_indexes)] > 0} {
#		set my_idx [lindex $data(free_object_type_indexes) 0]
#		set data(free_object_type_indexes) [lrange $data(free_object_type_indexes) 1 end]
#		return $my_idx
#	} else {
		incr data(max_object_type_index)
		return $data(max_object_type_index)
#	}
}

# **************************** getIndexObjectType **********************

proc getIndexObjectType {idx} {
	variable data
	variable index_object_types

	if {[info exists index_object_types($idx)]} {
		return $index_object_types($idx)
	} else {
		return $data(unknown_info)
	}
}

# **************************** storeIndexObjectType ********************

proc storeIndexObjectType {object_id type_id idx} {
	variable data
	variable index_object_types

	if {[info exists index_object_types($object_id,$type_id)]} {
		set my_info $index_object_types($idx)
		foreach {my_object_id my_type_id} $my_info break
		if {[string compare $my_object_id $object_id] != 0} {
			puts stderr "different object_id in storeIndexObjectType:$my_object_id<->$object_id: for index $idx:"
		}
		if {[string compare $my_type_id $type_id] != 0} {
			puts stderr "different type_id in storeIndexObjectType:$my_type_id<->$type_id: for index $idx:"
		}
	} else {
		set index_object_types($idx) [list $object_id $type_id]
	}
}

# **************************** getObjectTypeIndex **********************

proc getObjectTypeIndex {object_id type_id} {
	variable data
	variable object_type_indexes

	if {[info exists object_type_indexes($object_id,$type_id)]} {
		return $object_type_indexes($object_id,$type_id)
	} else {
		return -1
	}
}

# **************************** storeObjectTypeIndex ********************

proc storeObjectTypeIndex {object_id type_id} {
	variable data
	variable object_type_indexes
	variable remote_object_types
	variable remote_type_objects

	if {![info exists object_type_indexes($object_id,$type_id)]} {
		set my_idx [getNextObjectTypeIndex]
		set object_type_indexes($object_id,$type_id) $my_idx
		storeIndexObjectType $object_id $type_id $my_idx
	}
	set remote_object_types($object_id) $type_id
	set remote_type_objects($type_id) $object_id
}

# **************************** getSequenceSize *************************

proc getSequenceSize {lst} {
	variable data

	return [_getValueFromTypeValueEntry $lst SEQUENCE_SIZE getSequenceSize]
}

# **************************** getSequenceElemInfos ********************

proc getSequenceElemInfos {lst} {
	set lst [lindex $lst 0]
	set infos [_getValueFromTypeValueEntry $lst SEQUENCE getSequenceElemInfos]
	foreach {size_info elem_infos} $infos break
	set num_entries [_getValueFromTypeValueEntry $size_info SEQUENCE_SIZE getSequenceElemInfos]
	if {$num_entries != [llength $elem_infos]} {
		if {$num_entries > 0} {
			puts stderr "ERROR: getSequenceElemInfos have SEQUENCE_SIZE:$num_entries: and got:[llength $elem_infos] elements!!:"
		}
	}
	set ret [list]
	if {$num_entries == 0} {
		return [list $num_entries $ret]
	}
	return [list $num_entries $elem_infos]
}

# **************************** getSequenceParamInfos *******************

proc getSequenceParamInfos {lst} {
	set my_infos [getSequenceElemInfos $lst]
	foreach {num_entries elem_infos} $my_infos break
	set ret [list]
	if {$num_entries == 0} {
		return $ret
	}
	foreach entry $elem_infos {
		# strip off struct info !!
		set entry [lindex $entry 2]
		set entry [lindex $entry 0]
		foreach {name_info mode_info object_info} $entry break
		set name [getStringValue $name_info]
		set mode_value [getTypeClassedValue ENUM $mode_info]
		switch $mode_value {
		0 {
			set mode IN
		  }
		1 {
			set mode OUT
		  }
		2 {
			set mode INOUT
		  }
		default {
			puts stderr "ERROR: bad mode:$mode_value:"
		  	set mode $data(unknown_info)
		  }
		}
		set my_oid [getNewRemoteObjectCacheInfo $object_info]
		lappend ret [list $name $mode $my_oid]
	}
	return $ret
}

# **************************** getSequenceObjects **********************

proc getSequenceObjects {interface_name lst} {
	variable data
	variable remote_object_cache_names
	variable remote_object_types

	set my_infos [getSequenceElemInfos $lst]
	foreach {num_entries elem_infos} $my_infos break
	set ret [list]
	if {$num_entries == 0} {
		return $ret
	}
	foreach entry $elem_infos {
		set my_oid [storeObjectInfo $interface_name $entry]
		lappend ret $my_oid
	}
	return $ret
}

# **************************** getSequenceEnums ************************

proc getSequenceEnums {lst} {
	set my_infos [getSequenceElemInfos $lst]
	foreach {num_entries elem_infos} $my_infos break
	set ret [list]
	if {$num_entries == 0} {
		return $ret
	}
	foreach entry $elem_infos {
		set val [getLongValue $entry]
		lappend ret $val
	}
	return $ret
}

# **************************** getSequencePropertyNames ****************

proc getSequencePropertyNames {lst} {
	set my_infos [getSequenceElemInfos $lst]
	foreach {num_entries elem_infos} $my_infos break
	set ret [list]
	if {$num_entries == 0} {
		return $ret
	}
	foreach entry $elem_infos {
		foreach {name_info handle_info type_info attribute_info} $entry break
		set name [getStringValue $name_info]
#puts stderr "NN:$name:$name_info:"
		lappend ret $name
	}
	return $ret
}

# **************************** getSequenceStrings **********************

proc getSequenceStrings {lst} {
	set my_infos [getSequenceElemInfos $lst]
	foreach {num_entries elem_infos} $my_infos break
	set ret [list]
	if {$num_entries == 0} {
		return $ret
	}
	foreach entry $elem_infos {
		lappend ret [getStringValue $entry]
	}
	return $ret
}

# **************************** getNewRemoteObjectCacheInfo ***************

proc getNewRemoteObjectCacheInfo {lst} {
	variable data
	variable remote_object_cache_names
	variable remote_object_types

	set my_infos [checkForNewObject $lst]
	foreach {object_info dummy} $my_infos break
	foreach {type my_oid} [lindex $object_info 0] break
	set my_type $data(object_id_interface)
#puts stderr "my_oid:$my_oid:$data(curr_interface_name):$data(curr_method_name):$my_type:"
	set remote_object_types($my_oid) $my_type
	return $my_oid
}

# **************************** getRemoteTypeCacheInfo ******************

proc getRemoteTypeCacheInfo {lst} {
	variable data

	set my_infos [checkForNewType $lst]
	foreach {my_result infos} $my_infos break
	return [list $data(new_type_name) $data(remote_type_cache_index)]
}

# **************************** getRemoteSequenceTypeNames **************

proc getRemoteSequenceTypeNames {lst} {
	variable data
	variable remote_type_cache_names

	set my_infos [getSequenceElemInfos $lst]
	foreach {num_entries elem_infos} $my_infos break
	set ret_lst [list]
	foreach entry $elem_infos {
		set my_info [getRemoteTypeCacheInfo $entry]
		foreach {my_class_name my_idx} $my_info break
		lappend ret_lst $my_class_name
	}
	return $ret_lst
}

}
