#*************************************************************************
#*
#*  $RCSfile: bridge_commands.tcl,v $
#*
#*  $Revision: 1.31 $
#*
#*  last change: $Author: wiede $ $Date: 2005/12/25 15:55:07 $
#*
#*  The Contents of this file are made available subject to the terms of
#*  the following license
#*
#* 	- BSD License
#*
#*	see file license.terms in this directory
#*
#*  Copyright 2005 Arnulf Wiedemann
#*
#*  Author: Arnulf Wiedemann
#*
#*  Contributor(s): 
#*
#************************************************************************/

namespace eval ::tclUrtpBridge {

# **************************** CreateCommand ***************************

proc CreateCommand {type args} {
	variable data
	variable generated_command_infos

	set my_cmd_name [namespace current]::${type}_$data(generated_command_index)
	set cmd "proc $my_cmd_name {args} {
	variable data
	eval [namespace current]::HandleGeneratedCommand $data(generated_command_index) $my_cmd_name \$args
}
"
	lappend data(generated_commands) $my_cmd_name
	eval set generated_command_infos($data(generated_command_index)) \$args
	eval $cmd
	incr data(generated_command_index)
	return $my_cmd_name
}

# **************************** CheckIsTclunoCommand ********************

proc CheckIsTclunoCommand {command args} {
	variable data
	variable special_commands

	set my_command $command
	if {![string match "::*" $my_command]} {
		set my_command "::$my_command"
	}
	foreach entry $special_commands {
		foreach {full_cmd_name num_args cmd_name usage_info} $entry break
		if {[string compare $my_command $full_cmd_name] == 0} {
			if {[llength $args] != $num_args} {
				error "wrong # args: usage: $full_cmd_name $usage_info"
				set data(command_execution_result) ""
			} else {
				set data(command_execution_result) [eval [namespace current]::$cmd_name $args]
			}
			return true
		}
	}
	return false
}

# **************************** checkHasMethod **************************

proc checkHasMethod {method_name} {
	variable data

	set result_infos [callMethod $data(invocation_oid) com.sun.star.script.XInvocation hasMethod [list STRING $method_name]]
	set ret [getBooleanValue [lindex $result_infos 0]]
	return $ret
}

# **************************** checkHasProperty ************************

proc checkHasProperty {property_name} {
	variable data

	set result_infos [callMethod $data(invocation_oid) com.sun.star.script.XInvocation hasProperty [list STRING $property_name]]
	set ret [getBooleanValue [lindex $result_infos 0]]
	return $ret
}

# **************************** getBaseTypeReturnValue ******************

proc getBaseTypeReturnValue {type_name infos} {
	variable data
	variable remote_type_cache_names

CommandDebug 1 "getBaseTypeReturnValue:$type_name:$data(primary_return_type_name):$data(primary_return_class_name):$infos:"
	switch $type_name {
	VOID {
	  	return [list]
	  }
	CHAR -
	BOOLEAN -
	"UNSIGNED SHORT" -
	"UNSIGNED LONG" -
	BYTE -
	SHORT -
	LONG -
	FLOAT -
	DOUBLE -
	STRING {
		set value [getTypeClassedValue $type_name $infos]
CommandDebug 1 "getBaseTypeReturnValue:END:$type_name:$value:"
		return $value
	  }
	"UNSIGNED_SHORT" {
		set value [getTypeClassedValue $type_name $infos]
CommandDebug 1 "getBaseTypeReturnValue:END:$type_name:$value:"
		return $value
	  }
	"UNSIGNED_LONG" {
		set value [getTypeClassedValue $type_name $infos]
CommandDebug 1 "getBaseTypeReturnValue:END:$type_name:$value:"
		return $value
	  }
	ENUM {
		set val [getTypeClassedValue $type_name $infos]
		set value $remote_type_cache_names($val)
		return $value
	  }
	SEQUENCE {
		return [getSequenceReturnValues $data(primary_return_class_name) [list $infos]]
	  }
	STRUCT {
		# strip off struct type info
		set infos [lindex $infos 2]
		set infos [lindex $infos 0]
		return [getStructReturnValues $data(primary_return_class_name) $infos]
	  }
	default {
	  	puts stderr "ERROR: getBaseTypeReturnValue:$type_name:not yet implemented:infos:$infos:"
dumpRemoteTypeCache
	  	return $data(unknown_info)
	  }
	}
}

# **************************** getStructReturnValues *******************

proc getStructReturnValues {my_class_name elem_infos} {
	variable data
	variable remote_type_cache_names
	variable struct_infos
	variable enum_infos

CommandDebug 1 "getStructReturnValues:$my_class_name:"
	set ret_lst [list]
CommandDebug 1 "elem_infos:$elem_infos:"
	if {![info exists struct_infos($my_class_name)]} {
		getInterfaceStructInfos $my_class_name
	}
  	set my_struct_infos $struct_infos($my_class_name)
	set entry $elem_infos
CommandDebug 1 "ENTRY:$entry:"
	set cnt 0
	set entry_lst [list]
	foreach my_entry $my_struct_infos {
CommandDebug 1 "my_entry:$my_entry:"
		if {[llength $my_entry] > 2} {
			foreach {struct_elem_type1 struct_elem_type2 struct_elem_name} $my_entry break
			set struct_elem_type "$struct_elem_type1 $struct_elem_type2"
		} else {
			foreach {struct_elem_type struct_elem_name} $my_entry break
		}
		set my_struct_elem_type [string toupper $struct_elem_type]
		set my_info [lindex $entry $cnt]
CommandDebug 1 "STRUELEM:$struct_elem_type:$struct_elem_name:$cnt:$my_info:"
		switch $my_struct_elem_type {
		CHAR -
		ENUM -
		BYTE -
		BOOLEAN -
		"UNSIGNED SHORT" -
		"UNSIGNED LONG" -
		SHORT -
		LONG -
		FLOAT -
		DOUBLE {
		  	set my_value [getBaseTypeReturnValue $my_struct_elem_type $my_info]
		  }
		STRING {
		  	set my_value [getBaseTypeReturnValue $my_struct_elem_type $my_info]
		  }
		ANY {
			foreach {type_info value_info} $my_info break
			foreach {type1 my_elem_type} $type_info break
			switch $my_elem_type {
			"UNSIGNED SHORT" -
			"UNSIGNED LONG" -
			CHAR -
			ENUM -
			BOOLEAN -
			BYTE -
			SHORT -
			LONG -
			FLOAT -
			DOUBLE {
		  		set my_value [getBaseTypeReturnValue $my_elem_type $my_info]
			  }
			STRING {
			  	set my_value [getBaseTypeReturnValue $my_elem_type $my_info]
			  }
			STRUCT {
				set my_info [lindex $my_info 2]
				set my_info [lindex $my_info 0]
				foreach {type2 my_elem_type} $value_info break
			  	set my_value [getStructReturnValues $my_elem_type $my_info]
			  }
		  	default {
				puts stderr "ERROR: FUNNY TYPE for type ANY:$my_elem_type!!:$my_info:"
			  	set my_value $data(unknown_info)
			  }
			}
		  }
		TYPE {
			foreach {type_info value_info} $my_info break
			foreach {type1 type} $type_info break
			foreach {type2 val1} $value_info break
			switch $type {
			xTYPE -
			xNEW_TYPE {
			  	set my_info2 [getRemoteTypeCacheInfo $my_info]
			  	foreach {class_name my_idx} $my_info2 break
				set my_value $class_name
			  }
			INTERFACE {
			  	set my_value $remote_type_cache_names($val1)
			  }
			TYPE {
			  	set my_value [string tolower $val1]
			  }
			default {
				puts stderr "ERROR: FUNNY TYPE for type TYPE:$type!!"
			  	set my_value $data(unknown_info)
			  }
			}
		  }
		default {
			set my_type [lindex $my_entry 0]
			if {[info exists enum_infos($my_type)]} {
				set base_type ENUM
			} else {
				if {[info exists struct_infos($my_type)]} {
					set base_type STRUCT
				} else {
					set base_type [getInterfaceType $my_type $data(handle_introspection_oid)]
				}
			}
			switch $base_type {
			ENUM {
				set my_val [getTypeClassedValue ENUM $my_info]
				if {![info exists enum_infos($my_type)]} {
					getInterfaceEnumInfos $my_type
				}
				foreach my_entry $enum_infos($my_type) {
					foreach {my_value enum_value} $my_entry break	
					if {$my_val == $enum_value} {
						break
					}
				}
			  	
			  }
			STRUCT {
				# strip off struct type info
				set my_info [lindex $my_info 2]
				set my_info [lindex $my_info 0]
			  	set my_value [getStructReturnValues $my_type $my_info]
			  }
			TYPEDEF {
			  	foreach {type_info value_info} $my_info break
				foreach {type1 type_name} $type_info break
				switch $type_name {
				LONG -
				SHORT -
				CHAR {
					set my_value [getTypeClassedValue $type_name $my_info]
				  }
				default {
					puts stderr "ERROR: TYPEDEF:$type_name not yet implemented!!"
				  	set my_value -1
				  }
				}
			  }
			default {
		  		puts stderr "ERROR: funny my_struct_elem_type:$my_struct_elem_type!!base_type:$base_type:$my_entry:$my_info:"
				set my_value $data(unknown_info)
			  }
		  	}
		  }
		}
		lappend entry_lst [list $struct_elem_name $my_value]
		incr cnt
	}
  	lappend ret_lst [list $my_class_name $entry_lst]
	return $ret_lst
}

# **************************** getSequenceReturnValues *****************

proc getSequenceReturnValues {my_class_name ret_infos} {
	variable data
	variable type_type_classes
	variable remote_type_cache_names

CommandDebug 1 "getSequenceReturnValues:$my_class_name:$ret_infos:"
	set ret_lst [list]
	set my_infos [getSequenceElemInfos $ret_infos]
CommandDebug 1 "SEQEL:$my_infos:"
	switch $my_class_name {
	BYTE {
		set my_type_class $my_class_name
	  }
	default {
		set my_type_class [getTypeClassFromName $my_class_name]
	  }
	}
	foreach {num_entries elem_infos} $my_infos break
	set idx 0
	while {$idx < $num_entries} {
		set my_elem_infos [lindex $elem_infos $idx]
CommandDebug 1 "ST:getSequenceReturnValues:$my_type_class:$my_class_name:$my_elem_infos:"
		switch $my_type_class {
		STRUCT {
			set value [getStructReturnValues $my_class_name $my_elem_infos]
CommandDebug 1 "STRU:VAL:$value:"
			set ret_lst [concat $ret_lst $value]
		  }
		ENUM {
		  	puts stderr "ERROR: in getSequenceReturnValues: my_type_class:$my_type_class not yet implemented!"
		  }
		BYTE {
			set value [getTypeClassedValue $my_type_class $my_elem_infos]
			lappend ret_lst $value
		  }
		STRING {
			# just a kludge for differences between binary and text proctocol!!
			if {[llength $my_elem_infos] == 1} {
				set value [getTypeClassedValue $my_type_class [lindex $my_elem_infos 0]]
			} else {
				set value [getTypeClassedValue $my_type_class $my_elem_infos]
			}
			lappend ret_lst $value
		  }
		CONSTANTS {
		  	puts stderr "ERROR: in getSequenceReturnValues: my_type_class:$my_type_class not yet implemented!"
		  }
		INTERFACE {
		  	puts stderr "ERROR: in getSequenceReturnValues: my_type_class:$my_type_class not yet implemented!"
		  }
		TYPE {
			foreach {type_info cache_info name_info} $my_elem_infos break
			set have_name_info 0
			if {[llength $type_info] == 3} {
				set have_name_info 1
			}
		  	foreach {type1 type_name} $type_info break
			foreach {type2 type_cache_index} $cache_info break
			if {$have_name_info} {
				foreach {type3 type_name} $name_info break
		  	} else {
				set type_name $remote_type_cache_names($type_cache_index)
			}
			lappend ret_lst $type_name
		  	
		  }
		default {
		  	puts stderr "ERROR: funny type_class:$my_type_class in return SEQUENCE!!elem_infos:$elem_infos:"
		  }
		}
		incr idx
	}
CommandDebug 1 "SEQ:ret_lst:$ret_lst:"
	return $ret_lst
}

# **************************** makeObjectCommand ***********************

proc makeObjectCommand {ret_infos} {
	variable data
	variable remote_type_cache
	variable remote_object_cache
	variable remote_object_types
	variable remote_type_objects

CommandDebug 1 "makeObjectCommand:$ret_infos:"
	foreach {type_info value_info object_info} $ret_infos break
	set my_infos [getInterfaceAndObject $ret_infos]
CommandDebug 1 "makeObjectCommand:2:$my_infos:$data(is_tmp_object):"
	foreach {new_class_name my_oid} $my_infos break
	if {$data(is_tmp_object)} {
		set data(is_tmp_object) 0
		return $data(unknown_info)
	}
	set remote_object_types($my_oid) $new_class_name
	set remote_type_objects($new_class_name) $my_oid
	queryInterface $my_oid $new_class_name
	set oid_cache_idx $remote_object_cache($my_oid)
	set return_type_class_value [list [list TYPE_CLASS INTERFACE] [list CLASS_NAME $new_class_name]]
	set return_object_value [list [list OBJECT_CACHE_INDEX $oid_cache_idx] [list OBJECT_ID $my_oid]]
	set type_idx $remote_type_cache($new_class_name)
	set result_infos [callMethod $data(invocation_service_factory) com.sun.star.lang.XSingleServiceFactory createInstanceWithArguments [list SEQUENCE_SIZE 1] [list TYPE_CLASS INTERFACE] [list TYPE_CACHE_INDEX $type_idx] [list OBJECT_ID $my_oid] [list OBJECT_CACHE_INDEX $oid_cache_idx]]
	set my_invocation1_oid [storeObjectInfo com.sun.star.uno.XInterface [lindex $result_infos 0]]
	set invocation_oid [queryInterface $my_invocation1_oid com.sun.star.script.XInvocation2]

	set result_infos [callMethod $invocation_oid com.sun.star.script.XInvocation getIntrospection]
	set my_introspection_oid [storeObjectInfo com.sun.star.uno.XIntrospectionAccess [lindex $result_infos 0]]
  	set ret [CreateCommand handle [list $return_object_value $return_type_class_value [list invocation_oid $invocation_oid] [list introspection_oid $my_introspection_oid]]]
  	return $ret
}

# **************************** getReturnValues *************************

proc getReturnValues {my_interface method_name ret_infos} {
	variable data
	variable remote_object_cache
	variable remote_type_cache_names

	set my_type_class_value [getMethodReturnTypeName $my_interface $method_name]
	set my_type_class [getMethodReturnTypeClass $my_interface $method_name]
	set return_type_class_value [list]
	set return_invocation_oid [list]
	set new_class_name [list]
CommandDebug 1 "GRV:$my_type_class:$my_type_class_value:$ret_infos:"
	switch $my_type_class {
	VOID {
	  	return [list]
	  }
	SEQUENCE {
CommandDebug 1 "GRV:$my_type_class:$my_type_class_value:$ret_infos:"
		switch -glob -- $my_type_class_value {
		\\[\\]* {
			# strip of "[]" chars at beginning
  			set my_class_name [string range $my_type_class_value 2 end]
			if {!$data(send_binary)} {
				# have to unpack the type first !!
		  		storeTypeInfo [lindex $ret_infos 0]
				set ret_infos [lrange $ret_infos 1 end]
		  	}
		  }
		default {
		  	puts stderr "ERROR: in getReturnValues: need handling for my_type_class_value:$my_type_class_value!!"
		  	set my_class_name $my_type_class_value
		  }
		}
		return [getSequenceReturnValues $my_class_name $ret_infos]
	  }
	ANY {
CommandDebug 1 "RV:ANY:$my_type_class_value:$ret_infos:"
		set return_type_name $data(unknown_info)
	  	if {[info exists data(primary_return_type_name)]} {
			set return_type_name $data(primary_return_type_name)
CommandDebug 1 "return_type_name:$return_type_name:"
	  	} else {
			# have to guess from the returned value!
			foreach {type info} [lindex $ret_infos 0] break
			switch $type {
			TYPE {
			  	foreach {type_info1 type_info2} $info break
				foreach {type1 value1} $type_info1 break
				foreach {type2 value2} $type_info2 break
				switch $value1 {
				STRUCT {
					set return_type_name $value1
				  	set data(primary_return_class_name) $remote_type_cache_names($value2)
				  	set ret_infos [lrange $ret_infos 1 end]
				  }
				INTERFACE {
					set return_type_name $value1
				  	set data(primary_return_class_name) $remote_type_cache_names($value2)
				  }
				ENUM {
					set return_type_name $value1
				  	set data(primary_return_class_name) $remote_type_cache_names($value2)
				  }
				default {
					puts stderr "ERROR: in getReturnValues:ANY:TYPE:unexpected type_class:$value1 in TYPE info!"
				  }
				}
			  }
			NEW_TYPE {
			  	foreach {type_info1 type_info2} $info break
				foreach {type1 value1} $type_info1 break
				foreach {type2 value2} $type_info2 break
#				foreach {type3 value3} $type_info2 break
				switch $value1 {
				STRUCT {
					set return_type_name $value1
				  	set data(primary_return_class_name) $value2
				  	set ret_infos [lrange $ret_infos 1 end]
				  }
				INTERFACE {
					set return_type_name $value1
				  	set data(primary_return_class_name) $value2
				  }
				ENUM {
					set return_type_name $value1
				  	set data(primary_return_class_name) $remote_type_cache_names($value2)
				  }
				default {
					puts stderr "ERROR: unexpected type_class:$value1 in TYPE info!"
				  }
				}
			  }
			TYPE_CLASS {
			  	set return_type_name $info
			  }
			default {
				if {[llength $type] == 2} {
					# have a [list TYPE_CLASS name]
					foreach {type1 type_name} $type break
					set return_type_name $type_name
				} else {
			  		puts stderr "ERROR: GUESS $type not yet implemeneted!"
			  	}
			  }
			}
		}
CommandDebug 1 "RTN:$return_type_name:"
		switch $return_type_name {
		INTERFACE {
			return [makeObjectCommand $ret_infos]
	  	  }
		STRUCT {
			set my_return_class_name $data(unknown_info)
			if {[info exists data(primary_return_class_name)]} {
				set my_return_class_name $data(primary_return_class_name)
				set ret_infos [lindex $ret_infos 0]
				# strip off struct type info
				set ret_infos [lindex $ret_infos 2]
				set ret_infos [lindex $ret_infos 0]
CommandDebug 1 "RTN:STRUCT:$my_return_class_name:$ret_infos:"
				set ret [getStructReturnValues $my_return_class_name $ret_infos]
				return $ret
			} else {
				puts stderr "ERROR: getReturnValues:ANY:STRUCT:missing data(primary_return_class_name)!!"
				return $data(unknown_info)
			}
		  }
		ENUM {
		  	foreach {type_info value_info} $ret_infos break
			foreach {type_class_info1 type_name_info} $type_info break
			foreach {type1 type_name} $type_name_info break
			foreach {type_class_info2 value_info2} $value_info break
			foreach {type2 value} $value_info2 break
			return [list EnumClass $type_name $value]
		  }
	  	default {
			if {[llength $ret_infos] == 1} {
		  		return [getBaseTypeReturnValue $return_type_name [lindex $ret_infos 0]]
			} else {
		  		return [getBaseTypeReturnValue $return_type_name [lrange $ret_infos 0 1]]
		  	}
		  }
		}
	  }
	STRUCT {
		set my_return_class_name $data(unknown_info)
		if {[info exists data(primary_return_class_name)]} {
			set my_return_class_name $data(primary_return_class_name)
			set ret_infos [lindex $ret_infos 0]
CommandDebug 1 "STRUCT:5:$ret_infos:"
			# strip off struct type info
			set ret_infos [lindex $ret_infos 2]
			set ret_infos [lindex $ret_infos 0]
			set ret [getStructReturnValues $my_return_class_name $ret_infos]
			return [lindex $ret 0]
		} else {
			puts stderr "ERROR: getReturnValues:STRUCT:missing data(primary_return_class_name)!!"
			return $data(unknown_info)
		}
	  }
	INTERFACE {
	  	return [makeObjectCommand $ret_infos]
	  }
	default {
		return [getBaseTypeReturnValue $my_type_class [lindex $ret_infos 0]]
	  }
	}
}

# **************************** handleStructParam ***********************

proc handleStructParam {str add_struct_info} {
	variable data
	variable generated_command_infos
	variable struct_infos

	set cmd [list]
	set my_cmd_handle_idx [getCmdHandleIndex $str]
	set my_infos [lindex $generated_command_infos($my_cmd_handle_idx) 0]
	foreach {struct_index_info class_name_info init_infos} $my_infos break
CommandDebug 1 "HandleStructParam:struct_index_info:$struct_index_info:class_name_info:$class_name_info:init_infos:$init_infos:"
	foreach {type1 my_type_name} $class_name_info break
	foreach {type2 init_values} $init_infos break
	if {![info exists struct_infos($my_type_name)]} {
		getInterfaceStructInfos $my_type_name
	}
	set my_struct_infos $struct_infos($my_type_name)
	if {$add_struct_info} {
		if {![info exists remote_type_cache($my_type_name)]} {
			set my_type_cache_idx [makeNewTypeCacheEntry $my_type_name]
			lappend cmd [list TYPE_CLASS STRUCT NEW]
			lappend cmd [list TYPE_CACHE_INDEX $my_type_cache_idx]
			lappend cmd [list CLASS_NAME $my_type_name]
		} else {
			set my_type_cache_idx $remote_type_cache($my_type_name)
			lappend cmd [list TYPE_CLASS STRUCT]
			lappend cmd [list TYPE_CACHE_INDEX $my_type_cache_idx]
		}
	}
	set struct_member_idx 0
CommandDebug 1 "init_values:$init_values:"
	foreach entry $my_struct_infos {
		foreach {my_type my_name} $entry break
		set my_value [lindex $init_values $struct_member_idx]
		switch -glob $my_value {
		::tclUrtpBridge::struct_* {
		  	set cmd [concat $cmd [handleStructParam $my_value 0]]
		  }
		default {
CommandDebug 1 "STR:$my_type:$my_name:"
			switch $my_type {
			boolean -
			char -
			short -
			"unsigned short" -
			long -
			"unsigned long" {
				set my_type [string toupper $my_type]
				lappend cmd [list $my_type [lindex $init_values $struct_member_idx]]
			  }
			default {
				set base_type [getInterfaceType $my_type $data(handle_introspection_oid)]
			  	switch $base_type {
				TYPEDEF {
					# TEMPORARY TO BE FIXED!!
					set my_type LONG
					lappend cmd [list $my_type [lindex $init_values $struct_member_idx]]
				  }
				ENUM {
					lappend cmd [list $base_type [lindex $init_values $struct_member_idx]]
				  }
				default {
					set my_type [string toupper $my_type]
					lappend cmd [list $my_type [lindex $init_values $struct_member_idx]]
				  }
				}
		  	  }
			}
		  }
		}
		incr struct_member_idx
	}
CommandDebug 1 "HandleStructParam:END:$cmd:"
	return $cmd
}

# **************************** HandleGeneratedCommand ******************

proc HandleGeneratedCommand {cmd_idx proc_name args} {
	variable data
	variable generated_command_infos

	set command [lindex $args 0]
	set args [lrange $args 1 end]
	set data(curr_handle_index) $cmd_idx
	set my_handle_info [lindex $generated_command_infos($data(curr_handle_index)) 0]
	set my_oid ""
	if {[string match "*OBJECT_CACHE_INDEX*" $my_handle_info]} {
		set my_oid [getHandleObject $proc_name]
		set data(curr_object) $my_oid
	}
	incr data(handled_commands)
CommandDebug 1 "HANDLE_COMMAND!$data(handled_commands):$command!$my_oid!$cmd_idx!$generated_command_infos($cmd_idx)!"
CommandDebug 1 "args:$args:"
	set my_handle_infos $generated_command_infos($cmd_idx)
	set data(generated_command_args) $args
	if {[eval CheckIsTclunoCommand $command $args]} {
CommandDebug 1 "HANDLE_COMMAND!END:$data(handled_commands):$command!$my_oid!$cmd_idx!$generated_command_infos($cmd_idx)!$data(command_execution_result):"
		return $data(command_execution_result)
	}
	# save the handle_type!!
	set handle_type $data(handle_type)
	if {[checkHasMethod $command]} {
		set result_infos [eval callableCall $command $args]
		set ret [getReturnValues $handle_type $command $result_infos]
	} else {
		if {[checkHasProperty $command]} {
			set result_infos [callMethod $data(invocation_oid) com.sun.star.script.XInvocation getValue [list STRING $command]]
puts stderr "PROP:$result_infos:"
			# TO BE FILLED!!
			set ret [list]
		} else {
			puts stderr "ERROR: no such method or property:$command!!"
			set ret [list]
		}
	}
CommandDebug 1 "HANDLE_COMMAND!$data(message_id)!END!$command!$my_oid!$data(curr_handle_index)!$generated_command_infos($data(curr_handle_index))!"
CommandDebug 1 "return_value:$ret:"
	return $ret
}

# **************************** callTcl *********************************

proc callTcl {} {
	variable data

	set result_info [callMethod $data(remoteServiceManager) com.sun.star.lang.XMultiComponentFactory createInstanceWithContext [list STRING EvalTcl] [list OBJECT_ID [list]] [list OBJECT_CACHE_INDEX $data(remote_component_context)]]
	set my_oid [storeObjectInfo EvalTcl [lindex $result_info 0]]
	set data(tcl_instance) $my_oid
puts stderr "HAVE tcl_instance!!:$my_oid:$data(tcl_instance):"
	set my_tcl_idx [queryInterface $data(tcl_instance) com.sun.tcl.XEvalTcl]
puts stderr "my_tcl_idx:$my_tcl_idx:"
    	while {1} {
		puts -nonewline "% "
		flush stdout
		gets stdin line
		switch $line {
		exit -
		q {
			puts stderr "finshing!"
			break
		  }
		}
#		set str {package require Tk; toplevel .t; button .t.b -text hallo; pack .t.b; wm deiconify .t; set fd [open /tmp/arnulf1.txt w]; puts $fd hallo; close $fd; set xx [winfo children .t]}
		set tcl_ret [callMethod $my_tcl_idx com.sun.tcl.XEvalTcl TclEval [list STRING $line]]
		puts stderr "TCLRET:$tcl_ret:"
	}
}

}
