#*************************************************************************
#*
#*  $RCSfile: bootstrap.tcl,v $
#*
#*  $Revision: 1.1 $
#*
#*  last change: $Author: wiede $ $Date: 2005/12/05 12:22:57 $
#*
#*  The Contents of this file are made available subject to the terms of
#*  the following license
#*
#* 	- BSD License
#*
#*	see file license.terms in this directory
#*
#*  Copyright 2005 Arnulf Wiedemann
#*
#*  Author: Arnulf Wiedemann
#*
#*  Contributor(s): 
#*
#************************************************************************/

namespace eval ::tclUrtpBridge {

variable uno_types [list \
	VOID \
	CHAR \
	BOOLEAN \
	BYTE \
	SHORT \
	UNSIGNED_SHORT \
	LONG \
	UNSIGNED_LONG \
	HYPER \
	UNSIGNED_HYPER \
	FLOAT \
	DOUBLE \
	STRING \
	TYPE \
	ANY \
	ENUM \
	TYPEDEF \
	STRUCT \
	UNION \
	EXCEPTION \
	SEQUENCE \
	ARRAY \
	INTERFACE \
	SERVICE \
	MODULE \
	INTERFACE_METHOD \
	INTERFACE_ATTRIBUTE \
	UNKNOWN \
	PROPERTY \
	CONSTANT \
	CONSTANTS \
	SINGLETON \
]

variable bootstrap_method_return_types

# **************************** InitBootstrapVariables ******************

proc InitBootstrapVariables {} {
	variable data
	variable uno_types
	variable bootstrap_method_return_types

	set idx 0
	foreach type $uno_types {
		set data(typeclass,$type) $idx
		set data(typeclass,$idx) $type
		incr idx
	}
	set bootstrap_method_return_types(com.sun.star.uno.XInterface,queryInterface) any
	set bootstrap_method_return_types(com.sun.star.uno.XInterface,release) void
}

}
