#*************************************************************************
#*
#*  $RCSfile: binary_unmarshal.tcl,v $
#*
#*  $Revision: 1.14 $
#*
#*  last change: $Author: wiede $ $Date: 2005/12/25 15:55:06 $
#*
#*  The Contents of this file are made available subject to the terms of
#*  the following license
#*
#* 	- BSD License
#*
#*	see file license.terms in this directory
#*
#*  Copyright 2005 Arnulf Wiedemann
#*
#*  Author: Arnulf Wiedemann
#*
#*  Contributor(s): 
#*
#************************************************************************/

# **************************** unmarshal functions *********************

namespace eval ::tclUrtpBridge {

# **************************** getBinaryReplyBytes *********************

proc getBinaryReplyBytes {num_bytes} {
	variable data

	set start_idx $data(binary_reply_offset)
	set end_idx [expr {$start_idx + $num_bytes - 1}]
	set ret [string range $data(binary_reply) $start_idx $end_idx]
	incr data(binary_reply_offset) $num_bytes
	return $ret
}

# **************************** unpackFloat ******************************

proc unpackFloat {} {
	variable data

	set bin_val1 [getBinaryReplyBytes 1]
	set bin_val2 [getBinaryReplyBytes 1]
	set bin_val3 [getBinaryReplyBytes 1]
	set bin_val4 [getBinaryReplyBytes 1]
	binary scan ${bin_val4}${bin_val3}${bin_val2}${bin_val1} f val
	return $val
}

# **************************** unpackDouble ****************************

proc unpackDouble {} {
	variable data

	set bin_val1 [getBinaryReplyBytes 1]
	set bin_val2 [getBinaryReplyBytes 1]
	set bin_val3 [getBinaryReplyBytes 1]
	set bin_val4 [getBinaryReplyBytes 1]
	set bin_val5 [getBinaryReplyBytes 1]
	set bin_val6 [getBinaryReplyBytes 1]
	set bin_val7 [getBinaryReplyBytes 1]
	set bin_val8 [getBinaryReplyBytes 1]
	binary scan ${bin_val8}${bin_val7}${bin_val6}${bin_val5}${bin_val4}${bin_val3}${bin_val2}${bin_val1} d val
	return $val
}

# **************************** unpackInt8 ******************************

proc unpackInt8 {} {
	variable data

	set bin_val [getBinaryReplyBytes 1]
	binary scan $bin_val c val
	return $val
}

# **************************** unpackInt16 *****************************

proc unpackInt16 {} {
	variable data

	set bin_val [getBinaryReplyBytes 2]
	binary scan $bin_val S val
	return $val
}

# **************************** unpackInt32 *****************************

proc unpackInt32 {} {
	variable data

	set bin_val [getBinaryReplyBytes 4]
	binary scan $bin_val I val
	return $val
}

# **************************** unpackInt64 *****************************

proc unpackInt64 {} {
	variable data

	set bin_val [getBinaryReplyBytes 8]
	binary scan $bin_val W val
	return $val
}

# **************************** unpackCompressedSize ********************

proc unpackCompressedSize {} {
	variable data

	set bin_val [getBinaryReplyBytes 1]
	binary scan $bin_val c val
	if {$val != 255} {
		return $val
	}
	# undo above and get an Int32
	incr data(binary_reply_offset) -1
	set bin_val [getBinaryReplyBytes 4]
	binary scan $bin_val I val
	return $val
}

# **************************** unpackString ****************************

proc unpackString {} {
	variable data

	set lgth [unpackCompressedSize]
	set str [list]
	if {$lgth > 0} {
		set start_idx $data(binary_reply_offset)
		set end_idx [expr {$start_idx + $lgth - 1}]
		set str [string range $data(binary_reply) $start_idx $end_idx]
	}
	incr data(binary_reply_offset) $lgth
	return $str
}

# **************************** checkBinaryHeaderFlagIsSet **************

proc checkBinaryHeaderFlagIsSet {name flag_val} {
	variable data
	variable binary_hdr_flag_values

	set chk_val $data($name)
	set val [expr {$flag_val & $chk_val}]
	if {$val} {
		set binary_hdr_flag_values($name) 1
	} else {
		set binary_hdr_flag_values($name) 0
	}
}

# **************************** unpackHeaderFlags ***********************

proc unpackHeaderFlags {} {
	variable data
	variable hdrflag_names
	variable binary_hdr_flag_values

	set my_result [list]
	set hdr_flag [unpackInt8]

	foreach name $hdrflag_names {
		checkBinaryHeaderFlagIsSet $name $hdr_flag
	}
	if {$binary_hdr_flag_values(HDRFLAG_LONGHEADER)} {
		if {$binary_hdr_flag_values(HDRFLAG_MOREFLAGS)} {
			set hdr_more_flag [unpackInt8]
			checkBinaryHeaderFlagIsSet HDRFLAG_SYNCHRONOUS $hdr_more_flag
			checkBinaryHeaderFlagIsSet HDRFLAG_MUSTREPLY $hdr_more_flag
			checkBinaryHeaderFlagIsSet HDRFLAG_EXCEPTION $hdr_more_flag
		} else {
			set binary_hdr_flag_values(HDRFLAG_SYNCHRONOUS) 0
			set binary_hdr_flag_values(HDRFLAG_MUSTREPLY) 0
			if {$binary_hdr_flag_values(HDRFLAG_REQUEST)} {
				set binary_hdr_flag_values(HDRFLAG_EXCEPTION) 0
			}
			if {$binary_hdr_flag_values(HDRFLAG_EXCEPTION)} {
				set binary_hdr_flag_values(HDRFLAG_NEWTYPE) 0
			}
		}
	} else {
		# to be fixed !!
	}
	foreach name $hdrflag_names {
		lappend my_result [list $name $binary_hdr_flag_values($name)]
	}
	set data(return_method_id) 65353
	if {$binary_hdr_flag_values(HDRFLAG_REQUEST)} {
		# seems we also have a method id in that case
		set data(return_method_id) [unpackInt8]
	}
	lappend my_result [list METHOD_ID $data(return_method_id)]
	return $my_result
}

# **************************** unpackType ******************************

proc unpackType {} {
	variable data
	variable remote_type_cache
	variable remote_type_cache_names
		
	set type_value [unpackInt8]
	set is_new 0
	if {[expr {$type_value & 0x80}]} {
		set is_new 1
		set type_value [expr {$type_value & 0x3f}]
	}
	set type_name $data(typeclass,$type_value)
	if {$is_new} {
		set type_class_str [list TYPE_CLASS $type_name NEW]
	} else {
		set type_class_str [list TYPE_CLASS $type_name]
	}
	set my_result [list]
	lappend my_result $type_class_str
	set cache_str [list]
	set data(primary_type) 1
	set data(primary_return_type_name) $type_name
	set data(primary_return_class_name) [list]
	if {$type_value > 14} {	; # ANY == 14
		set type_cache_index [unpackInt16]
		set data(primary_type_cache_index) $type_cache_index
		lappend my_result [list TYPE_CACHE_INDEX $type_cache_index]
		set data(primary_type) 0
		set my_lst [list]
		if {$is_new} {
			set type_str [unpackString]
			lappend my_result [list TYPE_NAME $type_str]
UnmarshalDebug 1 "NEW:TYPE:$type_str:$type_cache_index:"
			set remote_type_cache_names($type_cache_index) $type_str
			set remote_type_cache($type_str) $type_cache_index
		}
	}
UnmarshalDebug 1 "unpackType:END:$my_result:"
	return $my_result
}

# **************************** unpackOid *******************************

proc unpackOid {} {
	variable data

	set my_result [list]
	set oid [unpackString]
	lappend my_result [list OBJECT_ID $oid]
	set oid_cache_index [unpackInt16]
	if {$oid_cache_index == -1} {
		set oid_cache_index 65535
	}
	lappend my_result [list OBJECT_CACHE_INDEX $oid_cache_index]
	return $my_result
}

# **************************** unpackTid *******************************

proc unpackTid {} {
	variable data
	variable binary_hdr_flag_values

	set size [unpackCompressedSize]
	set size_str [list THREAD_ID_SIZE $size]
	set idx 0
	set tid ""
	set sep ""
	while {$idx < $size} {
		set byte [unpackInt8]
		append tid "$sep[format 0x%02x [expr {$byte & 0xff}]]"
		set sep " "
		incr idx
	}
	set thread_str [list THREAD_ID $tid]
	set thread_cache_index 65535
	set thread_cache_index [unpackInt16]
	if {$thread_cache_index == -1} {
		set thread_cache_index 65535
	}
	set cache_str [list THREAD_CACHE_INDEX $thread_cache_index]
	set binary_hdr_flag_values(HDRFLAG_NEWTID) 0
UnmarshalDebug 1 "NEW_THREAD:END:$size_str $thread_str $cache_str:"
	return [list NEW_THREAD_ID [list $size_str $thread_str $cache_str]]
}

# **************************** unpackTypeClassValue ********************

proc unpackTypeClassValue {type_name} {
	variable data

	set type_name [string toupper $type_name]
	switch $type_name {
	BOOLEAN {
		set value [unpackInt8]
	  	if {$value} {	
			set value True
		} else {
			set value False
	  	}
	  }
	VOID {
		set value [list]
	  }
	CHAR -
	BYTE {
		set value [unpackInt8]
	  }
	"UNSIGNED SHORT" -
	SHORT {
		set value [unpackInt16]
	  }
	ENUM -
	"UNSIGNED LONG" -
	LONG {
		set value [unpackInt32]
	  }
	HYPER {
		set value [unpackInt64]
	  }
	FLOAT {
	  	set value [unpackFloat]
	  }
	DOUBLE {
	  	set value [unpackDouble]
	  }
	STRING {
	  	set value [unpackString]
	  }
	ANY {
		set value 0
puts stderr "ERROR: unpackTypeClassValue:ANY not yet implemented!!"
#	  	set value [unpackType]
	  }
	default {
		puts stderr "funny type_name in unpackTypeClassValue:$type_name:"
	  }
	}
	return [list VALUE $value]
}

# **************************** pushBinaryEnv ***************************

proc pushBinaryEnv {} {
	variable data

	set num $data(binary_stack_idx)
  	set data(save_binary_stack,$num,binary_reply) $data(binary_reply)
	set data(save_binary_stack,$num,binary_reply_offset) $data(binary_reply_offset)
	set data(save_binary_stack,$num,binary_reply_size) $data(binary_reply_size)
	set data(save_binary_stack,$num,primary_return_type_name) $data(primary_return_type_name)
	set data(save_binary_stack,$num,primary_type) $data(primary_type)
	set data(save_binary_stack,$num,primary_return_class_name) $data(primary_return_class_name)
	incr data(binary_stack_idx)
}

# **************************** popBinaryEnv ****************************

proc popBinaryEnv {} {
	variable data

	incr data(binary_stack_idx) -1
	set num $data(binary_stack_idx)
  	set data(binary_reply) $data(save_binary_stack,$num,binary_reply)
	set data(binary_reply_offset) $data(save_binary_stack,$num,binary_reply_offset)
	set data(binary_reply_size) $data(save_binary_stack,$num,binary_reply_size)
	set data(primary_return_type_name) $data(save_binary_stack,$num,primary_return_type_name)
	set data(primary_type) $data(save_binary_stack,$num,primary_type)
	set data(primary_return_class_name) $data(save_binary_stack,$num,primary_return_class_name)
}

# **************************** unpackBinaryStructResultValues **********

proc unpackBinaryStructResultValues {type_name} {
	variable data
	variable struct_infos

UnmarshalDebug 1 "UBSRV:1:$type_name:"
	set my_result [list]
	set save_primary_return_class_name $data(primary_return_class_name)
	if {![info exists struct_infos($type_name)]} {
		pushBinaryEnv
		getInterfaceStructInfos $type_name
		popBinaryEnv
	}
	set my_struct_infos $struct_infos($type_name)
	set my_struct_result [list]
	set need_type_class 1
UnmarshalDebug 1 "===STI:[join $my_struct_infos \n]:"
	foreach entry $my_struct_infos {
		foreach {my_type my_name} $entry break
		set my_ret [unmarshalReturnValue $my_type $my_result $need_type_class]
UnmarshalDebug 1 "BINSTR:$my_type:$my_name:$my_ret:"
		set my_struct_result [concat $my_struct_result $my_ret]
	}
UnmarshalDebug 1 "BINSTR:2:$my_struct_result:"
	set my_result [concat $my_result [list $my_struct_result]]
	set data(primary_return_class_name) $save_primary_return_class_name
UnmarshalDebug 1 "UBSRV:2:$my_result:"
	return $my_result
}

# **************************** unmarshalReturnValue ********************

proc unmarshalReturnValue {return_type my_result {need_type_class 0}} {
	variable data
	variable remote_type_cache_names
	variable struct_infos
	variable enum_infos
	variable binary_hdr_flag_values
	variable type_type_classes

incr data(return_value_level)
UnmarshalDebug 1 "unmarshalReturnValue:$data(return_value_level):$return_type:$my_result:"
	if {$binary_hdr_flag_values(HDRFLAG_EXCEPTION)} {
		lappend my_result [unpackType]
		lappend my_result [list STRING [unpackString]]
		return $my_result
	}
	switch $return_type {
	any {
		set my_result [unpackType]
UnmarshalDebug 1 "data(primary_type):$data(primary_type):"
UnmarshalDebug 1 "data(primary_return_type_name):$data(primary_return_type_name):"
set save_primary_type $data(primary_type)
set save_primary_return_type_name $data(primary_return_type_name)
		if {$data(primary_type)} {
			set my_type [string tolower $data(primary_return_type_name)]
			# avoid getting the type_class 2 times!!
			set my_result [list]
			set my_result [concat $my_result [unmarshalReturnValue $my_type $my_result]]
UnmarshalDebug 1 "PRIM:$data(primary_type):$my_result:$data(primary_return_type_name):"
		} else {
			switch $data(primary_return_type_name) {
			SEQUENCE {
UnmarshalDebug 1 "SEQ:1:$my_result:"
				set my_type_infos [checkForNewType $my_result]
				foreach {my_info dummy} $my_type_infos break
				foreach {type_info value_info} $my_info break
				foreach {type type_name} $value_info break
				set my_result [list]
				set sequence_size [unpackCompressedSize]
UnmarshalDebug 1 "SEQ:$type_name:$sequence_size:"
				switch -glob -- $type_name {
				"\\[\\]*" {
				  	set base_type [string range $type_name 2 end]
					switch $base_type {
					type -
					string {
					  	set my_type_class [string toupper $base_type]
					  }
					default {
						pushBinaryEnv
						set my_type_class [getInterfaceType $base_type $data(handle_introspection_oid)]
						popBinaryEnv
					  }
					}
				  }
				default {
					set my_type_class $type_name
				  	puts stderr "ERROR: return_type:SEQUENCE:$type_name: not yet implemented!!"
					set my_type_class $type_type_classes($type_name)
				  }
				}
				set my_seq_infos [list]
				set cnt 0
UnmarshalDebug 1 "MY_TYPE_CLASS:$my_type_class:$sequence_size:"
				switch $my_type_class {
				STRUCT {
					set data(primary_return_class_name) $base_type
UnmarshalDebug 1 "data(primary_return_class_name):$data(primary_return_class_name):"
				  }
				BYTE {
					set data(primary_return_class_name) $base_type
UnmarshalDebug 1 "data(primary_return_class_name):$data(primary_return_class_name):"
				  }
				}
				while {$cnt < $sequence_size} {
					switch $my_type_class {
					TYPE {
						set my_ret [unpackType]
UnmarshalDebug 1 "TYPE:$my_ret:"
						lappend my_seq_infos $my_ret
					  }
					BYTE {
						set my_byte [unpackInt8]
						lappend my_seq_infos [list [list TYPE_CLASS BYTE] [list VALUE [format 0x%02x [expr {$my_byte & 0xff}]]]]
					  }
					STRUCT {
UnmarshalDebug 1 "UBSRV:$cnt:$base_type:"
						set my_ret [unpackBinaryStructResultValues $base_type]
						set my_ret [lindex $my_ret 0]
UnmarshalDebug 1 "STRU:$my_ret:"
						lappend my_seq_infos $my_ret
					  }
					STRING {
					  	set my_ret [unpackTypeClassValue $my_type_class]
						lappend my_seq_infos [list [list TYPE_CLASS STRING] $my_ret]
					  }
					default {
					  	puts stderr "ERROR: unmarshalReturnValues:funny SEQUENCE base_type:$base_type:$my_type_class:"
					  }
					}
					incr cnt
				}
UnmarshalDebug 1 "SEQ:3:$my_seq_infos:"
				set my_infos [list [list SEQUENCE_SIZE $sequence_size] $my_seq_infos]
				set my_result [list SEQUENCE $my_infos]
			  	set my_result [list $my_result]
			  }
			STRUCT {
				set cache_idx $data(primary_type_cache_index)
				set my_type_name $remote_type_cache_names($cache_idx)
				set data(primary_return_class_name) $my_type_name
UnmarshalDebug 1 "data(primary_return_class_name):$data(primary_return_class_name):"
				set my_result [unpackBinaryStructResultValues $my_type_name]
UnmarshalDebug 1 "STRUCT:1:$my_result:"

			  	set my_result [list [list TYPE_CLASS STRUCT] [list VALUE $data(primary_return_class_name)] $my_result]
				set my_result [list $my_result]
UnmarshalDebug 1 "STRUCT:2:$my_result:"
			  }
			ENUM {
				foreach {type_info type_cache_info} $my_result break
				foreach {type1 val} $type_info break
				foreach {type2 my_type_cache_idx} $type_cache_info break
				set my_type_name $remote_type_cache_names($my_type_cache_idx)
				set my_result1 [list [list TYPE_CLASS TYPE] [list VALUE $my_type_name]]
				set my_val [unpackInt32]
				if {![info exists enum_infos($my_type_name)]} {
					pushBinaryEnv
					getInterfaceEnumInfos $my_type_name
					popBinaryEnv
				}
				foreach entry $enum_infos($my_type_name) {
					foreach {value enum_value} $entry break	
					if {$my_val == $enum_value} {
						break
					}
				}
				set my_result2 [list [list TYPE_CLASS $val] [list VALUE $value]]
				set my_result [list $my_result1 $my_result2]
UnmarshalDebug 1 "ENUM:1:$my_result:"
			  }
			INTERFACE {
				set my_result [concat $my_result [unpackOid]]
			  }
			default {
				lappend my_result [unpackOid]
			  }
			}
		}
set data(primary_type) $save_primary_type
set data(primary_return_type_name) $save_primary_return_type_name
	  }
	interface {
		set my_result [list]
		lappend my_result [unpackOid]
	  }
	void {
		set my_result [list]
		lappend my_result [list TYPE_CLASS [string toupper $return_type]]
	  }
	char -
	byte -
	enum -
	"unsigned short" -
	short -
	"unsigned long" -
	long -
	float -
	double -
	string -
	boolean {
#puts "RET_TY:$return_type:"
		set my_result [list]
		lappend my_result [list [list TYPE_CLASS [string toupper $return_type]] [unpackTypeClassValue $return_type]]
#puts "RET_TY:2:$return_type:$my_result:"
	  }
	"unsigned_short" {
		set my_result [list]
		lappend my_result [list [list TYPE_CLASS UNSIGNED SHORT] [unpackTypeClassValue "UNSIGNED SHORT"]]
	  }
	"unsigned_long" {
		set my_result [list]
		lappend my_result [list [list TYPE_CLASS UNSIGNED LONG] [unpackTypeClassValue "UNSIGNED LONG"]]
	  }
	struct {
		set data(primary_return_class_name) $data(struct_base_type)
		set my_result [unpackBinaryStructResultValues $data(struct_base_type)]
	  	set my_result [list [list TYPE_CLASS STRUCT] [list VALUE $data(primary_return_class_name)] $my_result]
	  	set my_result [list $my_result]
	  }
	type {
		set my_result [list]
		set result [unpackType]
		foreach {type value} [lindex $result 0] break
		switch $value {
		INTERFACE {
			foreach {type1 value1} [lindex $result 1] break
			lappend my_result [list [list TYPE_CLASS $value] [list TYPE_CACHE_INDEX $value1]]
	  	  }
		default {
			lappend my_result [list [list TYPE_CLASS TYPE] [list VALUE $value]]
		  }
		}
	  }
	unknown {
		puts stderr "ERROR: marshal unmarshalReturnValue:unknown:"
	  	set my_result "unknown"
	  }
	default {
		pushBinaryEnv
		set data(struct_base_type) $return_type
		set my_type_class [getTypeClassFromName $return_type]
		set return_type [string tolower $my_type_class]
		popBinaryEnv
		set my_result [unmarshalReturnValue $return_type $my_result]
	  }
	}
UnmarshalDebug 1 "unmarshalReturnValue:END:$data(return_value_level):$my_result:"
incr data(return_value_level) -1
	return $my_result
}

# **************************** unpackBinaryHeaders *********************

proc unpackBinaryHeaders {} {
	variable data
	variable binary_hdr_flag_values
	variable object_interfaces

	set data(binary_reply_offset) 0
if {$data(binary_send_debug)} {
	puts -nonewline stderr "RECEIVE:$data(binary_reply_size):"
	dumpBinary -2
}
	if {$data(binary_reply_size) == 0} {
		return [list]
	}
	set my_result [list]
UnmarshalDebug 1 "RETTYPE:$data(curr_interface_name),$data(curr_method_name)"
	lappend my_result [unpackHeaderFlags]
	set data(had_request) 0
	if {$binary_hdr_flag_values(HDRFLAG_REQUEST)} {
		set data(had_request) 1
	if {$binary_hdr_flag_values(HDRFLAG_NEWTYPE)} {
#		puts stderr "NEED to handle NEWTYPE"
		set my_type [unpackType]
		lappend my_result $my_type
	}
	if {$binary_hdr_flag_values(HDRFLAG_NEWOID)} {
#		puts stderr "NEED to handle NEWOID"
		set my_oid [unpackOid]
		lappend my_result $my_oid
	}
	if {$binary_hdr_flag_values(HDRFLAG_NEWTID)} {
#		puts stderr "NEED to handle NEWTID"
		set my_tid [unpackTid]
		lappend my_result $my_tid
	}
	} else {
	if {$binary_hdr_flag_values(HDRFLAG_EXCEPTION)} {
		puts stderr "EXCEPTION!!"
#dumpRemoteTypeCache
puts stderr "OID:$data(handle_oid):"
#puts stderr "IF:[join $object_interfaces($data(handle_oid)) \n]:"
	}
	if {$binary_hdr_flag_values(HDRFLAG_NEWTID)} {
#		puts stderr "NEED to handle NEWTID"
		set my_tid [unpackTid]
		lappend my_result $my_tid
	}
	}
	return $my_result
}

# **************************** unpackBinaryReply ***********************

proc unpackBinaryReply {} {
	variable data
	variable marshal_method_return_types
	variable bootstrap_method_return_types
	variable binary_hdr_flag_values

set data(return_value_level) 0
	set data(had_request) 0
UnmarshalDebug 1 unpackBinaryReply
set data(binary_reply_offset) 0
	set my_result [unpackBinaryHeaders]
UnmarshalDebug 1 "unpackBinaryReply:after unpackBinaryHeaders:"
	if {$data(had_request)} {
		# have more then one message??
		if {$data(return_method_id) == 2} {
			set my_offset $data(binary_reply_offset)
#puts stderr "binary_reply_size:1:$data(binary_reply_size):"
			incr data(binary_reply_size) -$my_offset
#puts stderr "binary_reply_size:2:$data(binary_reply_size):"
			set data(binary_reply) [string range $data(binary_reply) $my_offset end]
#			set data(binary_reply_offset) 0
			if {$data(binary_reply_size) == 0} {
				return [list]
			} else {
				puts stderr "return_request:have data after release!!"
dumpBinary -2
				set my_result [unpackBinaryHeaders]
#				return [list]
			}
		} else {
			if {$data(curr_method_id) == $data(return_method_id)} {
				set data(had_request) 0
dumpBinary -2
puts stderr "SPEC_OBJ:$my_result:"
				set data(repeat_call_method) 1
				return $my_result
			} else {
				if {$data(return_method_id) == 0} {
					set my_type [unpackType]
					checkForNewType $my_type
					set my_headers [lindex $my_result 0]
					set my_object_info [lindex $my_result 2]
					set my_result [list $my_headers]
					set my_result [concat $my_result $my_type]
					set my_result [concat $my_result $my_object_info]
					set data(had_request) 0
					set reply [lrange $my_result end-1 end]
#					set reply $my_result
					return $reply
				} else {
					puts stderr "return_request:$data(return_method_id) not yet implemented!!"
					set data(had_request) 0
dumpBinary -2
puts stderr "SPEC:0:$my_result:"
set my_result [lindex $my_result 1 end]
puts stderr "SPEC:1:$my_result:"
					return $my_result
				}
			}
		}
	}
	set curr_method_name $data(curr_method_name)
	set curr_interface_name $data(curr_interface_name)
UnmarshalDebug 1 "UBR:$curr_method_name:"
	switch $curr_method_name {
	release {
		# nothing to do
		return [list]
	  }
	default {
		if {[info exists bootstrap_method_return_types($curr_interface_name,$curr_method_name)]} {
			set return_type $bootstrap_method_return_types($curr_interface_name,$curr_method_name)
#puts stderr "BOOT_RT:1:$curr_method_name:$return_type:$curr_interface_name:"
		} else {
		    switch $curr_method_name {
		    queryInterface {
		    	set return_type any
#puts stderr "BOOT_RT:2:$curr_method_name:$return_type:$curr_interface_name:"
		      }
		    default {
		    if {[info exists marshal_method_return_types($curr_interface_name,$curr_method_name)]} {
			set return_type $marshal_method_return_types($curr_interface_name,$curr_method_name)
		    } else {
			puts stderr "ERROR: missing return_type for:$curr_interface_name,$curr_method_name:"
			set return_type unknown
		    }
		      }
		    }
		}
		set data(primary_return_type_name) $return_type
	  }
	}
UnmarshalDebug 1 "BOOT_RT:3:$curr_method_name:$return_type:$curr_interface_name:"
	set cnt 1
	set is_sequence 0
	set save_result $my_result
	set my_result [list]
UnmarshalDebug 1 "RET_TYPE:$return_type:"
	if {[string match {\[\]*} $return_type]} {
		set cnt [unpackCompressedSize]
		set return_type [string range $return_type 2 end]
		set data(primary_return_type_name) $return_type
		set sequence_size $cnt
		set is_sequence 1
	}
	if {$is_sequence} {
		set save_primary_return_type_name $data(primary_return_type_name)
	}
	while {$cnt > 0} {
		if {[llength $return_type] > 1} {
			foreach {type_info value_info} $return_type break
			foreach {type1 type_name} $type_info break
			foreach {type2 value} $value_info break
#			switch $type_name {
#			INTERFACE {
#				lappend my_result [unpackOid]
#			  }
#			default {
			  	puts stderr "funy typename in unpackBinaryReply:$type_name:return_type:$return_type:"
#			  }
#			}
		} else {
			set tmp_result $my_result
			set need_type_class 0
			if {$is_sequence} {
				set need_type_class 1
			}
UnmarshalDebug 1 "RV:$return_type:$my_result:"
			set my_result [unmarshalReturnValue $return_type $my_result $need_type_class]
		  	set my_result [concat $tmp_result $my_result]
		}
		incr cnt -1
	}
	if {$is_sequence} {
		set data(primary_return_type_name) $save_primary_return_type_name
	}
UnmarshalDebug 1 "RV:2:$return_type:$data(primary_return_type_name):$my_result:"
	switch -glob $return_type {
	type {
		if {!$is_sequence} {
			set data(primary_return_type_name) $return_type
	  	}
	  }
	}
UnmarshalDebug 1 "BIN_RESULT:0:$data(primary_return_type_name):"
	if {$is_sequence} {
		set my_result [list [list SEQUENCE_SIZE $sequence_size] $my_result]
		set my_result [concat $save_result [list [list SEQUENCE $my_result]]]
	} else {
		set my_result [concat $save_result $my_result]
	}
UnmarshalDebug 1 "BIN_RESULT:$my_result:"
	set reply [handleMessageHeader $my_result]
UnmarshalDebug 1 "BIN_RESULT:2:$reply:"
	return $reply
}

# **************************** readBinaryMessage ***********************

proc readBinaryMessage {} {
	variable data

	set ret [read $data(connection_fd) 8]
	binary scan $ret II data(binary_reply_size) my_msg_id
	set data(binary_reply) [read $data(connection_fd) $data(binary_reply_size)]
}

# **************************** readBinaryReply *************************

proc readBinaryReply {} {
	variable data

UnmarshalDebug 1 "readBinaryReply:"
	while {1} {
		readBinaryMessage
		set reply [unpackBinaryReply]
		if {!$data(had_request)} {
			break
		}
	}
	return $reply
}

}
