#*************************************************************************
#*
#*  $RCSfile: binary_marshal.tcl,v $
#*
#*  $Revision: 1.6 $
#*
#*  last change: $Author: wiede $ $Date: 2005/12/03 17:44:53 $
#*
#*  The Contents of this file are made available subject to the terms of
#*  the following license
#*
#* 	- BSD License
#*
#*	see file license.terms in this directory
#*
#*  Copyright 2005 Arnulf Wiedemann
#*
#*  Author: Arnulf Wiedemann
#*
#*  Contributor(s): 
#*
#************************************************************************/

# **************************** binary marshal functions ****************

namespace eval ::tclUrtpBridge {

# **************************** InitMarshal *****************************

proc InitMarshal {} {
	variable data
	variable marshal_method_return_types

	set data(HDRFLAG_LONGHEADER) 0x80
	set data(HDRFLAG_REQUEST) 0x40
	set data(HDRFLAG_NEWTYPE) 0x20
	set data(HDRFLAG_NEWOID) 0x10
	set data(HDRFLAG_NEWTID) 0x08
	set data(HDRFLAG_LONGMETHODID) 0x04
	set data(HDRFLAG_IGNORECACHE) 0x02
	set data(HDRFLAG_MOREFLAGS) 0x01
	set data(HDRFLAG_MUSTREPLY) 0x80
	set data(HDRFLAG_SYNCHRONOUS) 0x40
	set data(HDRFLAG_EXCEPTION) 0x20

	set marshal_method_return_types(com.sun.star.uno.XInterface,queryInterface) any

	set marshal_method_return_types(com.sun.star.uno.XComponentContext,getValueByName) any
	set marshal_method_return_types(com.sun.star.uno.XComponentContext,getServiceManager) interface

	set marshal_method_return_types(com.sun.star.lang.XTypeProvider,getTypes) \[\]type

	set marshal_method_return_types(com.sun.star.lang.XMultiComponentFactory,createInstanceWithContext) interface
	
	set marshal_method_return_types(com.sun.star.lang.XSingleServiceFactory,createInstanceWithArguments) interface

	set marshal_method_return_types(com.sun.star.beans.XIntrospectionAccess,getMethod) interface
	set marshal_method_return_types(com.sun.star.beans.XPropertySet,getPropertySetInfo) interface
	set marshal_method_return_types(com.sun.star.beans.XPropertySetInfo,getProperties) \[\]interface
	set marshal_method_return_types(com.sun.star.beans.XPropertySet,getPropertyValue) any


	set marshal_method_return_types(com.sun.star.reflection.XTypeDescriptionEnumerationAccess,createTypeDescriptionEnumeration) interface

	set marshal_method_return_types(com.sun.star.reflection.XInterfaceMemberTypeDescription,getMemberName) string
	set marshal_method_return_types(com.sun.star.reflection.XInterfaceMemberTypeDescription,getPosition) long

	set marshal_method_return_types(com.sun.star.reflection.XInterfaceTypeDescription,getMembers) \[\]interface

	set marshal_method_return_types(com.sun.star.reflection.XTypeDescription,getTypeClass) enum
	set marshal_method_return_types(com.sun.star.reflection.XTypeDescription,getName) string

	set marshal_method_return_types(com.sun.star.reflection.XCompoundTypeDescription,getMemberTypes) \[\]interface
	set marshal_method_return_types(com.sun.star.reflection.XCompoundTypeDescription,getMemberNames) \[\]string

	set marshal_method_return_types(com.sun.star.reflection.XEnumTypeDescription,getEnumNames) \[\]string
	set marshal_method_return_types(com.sun.star.reflection.XEnumTypeDescription,getEnumValues) \[\]long

	set marshal_method_return_types(com.sun.star.reflection.XIdlMethod,getParameterInfos) \[\]com.sun.star.reflection.ParamInfo
	set marshal_method_return_types(com.sun.star.reflection.XIdlMethod,getReturnType) interface
	set marshal_method_return_types(com.sun.star.reflection.XIdlMethod,getMode) enum

	set marshal_method_return_types(com.sun.star.reflection.XIdlClass,getName) string
	set marshal_method_return_types(com.sun.star.reflection.XIdlClass,getTypeClass) enum
	set marshal_method_return_types(com.sun.star.reflection.XIdlClass,getMethod) interface

	set marshal_method_return_types(com.sun.star.reflection.XIdlReflection,getType) interface
	set marshal_method_return_types(com.sun.star.reflection.XIdlReflection,forName) interface
	set marshal_method_return_types(com.sun.star.reflection.XIdlReflection,getType) interface

	set marshal_method_return_types(com.sun.star.script.XInvocation,getIntrospection) interface
	set marshal_method_return_types(com.sun.star.script.XInvocation,hasMethod) boolean
	set marshal_method_return_types(com.sun.star.script.XInvocation,hasProperty) boolean
	set marshal_method_return_types(com.sun.star.script.XInvocation,invoke) any
	set marshal_method_return_types(com.sun.star.script.XInvocation2,getMemberNames) \[\]string

	set marshal_method_return_types(com.sun.star.container.XHierarchicalNameAccess,getByHierarchicalName) any

	set marshal_method_return_types(com.sun.star.container.XNamed,getName) string
}

# **************************** packInt8 ********************************

proc packInt8 {val} {
	variable data

	if {[string length $val] == 0} {
		# just to be save if the caller writes an empty string
		set val 0
	}
	append data(binary_request) [binary format c $val]
	incr data(binary_request_size) 1
}

# **************************** packInt16 *******************************

proc packInt16 {val} {
	variable data

	if {[string length $val] == 0} {
		# just to be save if the caller writes an empty string
		set val 0
	}
	append data(binary_request) [binary format S $val]
	incr data(binary_request_size) 2
}

# **************************** packInt32 *******************************

proc packInt32 {val} {
	variable data

	if {[string length $val] == 0} {
		# just to be save if the caller writes an empty string
		set val 0
	}
	append data(binary_request) [binary format I $val]
	incr data(binary_request_size) 4
}

# **************************** checkIsLittleEndian *********************

proc checkIsLittleEndian {} {
	variable data

	set bin_val [binary format d 1.1]
	set xx [binary scan $bin_val cccccccc v1 v2 v3 v4 v5 v6 v7 v8]
	if {[string compare [format {0x%02x} [expr {$v8 & 0xff}]] "0x3f"] == 0} {
		set data(is_little_endian) 1
	} else {
		set data(is_little_endian) 0
	}
}

# **************************** packCompressedSize **********************

proc packCompressedSize {val} {
	variable data

	if {$val < 255} {
		packInt8 $val
	} else {
		packInt8 0xff
		packInt32 $val
	}
}

# **************************** packStringBinary ************************

proc packStringBinary {value} {
	variable data

	set lgth [string length $value]
	packCompressedSize $lgth
	append data(binary_request) $value
	incr data(binary_request_size) $lgth
}

# **************************** packFloat *******************************

proc packFloat {val} {
	variable data

	set bin_val [binary format f $val]
	if {![info exists data(is_little_endian]} {
		checkIsLittleEndian
	}
	if {$data(is_little_endian)} {
		set xx [binary scan $bin_val cccc v1 v2 v3 v4]
		set bin_val [binary format cccc ${v4} ${v3} ${v2} ${v1}]
	}
	append data(binary_request) $bin_val
	incr data(binary_request_size) 4
}

# **************************** packDouble ******************************

proc packDouble {val} {
	variable data

	set bin_val [binary format d $val]
	if {![info exists data(is_little_endian]} {
		checkIsLittleEndian
	}
	if {$data(is_little_endian)} {
		set xx [binary scan $bin_val cccccccc v1 v2 v3 v4 v5 v6 v7 v8]
		set bin_val [binary format cccccccc ${v8} ${v7} ${v6} ${v5} ${v4} ${v3} ${v2} ${v1}]
	}
	append data(binary_request) $bin_val
	incr data(binary_request_size) 8
}

# **************************** packMethodArgument **********************

proc packMethodArgument {lst} {
	variable data

	foreach {type value} $lst break
	switch $type {
	BOOLEAN {
	  	switch $value {
		True {
			set value 1
		  }
		False {
			set value 0
		  }
		default {
		  	puts stderr "funny value: $value in packMethodArgument:BOOLEAN:"
		  }
		}
	  	packInt8 $value
	  }
	STRING {
	  	packStringBinary $value
	  }
	BYTE {
	  	packInt8 $value
	  }
	CHAR {
	 	binary scan $value c val
		packInt16 $val
	 }
	SHORT {
	  	packInt16 $value
	  }
	LONG {
	  	packInt32 $value
	  }
	ENUM {
	  	packInt32 $value
	  }
	FLOAT {
	  	packFloat $value
	  }
	DOUBLE {
	  	packDouble $value
	  }
	SEQUENCE_SIZE {
	  	packCompressedSize $value
	  }
	OBJECT_ID {
		packStringBinary $value
	  }
	OBJECT_CACHE_INDEX {
		packInt16 $value
	  }
	TYPE_CLASS {
		set type_class_value $data(typeclass,$value)
		if {[llength $lst] > 2} {
			set is_new [lindex $lst 2]
			switch $is_new {
			NEW {
			  	set type_class_value [expr {$type_class_value + 0x80}]
			  }
			default {
				puts stderr "funny is_new: $is_new:"
			  }
			}
	  	}
		packInt8 $type_class_value
	  }
	TYPE_CACHE_INDEX {
		packInt16 $value
	  }
	CLASS_NAME {
		packStringBinary $value
	  }
	STRUCT {
		set type_class_value $data(typeclass,$value)
		packInt8 $type_class_value
	  }
	default {
		puts stderr "funny type in packMethodArgument: $type:"
	  }
	}
}

# **************************** buildBinarySendMessage ******************

proc buildBinarySendMessage {} {
	variable data

	# next line for debugging purpose only!
if {$data(send_debug)} {
	buildTextSendMessage
}
	fconfigure $data(connection_fd) -translation binary
	set binary_msg_lgth [binary format I $data(binary_request_size)]
	set binary_msg_id [binary format I $data(message_id)]
	set send_str $binary_msg_lgth
	append send_str $binary_msg_id
	append send_str $data(binary_request)
if {$data(binary_send_debug)} {
	puts -nonewline stderr "SEND:$data(binary_request_size):"
	dumpBinary -1
}
	return $send_str
}

# **************************** dumpBinary ******************************

proc dumpBinary {num_bytes {start_idx -2} {my_str {}}} {
	variable data

	if {$num_bytes == -1} {
		set num_bytes [expr {$data(binary_request_size)}]
		set start_idx 0
		set my_str $data(binary_request)
	}
	if {$num_bytes == -2} {
		set num_bytes [expr {$data(binary_reply_size) - $data(binary_reply_offset)}]
	}
	if {$start_idx == -2} {
		set start_idx $data(binary_reply_offset)
	}
	set end_idx [expr {$start_idx + $num_bytes - 1}]
	if {[string length $my_str] == 0} {
		set my_str $data(binary_reply)
	}
	set ret [string range $my_str $start_idx $end_idx]
	set idx 0
	puts -nonewline stderr "dump_bytes:"
	while {$idx < $num_bytes} {
		set bin_val [string range $ret $idx $idx]
		binary scan $bin_val c val
		puts -nonewline stderr "[format 0x%02x [expr {$val & 0xff}]] "
		incr idx
	}
	puts stderr ""
}

}
