#*************************************************************************
#*
#*  $RCSfile: tcluno_swriter.tcl,v $
#*
#*  $Revision: 1.3 $
#*
#*  last change: $Author: wiede $ $Date: 2005/09/07 11:07:15 $
#*
#*  The Contents of this file are made available subject to the terms of
#*  the following license
#*
#*	 - GNU Lesser General Public License Version 2.1
#*
#*  GNU Lesser General Public License Version 2.1
#*  =============================================
#*  Copyright 2005 by Wolfgang Grosser
#*
#*  This library is free software; you can redistribute it and/or
#*  modify it under the terms of the GNU Lesser General Public
#*  License version 2.1, as published by the Free Software Foundation.
#*
#*  This library is distributed in the hope that it will be useful,
#*  but WITHOUT ANY WARRANTY; without even the implied warranty of
#*  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
#*  Lesser General Public License for more details.
#*
#*  You should have received a copy of the GNU Lesser General Public
#*  License along with this library; if not, write to the Free Software
#*  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
#*  MA  02111-1307  USA
#*
#*
#*  Author: Wolfgang Grosser
#*
#*   All Rights Reserved.
#*
#*   Contributor(s): 
#*
#*
#************************************************************************/

package require tcluno_soffice
namespace eval ::tcluno::swriter {
	variable _allowedNumberingStyles
	set _allowedNumberingStyles [list \
			ParagraphStyles \
			CharacterStyles \
		]
}
proc ::tcluno::swriter::appendText {text textString style {newParagraph 1}} {
	set end [$text getEnd]
	if {$newParagraph} {
		$text insertControlCharacter $end 0 0
	}
	$end setString $textString
#	puts stderr "$end setPropertyValue ParaStyleName [lindex $style 0]"
	$end setPropertyValue ParaStyleName [lindex $style 0]
#	ToDo: a lot of more options, need another interface for this
#	as this is really hardcoded
	foreach {property value} [lindex $style 1] {
		$end setPropertyValue $property $value
	}
}
proc ::tcluno::swriter::getStyleFamilies {doc} {
	set styleFamilies [$doc getStyleFamilies]
	set counter [$styleFamilies getCount]
	return [$styleFamilies getElementNames]
}
proc ::tcluno::swriter::getStyles {doc styleType {active 1}} {
	set styleFamily [$doc getStyleFamilies]
	set family [$styleFamily getByName $styleType]
	set counter [$family getCount]
	set styles [list]
	for {set i 0} {$i < $counter} {incr i} {
		set style [$family getByIndex $i]
		if {$active} {
			if {[string length [$style isInUse]] > 0} {
				lappend styles [$style DisplayName]
			}
		} else {
			lappend styles [$style DisplayName]
		}
	}
	return $styles
}
proc ::tcluno::swriter::pdfExport {doc filename} {
	set sequence [$::tcluno_soffice::desktop tcluno::createUnoSequence Any]
	set filter [$::tcluno_soffice::desktop tcluno::createUnoStructHelper com.sun.star.beans.PropertyValue {FilterName -1 writer_pdf_Export 0}]
	$::tcluno_soffice::desktop tcluno::appendUnoSequence $sequence $filter
	$doc storeToURL $filename $sequence
}

package provide tcluno_swriter 0.0
