#*************************************************************************
#*
#*  $RCSfile: listMethodInfos.tcl,v $
#*
#*  $Revision: 1.3 $
#*
#*  last change: $Author: wiede $ $Date: 2005/09/07 11:07:15 $
#*
#*  The Contents of this file are made available subject to the terms of
#*  the following license
#*
#*	 - GNU Lesser General Public License Version 2.1
#*
#*  GNU Lesser General Public License Version 2.1
#*  =============================================
#*  Copyright 2005 by Wolfgang Grosser
#*
#*  This library is free software; you can redistribute it and/or
#*  modify it under the terms of the GNU Lesser General Public
#*  License version 2.1, as published by the Free Software Foundation.
#*
#*  This library is distributed in the hope that it will be useful,
#*  but WITHOUT ANY WARRANTY; without even the implied warranty of
#*  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
#*  Lesser General Public License for more details.
#*
#*  You should have received a copy of the GNU Lesser General Public
#*  License along with this library; if not, write to the Free Software
#*  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
#*  MA  02111-1307  USA
#*
#*
#*  Author: Wolfgang Grosser
#*
#*   All Rights Reserved.
#*
#*   Contributor(s):
#*
#*
#************************************************************************/

proc listMethodInfos {cmd} {
    set member_infos [$cmd tcluno::getMemberMethodInfos $cmd]
    log::log debug "METHOD_INFOS"
    foreach entry $member_infos {
        foreach {method_name ret_type} $entry break
        set param_infos [lrange $entry 2 end]
        set params ""
        set sep ""
        foreach {mode type name} $param_infos {
            lappend params $mode $type $name
        }
        set method_infos($method_name) [list params $params ret_type $ret_type]
    }
    return [array get method_infos]
}
puts stderr hallo:soffice:listMethodInfos
package provide tcluno_soffice 0.0
