#*************************************************************************
#*
#*  $RCSfile: getTclunoTypeInfo.tcl,v $
#*
#*  $Revision: 1.3 $
#*
#*  last change: $Author: wiede $ $Date: 2005/09/07 11:07:15 $
#*
#*  The Contents of this file are made available subject to the terms of
#*  the following license
#*
#*	 - GNU Lesser General Public License Version 2.1
#*
#*  GNU Lesser General Public License Version 2.1
#*  =============================================
#*  Copyright 2005 by Arnulf Wiedemann
#*
#*  This library is free software; you can redistribute it and/or
#*  modify it under the terms of the GNU Lesser General Public
#*  License version 2.1, as published by the Free Software Foundation.
#*
#*  This library is distributed in the hope that it will be useful,
#*  but WITHOUT ANY WARRANTY; without even the implied warranty of
#*  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
#*  Lesser General Public License for more details.
#*
#*  You should have received a copy of the GNU Lesser General Public
#*  License along with this library; if not, write to the Free Software
#*  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
#*  MA  02111-1307  USA
#*
#*
#*  Author: Arnulf Wiedemann
#*
#*   All Rights Reserved.
#*
#*   Contributor(s): Wolfgang Grosser
#*
#*
#************************************************************************/


package require vfs
package require vfs::tar

namespace eval ::tcluno_type_info {

variable library [file dirname [info script]]
variable initted 0
variable enum_modules
variable struct_modules
variable constants_modules
variable typedef_modules
variable enum_classes
variable struct_classes
variable constants_classes
variable typedef_classes
variable enum_class_infos
variable struct_class_infos
variable constants_class_infos
variable typedef_class_infos
variable unknown_type_info "???"

proc InitTypeInfos {} {
	variable enum_modules
	variable struct_modules
	variable constants_modules
	variable typedef_modules
	variable enum_classes
	variable struct_classes
	variable constants_classes
	variable typedef_classes
	variable enum_class_infos
	variable struct_class_infos
	variable constants_class_infos
	variable typedef_class_infos
	variable library

	if {$::tcluno_type_info::initted} {
		return
	}
	set fd [::vfs::tar::Mount $library/tcluno_type_infos_all.tar ti]
	foreach type "enum constants struct typedef" {
		set utype [string toupper $type]
		set modules [::tar::getdir $fd . TYPE_INFOS/$utype/*]
		set ${type}_modules [lsort $modules]
		foreach module $modules {
			set classes [::tar::getdir $fd . TYPE_INFOS/$utype/$module/*]
			set ${type}_classes($module) [lsort $classes]
			foreach class $classes {
				set class_fd [vfs::tar::open $fd TYPE_INFOS/$utype/$module/$class r ""]
				set lst [list]
				while {[gets $class_fd line] > 0} {
					lappend lst $line
				}
				set ${type}_class_infos($class) $lst
			}

		}

	}
	vfs::filesystem unmount ti
	set ::tcluno_type_info::initted 1
}

proc getEnumModules {} {
	variable enum_modules

	InitTypeInfos
	return $enum_modules
}

proc getEnumClasses {module_name} {
	variable enum_classes
	variable unknown_type_info

	InitTypeInfos
	if {![info exists enum_classes($module_name)]} {
		return $unknown_type_info
	}
	return $enum_classes($module_name)
}

proc getEnumClassInfos {class_name} {
	variable enum_class_infos
	variable unknown_type_info

	InitTypeInfos
	if {![info exists enum_class_infos($class_name)]} {
		return $unknown_type_info
	}
	return $enum_class_infos($class_name)
}
proc getEnumClassValue {class_name value} {
	variable enum_class_infos
	variable unknown_type_info

	InitTypeInfos
	array set tmp [join $enum_class_infos($class_name)]
	if {[info exists tmp($value)]} {
		return $tmp($value)
	}
	return ""
}


proc getConstantsModules {} {
	variable constants_modules

	InitTypeInfos
	return $constants_modules
}

proc getConstantsClasses {module_name} {
	variable constants_classes
	variable unknown_type_info

	InitTypeInfos
	if {![info exists constants_classes($module_name)]} {
		return $unknown_type_info
	}
	return $constants_classes($module_name)
}

proc getConstantsClassInfos {class_name} {
	variable constants_class_infos
	variable unknown_type_info

	InitTypeInfos
	if {![info exists constants_class_infos($class_name)]} {
		return $unknown_type_info
	}
	return $constants_class_infos($class_name)
}
proc getConstantsClassValue {class_name value} {
	variable constants_class_infos
	InitTypeInfos
	array set tmp [join $constants_class_infos($class_name)]
	if {[info exists tmp($value)]} {
		return $tmp($value)
	}
	return ""
}
proc getTypedefModules {} {
	variable typedef_modules

	InitTypeInfos
	return $typedef_modules
}

proc getTypedefClasses {module_name} {
	variable typedef_classes
	variable unknown_type_info

	InitTypeInfos
	if {![info exists typedef_classes($module_name)]} {
		return $unknown_type_info
	}
	return $typedef_classes($module_name)
}

proc getTypedefClassInfos {class_name} {
	variable typedef_class_infos
	variable unknown_type_info

	InitTypeInfos
	if {![info exists typedef_class_infos($class_name)]} {
		return $unknown_type_info
	}
	return $typedef_class_infos($class_name)
}

proc getStructModules {} {
	variable struct_modules

	InitTypeInfos
	return $struct_modules
}

proc getStructClasses {module_name} {
	variable struct_classes
	variable unknown_type_info

	InitTypeInfos
	if {![info exists struct_classes($module_name)]} {
		return $unknown_type_info
	}
	return $struct_classes($module_name)
}

proc getStructClassInfos {class_name} {
	variable struct_class_infos
	variable unknown_type_info

	InitTypeInfos
	if {![info exists struct_class_infos($class_name)]} {
		return $unknown_type_info
	}
	return $struct_class_infos($class_name)
}

proc unknown_type_info {} {
	variable unknown_type_info
	return $unknown_type_info
}

}

package provide tcluno_type_info 0.0
