#*************************************************************************
#*
#*  $RCSfile: tcluno_simpress.tcl,v $
#*
#*  $Revision: 1.3 $
#*
#*  last change: $Author: wiede $ $Date: 2005/09/07 11:07:15 $
#*
#*  The Contents of this file are made available subject to the terms of
#*  the following license
#*
#*	 - GNU Lesser General Public License Version 2.1
#*
#*  GNU Lesser General Public License Version 2.1
#*  =============================================
#*  Copyright 2005 Wolfgang Grosser
#*
#*  This library is free software; you can redistribute it and/or
#*  modify it under the terms of the GNU Lesser General Public
#*  License version 2.1, as published by the Free Software Foundation.
#*
#*  This library is distributed in the hope that it will be useful,
#*  but WITHOUT ANY WARRANTY; without even the implied warranty of
#*  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
#*  Lesser General Public License for more details.
#*
#*  You should have received a copy of the GNU Lesser General Public
#*  License along with this library; if not, write to the Free Software
#*  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
#*  MA  02111-1307  USA
#*
#*
#*  Author: Wolfgang Grosser
#*
#*   All Rights Reserved.
#*
#*   Contributor(s): 
#*
#*
#************************************************************************/

package require tcluno_soffice
namespace eval ::tcluno::simpress {
}
proc ::tcluno::simpress::createShape {document shapeType rectangle} {
	set factory [$document queryInterface [$document ::tcluno::getTclunoType {TypeClass com.sun.star.lang.XMultiServiceFactory INTERFACE}]]
	set xObj [$factory createInstance $shapeType]
	set point [tcluno_soffice::createPoint [concat [lrange $rectangle 0 1] [lindex $rectangle 4]]]
#	set point [$tcluno_soffice::desktop tcluno::createUnoStructHelper com.sun.star.awt.Point [lrange $rectangle 0 1]]
	set size [tcluno_soffice::createSize [lrange $rectangle 2 4]]
#	set size [$tcluno_soffice::desktop tcluno::createUnoStructHelper com.sun.star.awt.Size [lrange $rectangle 2 3]]
	set xShape [$xObj queryInterface [$xObj ::tcluno::getTclunoType {TypeClass com.sun.star.drawing.XShape INTERFACE}]]
	$xShape setPosition $point
	$xShape setSize $size
	return $xShape
}
proc ::tcluno::simpress::setText {document page rectangle text {shapeType com.sun.star.drawing.TextShape}} {
	set xShape [createShape $document $shapeType $rectangle]
#	puts stderr [join [tcluno_soffice::getPropertyValues $xShape] "\n"]

	$page add $xShape

	set xText [$xShape queryInterface [$xShape ::tcluno::getTclunoType {TypeClass com.sun.star.text.XText INTERFACE}]]
	$xText setString $text
#	puts stderr [join [tcluno_soffice::getPropertyValues $xText] "\n"]
	return $xText
}

package provide tcluno_simpress 0.0
