#*************************************************************************
#*
#*  $RCSfile: tcluno_scalc.tcl,v $
#*
#*  $Revision: 1.3 $
#*
#*  last change: $Author: wiede $ $Date: 2005/09/07 11:07:15 $
#*
#*  The Contents of this file are made available subject to the terms of
#*  the following license
#*
#*	 - GNU Lesser General Public License Version 2.1
#*
#*  GNU Lesser General Public License Version 2.1
#*  =============================================
#*  Copyright 2005 Wolfgang Grosser
#*
#*  This library is free software; you can redistribute it and/or
#*  modify it under the terms of the GNU Lesser General Public
#*  License version 2.1, as published by the Free Software Foundation.
#*
#*  This library is distributed in the hope that it will be useful,
#*  but WITHOUT ANY WARRANTY; without even the implied warranty of
#*  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
#*  Lesser General Public License for more details.
#*
#*  You should have received a copy of the GNU Lesser General Public
#*  License along with this library; if not, write to the Free Software
#*  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
#*  MA  02111-1307  USA
#*
#*
#*  Author: Wolfgang Grosser
#*
#*   All Rights Reserved.
#*
#*   Contributor(s): 
#*
#*
#************************************************************************/

package require tcluno_soffice

namespace eval ::tcluno_soffice::scalc {
	variable chartTypes [list \
			BarDiagram \
			AreaDiagram \
			LineDiagram \
			PieDiagram \
			DonutDiagram \
			NetDiagram \
			XYDiagram \
			StockDiagram \
		]
}
proc ::tcluno_soffice::scalc::setOptimalWidth {document sheetName columnList} {
	set sheet [getSheetByName $document $sheetName]
	set columns [$sheet getColumns]
	foreach col $columnList {
		set column [$columns getByIndex $col]
		$column setPropertyValue OptimalWidth 1
	}
}
proc ::tcluno_soffice::scalc::formatCells {document sheetName cellRange option value} {
	set sheet [getSheetByName $document $sheetName]
	set range [eval $sheet getCellRangeByPosition $cellRange]
	$range setPropertyValue $option $value
}
proc ::tcluno_soffice::scalc::renameSheet {document oldSheetName newSheetName} {
	set sheet [getSheetByName $document $oldSheetName]
	if {[string length $sheet] == 0} {
		return
	}
	$sheet setName $newSheetName
}
proc ::tcluno_soffice::scalc::deleteSheet {document sheetName} {
	set sheet [getSheetByName $document $sheetName]
	if {[string length $sheet] == 0} {
		return
	}
	[$document getSheets] removeByName $sheetName
}
proc ::tcluno_soffice::scalc::addSheet {document sheetName {position end}} {
	set sheets [$document getSheets]
	set sheetCount [$sheets getCount]
	if {[string equal $position end] || $position > $sheetCount} {
		set position $sheetCount
	}
	if {$position < 0} {
		set position 0
	}
	$sheets insertNewByName $sheetName $position
	return [getSheetByName $document $sheetName]
}
proc ::tcluno_soffice::scalc::getSheetByName {document sheetName} {
	set sheetNames [getSheetNames $document]
	if {[lsearch -exact $sheetNames $sheetName] < 0} {
		return ""
	}
	set sheets [$document getSheets]
	set sheet [$sheets getByName $sheetName]
	return $sheet
}
proc ::tcluno_soffice::scalc::getSheetNames {document} {
	set sheets [$document getSheets]
	set count [$sheets getCount]
	set nameList [list]
	for {set i 0} {$i < $count} {incr i} {
		set sheet [$sheets getByIndex $i]
		lappend nameList [$sheet getName]
	}
	return $nameList
}
proc ::tcluno_soffice::scalc::insertLine {sheet line row {startCol 0}} {
	set col $startCol
	foreach cellValue $line {
		if {[string length $cellValue] == 0} {
			incr col
			continue
		}
		set cell [$sheet getCellByPosition $col $row]
		if {[string is double $cellValue]} {
			$cell setValue $cellValue
		} elseif {[string equal [string index $cellValue 0] {=}]} {
			$cell setFormula $cellValue
		} else {
			$cell setString $cellValue
		}
		$cell setFormula $cellValue
		incr col
	}
}
proc ::tcluno_soffice::scalc::openFile {desktop filename {hidden 0}} {
	set filterSequence [$desktop tcluno::createUnoSequence Any]
	if {$hidden} {
		set hiddenFilter [$desktop tcluno::createUnoStructHelper com.sun.star.beans.PropertyValue {Hidden -1 True 0}]
		$desktop tcluno::appendUnoSequence $filterSequence $hiddenFilter
	}
	if {[string length $filename] == 0} {
		set filename "private:factory/scalc"
	}
	if {[string equal [file extension $filename] {.xls}]} {
		set msExcelFilter [$desktop tcluno::createUnoStructHelper com.sun.star.beans.PropertyValue {FilterName -1 {MS Excel 97} 0}]
		$desktop tcluno::appendUnoSequence $filterSequence $msExcelFilter
	}
	set doc [$desktop loadComponentFromURL $filename "_blank" 0 $filterSequence]
	return $doc
}
proc ::tcluno_soffice::scalc::importFile {filename document sheetName splitCmd {startRow 0} {startCol 0}} {
#	log::log debug document:[tcluno_soffice::show_method_infos $document]
	set sheet [getSheetByName $document $sheetName]
	if {[string length $sheet] == 0} {
		set sheet [addSheet $document $sheetName 0]
	}
	set fd [open $filename]
	set row $startRow
	while {[gets $fd line] >= 0} {
		log::log debug $row
		insertLine $sheet [eval $splitCmd [list $line]] $row $startCol
		incr row
	}
	close $fd
}
proc ::tcluno_soffice::scalc::saveFile {desktop filename document} {
	set filterSequence [$desktop tcluno::createUnoSequence Any]
	switch [file extension $filename] {
		.xls {
			set msExcelFilter [$desktop tcluno::createUnoStructHelper com.sun.star.beans.PropertyValue {FilterName -1 {MS Excel 97} 0}]
			$desktop tcluno::appendUnoSequence $filterSequence $msExcelFilter
		}
	}
	if {[string equal [file pathtype $filename] {relative}]} {
		set filename [file join [pwd] $filename]
	}
	if {[string first {file:} $filename] != 0} {
		set filename file:$filename
	}
	$document storeAsURL $filename $filterSequence
}
proc ::tcluno_soffice::scalc::createChart {document targetSheetName graphicRectangle chartName options sourceSheetName sourceRange} {
	set sheetNames [getSheetNames $document]
	set sourceIdx [lsearch -exact $sheetNames $sourceSheetName]
	if {$sourceIdx < 0} {
		return
	}
	set targetSheet [getSheetByName $document $targetSheetName]
	if {[string length $targetSheet] == 0} {
		set targetSheet [addSheet $document $targetSheetName]
	}
	set charts [$targetSheet getCharts]
	if {![string equal $targetSheetName $sourceSheetName]} {
		set  sourceSheet $targetSheet
	} else {
		set  sourceSheet [getSheetByName $document $sourceSheetName]
	}
	set rectangle [::tcluno_soffice::createRectangle $graphicRectangle]
	set cellRangeSequence [$tcluno_soffice::desktop tcluno::createUnoSequence Any]
	set cellRange [$tcluno_soffice::desktop tcluno::createUnoStructHelper com.sun.star.table.CellRangeAddress [concat $sourceIdx $sourceRange]]
	$tcluno_soffice::desktop tcluno::appendUnoSequence $cellRangeSequence $cellRange
	array set optionArray $options
	set hasColumnHeader 0
	if {[info exists optionArray(hasColumnHeader)]} {
		set hasColumnHeader $optionArray(hasColumnHeader)
		unset optionArray(hasColumnHeader)
	}
	set hasRowHeader 0
	if {[info exists optionArray(hasRowHeader)]} {
		set hasRowHeader $optionArray(hasRowHeader)
		unset optionArray(hasRowHeader)
	}
	$charts addNewByName $chartName $rectangle $cellRangeSequence $hasColumnHeader $hasRowHeader
	set chart [$charts getByName $chartName]
	set chartObject [$chart getEmbeddedObject]
	foreach {option value} [array get optionArray] {
		switch $option {
			title {
				setChartTitle $chartObject $value
			}
			type {
				eval setChartType $chartObject $value
			}
		}
	}
	return $chart
}
proc ::tcluno_soffice::scalc::setChartType {chartObject chartType {options ""}} {
	variable chartTypes

	if {[lsearch -exact $chartTypes $chartType] < 0} {
		puts stderr "allowed chartTypes: $chartTypes"
		return
	}
	set diagram [$chartObject createInstance com.sun.star.chart.$chartType]
	$chartObject setDiagram $diagram
	foreach {option value} $options {
		$diagram setPropertyValue $option $value
	}
#	set solidType [tcluno_type_info::getConstantsClassValue com.sun.star.chart.ChartSolidType CONES]
}
proc ::tcluno_soffice::scalc::setChartTitle {chartObject chartTitle} {
	set title [$chartObject getTitle]
	$title setPropertyValue String $chartTitle
}
proc ::tcluno_soffice::scalc::setActiveSheet {document sheetName} {
	set controller [$document getCurrentController]
	set sheet [getSheetByName $document $sheetName]
	$controller setActiveSheet $sheet
}
proc ::tcluno_soffice::scalc::setFreezePane {document sheetName column row} {
	set controller [$document getCurrentController]
	set activeSheet [$controller getActiveSheet]
	set sheet [getSheetByName $document $sheetName]
	$controller setActiveSheet $sheet
	$controller freezeAtPosition $column $row
	$controller setActiveSheet $activeSheet
}

package provide tcluno_scalc 0.0
