#!/bin/sh
#
# Beispiel für TclUno
# \
exec tclsh "$0" "$@"

lappend auto_path [ file join [ pwd ] tclurtp ]
lappend auto_path [ file join [ pwd ] tcluno ]
lappend auto_path [ file join [ pwd ] itcluno ]

# damit wird die Skriptlösung angefordert
set ::argv "-urtp"

package require itcluno

# Dokument erzeugen 
set spreadsheet [::itcluno::SpreadSheet #auto]

$spreadsheet renameSheet Tabelle1 Werte

# Werte Setzen 
$spreadsheet setCellValue Werte [list 0 0] {{"" Tag Uhrzeit Wochentag Wasserstand}}

# Wasserstand Harburg Schleuese (www.bsh.de)
set daten [ list \
     [ list HW 01.01.2006 05:05 So  2.4 ] \
     [ list NW 01.01.2006 12:38 So  -1.5 ] \
     [ list HW 01.01.2006 17:40 So  2.3 ] \
     [ list HW 02.01.2006 00:53 Mo  -1.4 ] \
     [ list HW 02.01.2006 05:55 Mo  2.5 ] \
     [ list NW 02.01.2006 13:32 Mo  -1.5 ] \
     [ list HW 02.01.2006 18:33 Mo  2.3 ] \
     [ list NW 03.01.2006 01:44 Di  -1.4 ] \
     [ list HW 03.01.2006 06:44 Di  2.5 ] \
     [ list NW 03.01.2006 14:26 Di  -1.5 ] \
     [ list HW 03.01.2006 19:24 Di  2.2 ] \
     [ list NW 04.01.2006 02:30 Mi  -1.4 ] \
     [ list HW 04.01.2006 07:30 Mi  2.5 ] \
     [ list NW 04.01.2006 15:13 Mi  -1.6 ] \
     [ list HW 04.01.2006 20:09 Mi  2.1 ] \
     [ list NW 05.01.2006 03:12 Do  -1.5 ] \
     [ list HW 05.01.2006 08:14 Do  2.5 ] \
     [ list NW 05.01.2006 15:58 Do  -1.6 ] \
     [ list HW 05.01.2006 20:54 Do  2.0 ] \
     [ list NW 06.01.2006 03:55 Fr  -1.5 ] \
     [ list HW 06.01.2006 09:01 Fr  2.5 ] \
     [ list NW 06.01.2006 16:43 Fr  -1.5 ] \
     [ list HW 06.01.2006 21:42 Fr  2.0 ] \
     [ list NW 07.01.2006 04:44 Sa  -1.4 ] \
     [ list HW 07.01.2006 09:52 Sa  2.4 ] \
     [ list NW 07.01.2006 17:32 Sa  -1.5 ] \
     [ list HW 07.01.2006 22:32 Sa  1.9 ]  ]

$spreadsheet setCellValue Werte [list 0 1] $daten

# Graphik erzeugen 
#set sourceRange 
$spreadsheet createChart Werte [list 12 1 12 12 cm] \
	[list hasRowHeader 1 hasColumnHeader 1 title "Harburg Schleuse" type LineDiagram] \
	Werte [list 3 1 4 28]

tcluno_soffice::windowTitle [$spreadsheet cget -desktop] "Wasserstand: Harburg Schleuse"

$spreadsheet exportToPdf wasserstand.pdf
