#!/bin/sh
#
# Beispiel für TclUno
# \
exec tclsh "$0" "$@"

lappend auto_path [ file join [ pwd ] tclurtp ]
lappend auto_path [ file join [ pwd ] tcluno ]

# damit wird die Skriptlösung angefordert
set ::argv "-urtp"

# Erweiterung laden
package require tcluno_scalc

# Kontakt mit OpenOffice herstellen
if {[catch {::tcluno_soffice::initDesktop } desktop]} {
    puts stderr "Verbindung mit OpenOffice fehlgeschlagen !"
    puts stderr "Fehler war:"
    puts stderr $desktop
    puts stderr ""
    puts stderr "Bitte OpenOffice mit Netzwerkunterstützung starten:"
    puts stderr "ooffice \"-accept=socket,host=localhost,port=2002;urp;\""
    exit 1
}

# Schnittstellen anzeigen
puts "desktop hat folgende Schnittstellen:"
puts [ join [$desktop getTypes] "\n" ]

puts "\ndesktop ist folgender Service:"
puts [$desktop getSupportedServiceNames]

# leere Liste erstellen
set filterSequence [$desktop tcluno::createUnoSequence Any]

# neues Dokument in Tabellenkalkulation
set spreadsheet [$desktop loadComponentFromURL  "private:factory/scalc" \
		     "_blank" 0  $filterSequence ]

# erste Seite finden
set sheets [$spreadsheet getSheets]
set sheet [$sheets getByIndex 0]

puts "\nTabellenname ist: [$sheet getName]"
$sheet setName "Zufallszahlen"

# Tabelle mit Zufallszahlen füllen
for { set col 0} { $col < 10} {incr col} {
    for { set row 0} { $row < 10} {incr row} {
	set cell [$sheet getCellByPosition $col $row]
	set value [expr rand() * 100]
	$cell setValue $value
    }
}

# Zellenadresse 
set cell [ $sheet getCellRangeByName "A12" ]
puts "\nKomplette Adresse: [ $cell getCellAddress ]"

# Formeln und Texte
set cell [ $sheet getCellRangeByName "A12" ]
$cell setFormula "Summe:"

set cell [ $sheet getCellRangeByName "B12" ]
$cell setFormula "=sum(B1:B10)"

set cell [ $sheet getCellRangeByName "A13" ]
$cell setFormula "Mittelwert:"

set cell [ $sheet getCellRangeByName "B13" ]
$cell setFormula "=median(B1:B10)"

# Als Excell speichern
set filterSequence [$::desktop tcluno::createUnoSequence Any]
set msExcelFilter [$::desktop tcluno::createUnoStructHelper \
		       com.sun.star.beans.PropertyValue \
		       {FilterName -1 {MS Excel 97} 0}
		  ]
$::desktop tcluno::appendUnoSequence $filterSequence $msExcelFilter

$spreadsheet storeAsURL file:/tmp/test.xls $filterSequence

