package require xml
package require xslt
encoding system utf-8

proc getFileName {w} {
	set filename [tk_getOpenFile -filetypes [list [list XML-Files [list .xml]]]]
	$w delete 0 end
	$w insert end $filename
}
proc transform {w textW} {
	set rootname [$w get]
	$textW delete 1.0 end
	if {![file exists $rootname]} {
		return
	}
	doTransform $rootname $textW
}
proc doTransform {filename {textW ""}} {
	if {[catch {
		set rootname [file rootname $filename]
		set stylesheet itcluno_example.xsl
		set fd [open $stylesheet]
		set style [read $fd]
		close $fd
		set style_doc [::dom::libxml2::parse $style]
		set ssheet [::xslt::compile $style_doc]
		::dom::libxml2::destroy $style_doc

		set infile $rootname.xml
		set fd [open $infile]
		set xml_doc [read $fd]
		close $fd
		set xml_parsed [::dom::libxml2::parse $xml_doc]
		set result [$ssheet transform $xml_parsed]
		::dom::libxml2::destroy $xml_parsed
		set xml_doc [::dom::libxml2::serialize $result]
		::dom::libxml2::destroy $result
		set outfile $rootname.tcl
#		set fd [open $outfile w]
		set fd stdout
		puts $fd $xml_doc
#		puts $fd [encoding convertfrom utf-8 $xml_doc]
		if {[string length $textW] > 0} {
			$textW insert end $xml_doc
		}
#		close $fd
	} msg]} {
		if {[string length $textW] > 0} {
			$textW insert end $xml_doc
		} else {
			puts stderr $msg
		}
		return
	}
}
if {[string equal [lindex $argv 0] {-nogui}]} {
	doTransform [lindex $argv 1]
	return
}
package require BWidget
entry .filename -width 50
grid .filename -row 0 -column 0
button .getFile -text "File" -command [list getFileName .filename]
grid .getFile -row 0 -column 1
button .transform -text "Transform" -command [list transform .filename .text]
grid .transform -row 1 -column 0
ScrolledWindow .sw
grid .sw -row 2 -column 0 -columnspan 3 -sticky wens
text .text
.sw setwidget .text

