<?xml version="1.0" encoding="iso-8859-1" ?>
<xsl:stylesheet version="1.0"
     xmlns:xsl="http://www.w3.org/1999/XSL/Transform">

<xsl:output
  method="html"
  encoding="iso8859-1"
/>

<xsl:strip-space elements="synopsis inheritance options methods method"/>
<xsl:template match="/">
<xsl:text disable-output-escaping="yes">&lt;!DOCTYPE HTML PUBLIC "-//W3C//DTD HTML 4.01 Transitional//EN" "http://www.w3.org/TR/html4/loose.dtd"/&gt;</xsl:text>
<html>
 <head>
 <link type="text/css" rel="stylesheet" href="itcluno_man.css"/>
 <title>
  <xsl:call-template name="manpage" />
 </title>
 <meta content="text/html; charset=UTF-8"/>
 </head>
 <body>
  <xsl:call-template name="manpagename" />
  <xsl:call-template name="common_description" />
  <xsl:call-template name="synopsis" />
  <xsl:call-template name="inheritance" />
  <xsl:call-template name="options" />
  <xsl:call-template name="methods" />
  <xsl:call-template name="procedures" />
  <xsl:call-template name="special_parameters" />
  <xsl:call-template name="examples" />
  <xsl:call-template name="bugs" />
  <xsl:call-template name="todo" />
  <br/><br/><a href="#top">Top</a>
 </body>
</html>
</xsl:template>

<xsl:template match="referto">
<xsl:text disable-output-escaping="yes">&lt;a href=&quot;</xsl:text>
<xsl:value-of select="@ref" />
<xsl:text disable-output-escaping="yes">&quot;&gt;</xsl:text>
<xsl:value-of select="." />
<xsl:text disable-output-escaping="yes">&lt;/a&gt;</xsl:text>
</xsl:template>

<xsl:template match="newline">
<xsl:text disable-output-escaping="yes">&lt;br&gt;</xsl:text>
</xsl:template>

<xsl:template name="manpage">
<xsl:value-of select="/manpage/@name" />
</xsl:template>
<xsl:template name="manpagename">
<xsl:for-each select="/manpage">
<a name="top"/><h2>Name</h2><ul><xsl:value-of select="/manpage/@namespace" /><xsl:value-of select="@name" /> - <span class="blue"><xsl:value-of select="@desc" /></span></ul>
</xsl:for-each>
</xsl:template>

<xsl:template name="synopsis">
<h2>Synopsis</h2>
<xsl:for-each select="/manpage/synopsis/cmd">
<ul><xsl:value-of select="/manpage/@namespace"/><xsl:apply-templates select="/manpage/synopsis" /></ul>
</xsl:for-each>

<ul><span class="method_list"><xsl:for-each select="/manpage/methods/method">
<xsl:element name="i">objectname </xsl:element>
<xsl:text disable-output-escaping="yes">&lt;a href=&quot;#</xsl:text>
<xsl:value-of select="@name" />
<xsl:text disable-output-escaping="yes">&quot;&gt;</xsl:text>
<xsl:value-of select="@name" />
<xsl:text disable-output-escaping="yes">&lt;/a&gt;
</xsl:text><xsl:value-of select="@arguments" /><br/>
</xsl:for-each>
<xsl:for-each select="/manpage/procedures/procedure">
<xsl:element name="i"><xsl:value-of select="/manpage/@namespace" /><xsl:value-of select="/manpage/@name" /><xsl:text>::</xsl:text></xsl:element>
<xsl:text disable-output-escaping="yes">&lt;a href=&quot;#</xsl:text>
<xsl:value-of select="@name" />
<xsl:text disable-output-escaping="yes">&quot;&gt;</xsl:text>
<xsl:value-of select="@name" />
<xsl:text disable-output-escaping="yes">&lt;/a&gt;
</xsl:text><xsl:value-of select="@arguments" /><br/>
</xsl:for-each></span></ul>
</xsl:template>

<xsl:template name="inheritance">
<xsl:for-each select="/manpage/inheritance">
<h2>Inheritance</h2>
<xsl:call-template name="inheritfrom" />
</xsl:for-each>
</xsl:template>

<xsl:template name="inheritfrom">
<xsl:for-each select="inheritfrom">
<ul><xsl:value-of select="/manpage/@namespace" />
<xsl:text disable-output-escaping="yes">&lt;a href=&quot;</xsl:text><xsl:apply-templates select="." /><xsl:text disable-output-escaping="yes">.html&quot;&gt;</xsl:text><xsl:apply-templates select="." /><xsl:text disable-output-escaping="yes">&lt;/a&gt;</xsl:text>
</ul></xsl:for-each>
</xsl:template>

<xsl:template name="common_description">
<xsl:for-each select="/manpage/common_description">
<h2>Description</h2>
<ul><xsl:apply-templates select="." /></ul>
</xsl:for-each>
</xsl:template>

<xsl:template name="todo">
<xsl:for-each select="/manpage/todo">
<h2>ToDo</h2>
<ul><xsl:apply-templates select="." /></ul>
</xsl:for-each>
</xsl:template>

<xsl:template name="bugs">
<xsl:for-each select="/manpage/bugs">
<h2>Bugs</h2>
<ul><xsl:apply-templates select="." /></ul>
</xsl:for-each>
</xsl:template>

<xsl:template name="examples">
<xsl:for-each select="/manpage/examples">
<h2>Examples</h2>
<xsl:call-template name="example" />
</xsl:for-each>
</xsl:template>

<xsl:template name="options">
<xsl:for-each select="/manpage/options">
<h2>Standard Options</h2>
<ul><xsl:call-template name="option" /></ul>
</xsl:for-each>
</xsl:template>

<xsl:template name="example">
<xsl:for-each select="/manpage/examples/example">
<ul><h3><xsl:value-of select="@name" /></h3>
<xsl:apply-templates select="description" /><br/>
<pre class="sourcecode">package require itcluno<br/><xsl:apply-templates select="code" /></pre><br/>
</ul></xsl:for-each>
</xsl:template>

<xsl:template name="option">
<xsl:for-each select="/manpage/options/option">
<span class="method_description"><optionname>-<xsl:value-of select="@name" /></optionname></span> - <xsl:apply-templates select="." /><br/>
</xsl:for-each>
</xsl:template>

<xsl:template name="methods">
<xsl:for-each select="/manpage/methods">
<h2>Methods</h2>
<xsl:call-template name="method" />
</xsl:for-each>
</xsl:template>

<xsl:template name="method">
<xsl:for-each select="method">
<ul><span class="method_description"><xsl:element name="i">objectname</xsl:element><xsl:text disable-output-escaping="yes"> </xsl:text><xsl:text disable-output-escaping="yes">&lt;a name=&quot;</xsl:text>
<xsl:value-of select="@name" />
<xsl:text disable-output-escaping="yes">&quot;&gt;</xsl:text>
<xsl:value-of select="@name" />
<xsl:text disable-output-escaping="yes">&lt;/a&gt;</xsl:text>
<xsl:text disable-output-escaping="yes"> </xsl:text><xsl:value-of select="@arguments" /></span>
<ul><xsl:apply-templates select="description" /><xsl:call-template name="returnvalue" /></ul>
</ul></xsl:for-each>
</xsl:template>

<xsl:template name="procedures">
<xsl:for-each select="/manpage/procedures">
<h2>Procedures</h2>
<ul><xsl:call-template name="procedure" /></ul>
</xsl:for-each>
</xsl:template>

<xsl:template name="procedure">
<xsl:for-each select="procedure">
<span class="method_description"><xsl:element name="i"><xsl:value-of select="/manpage/@namespace" /><xsl:value-of select="/manpage/@name" />::</xsl:element><xsl:text disable-output-escaping="yes">&lt;a name=&quot;</xsl:text>
<xsl:value-of select="@name" />
<xsl:text disable-output-escaping="yes">&quot;&gt;</xsl:text>
<xsl:value-of select="@name" />
<xsl:text disable-output-escaping="yes">&lt;/a&gt;</xsl:text>
<xsl:text disable-output-escaping="yes"> </xsl:text><xsl:value-of select="@arguments" /></span>
<ul><xsl:apply-templates select="description" /><xsl:call-template name="returnvalue" /></ul><br/>
</xsl:for-each>
</xsl:template>

<xsl:template name="special_parameters">
<xsl:for-each select="/manpage/special_parameters">
<h2>Special Parameters</h2>
<xsl:call-template name="special_parameter" />
</xsl:for-each>
</xsl:template>

<xsl:template name="special_parameter">
<xsl:for-each select="/manpage/special_parameters/special_parameter">
<xsl:text disable-output-escaping="yes">&lt;a name=&quot;</xsl:text>
<xsl:value-of select="@name" />
<xsl:text disable-output-escaping="yes">&quot;&gt;</xsl:text>
<xsl:value-of select="@description" />
<xsl:text disable-output-escaping="yes">&lt;/a&gt;</xsl:text>
<xsl:apply-templates select="." />
<br/>
</xsl:for-each>
</xsl:template>

<xsl:template name="returnvalue">
<br/><b>Return-Value</b>:<xsl:text disable-output-escaping="yes"> </xsl:text><xsl:apply-templates select="returnvalue" />
</xsl:template>

</xsl:stylesheet>
