<xsl:stylesheet version="1.0"
     xmlns:xsl="http://www.w3.org/1999/XSL/Transform">

<xsl:output
  method="html"
  encoding="iso8859-1"
/>

<xsl:strip-space elements="synopsis inheritance options methods method"/>
<xsl:template match="/">
  <xsl:call-template name="examples" />
</xsl:template>

<xsl:template name="examples">
<xsl:for-each select="/manpage/examples">
<xsl:call-template name="example" />
</xsl:for-each>
</xsl:template>

<xsl:template name="example">
<xsl:for-each select="/manpage/examples/example">
set name "<xsl:value-of select="/manpage/@name" />:<xsl:value-of select="@name" />"
set description($name) {
<xsl:apply-templates select="description" />
}; # END OF EXAMPLE-DESCRIPTION
set example($name) {
package require itcluno
<xsl:apply-templates select="code" />
tcluno_soffice::windowTitle [new_document cget -desktop] "TCLUNO - DEMO: <xsl:value-of select="@name"/>"
}; # END OF EXAMPLE-CODE
</xsl:for-each>
</xsl:template>

<xsl:template match="newline">
<xsl:text>\n</xsl:text>
</xsl:template>
</xsl:stylesheet>
