set name "Writer:simple"
set description($name) {
write a simple "hallo" to the Writer document
}; # END OF EXAMPLE-DESCRIPTION
set example($name) {
package require itcluno

catch {itcl::delete object new_document}

itcluno::Writer new_document
new_document appendText hallo

tcluno_soffice::windowTitle [new_document cget -desktop] "TCLUNO - DEMO: simple"
}; # END OF EXAMPLE-CODE

set name "Writer:ParagraphStyles"
set description($name) {
This examples shows all properties of all styles of all style families.\nIt produces about 350 pages in the writer document
}; # END OF EXAMPLE-DESCRIPTION
set example($name) {
package require itcluno

catch {itcl::delete object new_document}

itcluno::Writer new_document
set numberingStyleName "Numbering 5"
set paraStyle "Text body"
new_document setNumberingStyles $numberingStyleName [list 0 1 2]
set numberingStyle [list NumberingStyleName "Numbering 1" NumberingLevel %d]
set tmpFormat [concat [list ParaStyleName "Heading 1"] [format $numberingStyle 0]]
new_document appendParagraph "StyleFamilies" $tmpFormat
set familyCount 0
foreach family [lsort [new_document getStyleFamilies]] {
	if {$familyCount == 0} {
		set familyStartValue "NumberingStartValue 1"
		incr familyCount
	}
	set tmpFormat [concat [list ParaStyleName "Heading 2"] [format $numberingStyle 1]]
	new_document appendParagraph "$family" $tmpFormat
	set styleCount 0
	set counter 0
	foreach style [lsort [new_document getStyles $family]] {
		if {$styleCount == 0} {
			set styleStartValue "NumberingStartValue 1"
			incr styleCount
		}
		set tmpFormat [concat [list ParaStyleName "Heading 3"] [format $numberingStyle 2]]
		new_document appendParagraph "$style" $tmpFormat
		set props [new_document getStyleProperties $family $style]
		set propList [list]
		foreach {prop value} $props {
			lappend propList [list $prop\t$value]
		}
		new_document appendParagraph [join $propList "\n"] [list ParaStyleName "Text body" NumberingStyleName ""]
		incr counter
		if {$counter > 1000} break
	}
}

tcluno_soffice::windowTitle [new_document cget -desktop] "TCLUNO - DEMO: ParagraphStyles"
}; # END OF EXAMPLE-CODE

set name "Writer:Numbering"
set description($name) {
This example show the numbering capabilities of a writer document (right now the attributes are hard coded in the source of the Writer class as this method is very new)
}; # END OF EXAMPLE-DESCRIPTION
set example($name) {
package require itcluno

catch {itcl::delete object new_document}

itcluno::Writer new_document

set numberingStyleName "Numbering 1"
new_document setNumberingStyles $numberingStyleName [list 0 1 2]
set paraStyle "Text body"
set paraTabStops [itcluno::OfficeUtilities::makeSequence [list \
	[list 6000 0 [[new_document document] ::tcluno::getTclunoChar [list CharClass "."]] [[new_document document] ::tcluno::getTclunoChar [list CharClass "."]]] \
	[list 10000 3 [[new_document document] ::tcluno::getTclunoChar [list CharClass ","]] [[new_document document] ::tcluno::getTclunoChar [list CharClass "-"]]] \
	[list 15000 2 [[new_document document] ::tcluno::getTclunoChar [list CharClass ","]] [[new_document document] ::tcluno::getTclunoChar [list CharClass "-"]]] \
] com.sun.star.style.TabStop]
new_document setStyleProperties ParagraphStyles $paraStyle [list ParaTabStops $paraTabStops]
set numberingStyle [list ParaStyleName $paraStyle NumberingStyleName "Numbering 1" NumberingLevel %d]
new_document appendParagraph "\tThis is a numbering level 1" [eval list [format $numberingStyle 0]]
new_document appendParagraph "\tThis is level 2 of numbering\t3,1" [eval list [format $numberingStyle 1] NumberingStartValue 18]
new_document appendText "\tThis is level 2 of numbering" [eval list [format $numberingStyle 1]]
new_document appendParagraph ", but with bold addition" [list CharWeight [itcluno::OfficeUtilities::constant com.sun.star.awt.FontWeight BOLD]]
new_document appendText "\tThis is level 2 of numbering" [format $numberingStyle 1]
new_document appendParagraph ", but with red wavelike underlining" [list CharUnderlineHasColor True CharUnderlineColor 0xff0000 CharUnderline [itcluno::OfficeUtilities::constant com.sun.star.awt.FontUnderline WAVE] CharWeight [itcluno::OfficeUtilities::constant com.sun.star.awt.FontWeight BOLD]]
new_document appendParagraph "\tThis is level 2 of numbering" [format $numberingStyle 1]
new_document appendParagraph "\tThis is level 3 of numbering" [eval list [format $numberingStyle 2]  NumberingStartValue 1]
new_document appendParagraph "\tThis is level 3 of numbering" [format $numberingStyle 2]
new_document appendParagraph "\tThis is again level 1 of numbering" [format $numberingStyle 0]
new_document appendParagraph "\tThis is again level 1 of numbering" [format $numberingStyle 0]
new_document appendParagraph "\tdecimal alignment\t3,1\tright aligned" [format $numberingStyle 0]
new_document appendParagraph "\tdecimal alignment\t123,1\talso right aligned" [format $numberingStyle 0]
puts stderr [new_document getStyleProperties ParagraphStyles "Text body"]

tcluno_soffice::windowTitle [new_document cget -desktop] "TCLUNO - DEMO: Numbering"
}; # END OF EXAMPLE-CODE

set name "Writer:Simple Numbering"
set description($name) {
This example shows the numbering capabilities of a writer document (right now the attributes are hard coded in the source of the Writer class as this method is very new)
}; # END OF EXAMPLE-DESCRIPTION
set example($name) {
package require itcluno

catch {itcl::delete object new_document}

itcluno::Writer new_document

set numberingStyleName "Numbering 1"
set paraStyle "Text body"
new_document setStyleProperties ParagraphStyles $paraStyle [list NumberingStyleName "Numbering 1"]
set paraTabStops [itcluno::OfficeUtilities::makeSequence [list \
	[list 6000 0 [[new_document document] ::tcluno::getTclunoChar [list CharClass "."]] [[new_document document] ::tcluno::getTclunoChar [list CharClass "."]]] \
	[list 10000 3 [[new_document document] ::tcluno::getTclunoChar [list CharClass ","]] [[new_document document] ::tcluno::getTclunoChar [list CharClass "-"]]] \
	[list 15000 2 [[new_document document] ::tcluno::getTclunoChar [list CharClass ","]] [[new_document document] ::tcluno::getTclunoChar [list CharClass "-"]]] \
] com.sun.star.style.TabStop]
new_document setStyleProperties ParagraphStyles $paraStyle [list ParaTabStops $paraTabStops]
set numberingStyle [list ParaStyleName $paraStyle NumberingStyleName "Numbering 1" NumberingLevel %d]
puts stderr "*****************************"
new_document appendParagraph "\tThis is a numbering level 1" [eval list [format $numberingStyle 0]]
#new_document setStyleProperties ParagraphStyles $paraStyle [format $numberingStyle 1]
new_document appendParagraph "\tThis is level 2 of numbering\t3,1" [eval list [format $numberingStyle 1]]
new_document appendText "\tThis is level 2 of numbering" [eval list [format $numberingStyle 1]]
new_document appendParagraph ", but with bold addition" [list CharWeight [itcluno::OfficeUtilities::constant com.sun.star.awt.FontWeight BOLD]]
new_document appendText "\tThis is level 2 of numbering"
#new_document appendParagraph ", but with red wavelike underlining" [list CharUnderlineHasColor True CharUnderlineColor 0xff0000 CharUnderline [itcluno::OfficeUtilities::constant com.sun.star.awt.FontUnderline WAVE] CharWeight [itcluno::OfficeUtilities::constant com.sun.star.awt.FontWeight BOLD]]
new_document appendParagraph ", but with red wavelike underlining" [list CharUnderlineHasColor True CharUnderlineColor 0xff0000 CharUnderline [itcluno::OfficeUtilities::constant com.sun.star.awt.FontUnderline WAVE] CharWeight [itcluno::OfficeUtilities::constant com.sun.star.awt.FontWeight BOLD]]
new_document appendParagraph "\tThis is level 2 of numbering" [format $numberingStyle 2]
new_document appendParagraph "\tThis is level 3 of numbering"
new_document appendParagraph "\tThis is level 3 of numbering"
new_document appendParagraph "\tThis is again level 1 of numbering"
new_document appendParagraph "\tThis is again level 1 of numbering"
new_document appendParagraph "\tdecimal alignment\t3,1\tright aligned"
set handle [new_document appendParagraph "\tdecimal alignment\t123,1\talso right aligned"]
new_document appendParagraph "\tThis is again numbering level 1" [eval list [format $numberingStyle 0]]
puts stderr [new_document getStyleProperties ParagraphStyles "Text body"]
new_document setNumberingStyles $numberingStyleName [list 0 1 2]

tcluno_soffice::windowTitle [new_document cget -desktop] "TCLUNO - DEMO: Simple Numbering"
}; # END OF EXAMPLE-CODE

set name "Writer:TextTable in Writer"
set description($name) {
This example creates a text table within a Writer document with "normal" text above and below
}; # END OF EXAMPLE-DESCRIPTION
set example($name) {
package require itcluno

catch {itcl::delete object new_document}

itcluno::Writer new_document

new_document appendText "This text will be followed by a TextTable"
set textTable [new_document appendTable 5 3]
$textTable setPropertyValues [itcluno::OfficeUtilities::tkColor2ooColor BackColor "light blue"]
$textTable setCellValue [list 0 0] \
	[list \
		[list "Cell 0.0" "Cell 0.1" "Cell 0.2"] \
		[list "Cell 1.0" "Cell 1.1" "Cell 1.2"] \
		[list "Cell 2.0" "Cell 2.1" "Cell 2.2"] \
		[list "Cell 3.0" "Cell 3.1" "Cell 3.2"] \
		[list "Cell 4.0" "Cell 4.1" "Cell 4.2"] \
	]
new_document appendText "Here we go with more text"

tcluno_soffice::windowTitle [new_document cget -desktop] "TCLUNO - DEMO: TextTable in Writer"
}; # END OF EXAMPLE-CODE


