set name "Tktable2OOTable:Simple Copy / SpreadSheet"
set description($name) {
Copies a Tktable to a SpreadSheet without adopting properties
}; # END OF EXAMPLE-DESCRIPTION
set example($name) {
package require itcluno

catch {itcl::delete object new_document}

package require Tktable

set top .top
catch {destroy $top}
toplevel $top

itcluno::SpreadSheet new_document

set sheetNames [new_document getSheetNames]
scan [lindex $sheetNames 0] {%[^0-9]*%d} tableBaseName dummy
set rows 10
set cols 7
set tktableWidget [table $top.tktableSpreadSheet -variable data \
	-cols $cols -rows $rows -titlerows 1 -titlecols 1]
for {set row 0} {$row < $rows} {incr row} {
	set line [list]
	for {set col 0} {$col < $cols} {incr col} {
		lappend line "Cell $row.$col"
	}
	$tktableWidget set row $row,0 $line
}
pack $tktableWidget -expand 1 -fill both
itcluno::Tktable2OOTable::Tktable2SpreadSheet $tktableWidget new_document ${tableBaseName}1 [list 2 4]

tcluno_soffice::windowTitle [new_document cget -desktop] "TCLUNO - DEMO: Simple Copy / SpreadSheet"
}; # END OF EXAMPLE-CODE

set name "Tktable2OOTable:Property Copy / SpreadSheet"
set description($name) {
Copies a Tktable to a SpreadSheet trying to adopt as many properties as possible
}; # END OF EXAMPLE-DESCRIPTION
set example($name) {
package require itcluno

catch {itcl::delete object new_document}

package require Tktable

set top .top
catch {destroy $top}
toplevel $top

itcluno::SpreadSheet new_document

set sheetNames [new_document getSheetNames]
scan [lindex $sheetNames 0] {%[^0-9]*%d} tableBaseName dummy
set rows 10
set cols 7
set tktableWidget [table $top.tktableSpreadSheet -variable data \
	-cols $cols -rows $rows -titlerows 1 -titlecols 1 \
	-font [list Courier 8] -background "lightblue"]
for {set row 0} {$row < 10} {incr row} {
	set line [list]
	for {set col 0} {$col < 8} {incr col} {
		lappend line "Cell $row.$col"
	}
	$tktableWidget set row $row,0 $line
}
$tktableWidget tag configure redline -background red -font [list Arial 20 bold]
$tktableWidget tag rowtag redline 5
$tktableWidget tag configure greencell -background green -font [list Arial 10 bold italic underline]
$tktableWidget tag celltag greencell 2,3
$tktableWidget tag configure leftcol -anchor e
$tktableWidget tag coltag leftcol 1

pack $tktableWidget -expand 1 -fill both

itcluno::Tktable2OOTable::Tktable2SpreadSheet $tktableWidget new_document ${tableBaseName}1 C3

tcluno_soffice::windowTitle [new_document cget -desktop] "TCLUNO - DEMO: Property Copy / SpreadSheet"
}; # END OF EXAMPLE-CODE

set name "Tktable2OOTable:Simple Copy / Writer"
set description($name) {
Copies a Tktable to a Writer document without adopting properties
}; # END OF EXAMPLE-DESCRIPTION
set example($name) {
package require itcluno

catch {itcl::delete object new_document ::textTable1}

package require Tktable

set top .top
catch {destroy $top}
toplevel $top

itcluno::Writer new_document

set rows 10
set cols 7
set tktableWidget [table $top.tktableSpreadSheet -variable data \
	-cols $cols -rows $rows -titlerows 1 -titlecols 1]
for {set row 0} {$row < $rows} {incr row} {
	set line [list]
	for {set col 0} {$col < $cols} {incr col} {
		lappend line "Cell $row.$col"
	}
	$tktableWidget set row $row,0 $line
}
pack $tktableWidget -expand 1 -fill both
itcluno::Tktable2OOTable::Tktable2TextTable $tktableWidget ::textTable1 new_document

tcluno_soffice::windowTitle [new_document cget -desktop] "TCLUNO - DEMO: Simple Copy / Writer"
}; # END OF EXAMPLE-CODE

set name "Tktable2OOTable:Property Copy / Writer"
set description($name) {
Copies a Tktable to a Writer document trying to adopt as many properties as possible
}; # END OF EXAMPLE-DESCRIPTION
set example($name) {
package require itcluno

catch {itcl::delete object new_document ::textTable2}

package require Tktable

set top .top
catch {destroy $top}
toplevel $top

itcluno::Writer new_document

set rows 10
set cols 7
set tktableWidget [table $top.tktableSpreadSheet -variable data \
	-cols $cols -rows $rows -titlerows 1 -titlecols 1 \
	-font [list Courier 8] -background "lightblue"]
for {set row 0} {$row < 10} {incr row} {
	set line [list]
	for {set col 0} {$col < 8} {incr col} {
		lappend line "Cell $row.$col"
	}
	$tktableWidget set row $row,0 $line
}
$tktableWidget tag configure redline -background red -font [list Arial 20 bold]
$tktableWidget tag rowtag redline 5
$tktableWidget tag configure greencell -background green -font [list Arial 10 bold italic underline]
$tktableWidget tag celltag greencell 2,3
$tktableWidget tag configure leftcol -anchor e
$tktableWidget tag coltag leftcol 1

pack $tktableWidget -expand 1 -fill both

itcluno::Tktable2OOTable::Tktable2TextTable $tktableWidget ::textTable2 new_document

tcluno_soffice::windowTitle [new_document cget -desktop] "TCLUNO - DEMO: Property Copy / Writer"
}; # END OF EXAMPLE-CODE


