set name "Tablelist2OOTable:Simple Copy / SpreadSheet"
set description($name) {
Copies a tablelist to a SpreadSheet without adopting properties
}; # END OF EXAMPLE-DESCRIPTION
set example($name) {
package require itcluno

catch {itcl::delete object new_document}

package require tablelist

set top .top
catch {destroy $top}
toplevel $top

itcluno::SpreadSheet new_document

set sheetNames [new_document getSheetNames]
scan [lindex $sheetNames 0] {%[^0-9]*%d} tableBaseName dummy
set tablelistWidget [tablelist::tablelist $top.tablelistSpreadSheet \
	-columns [list 0 Column1 right 0 Column2 right 0 Column3 right \
		0 Column4 right 0 Column5 right 0 Column6 right 0 Column7 right]]
for {set row 0} {$row < 10} {incr row} {
	set line [list]
	for {set col 0} {$col < 8} {incr col} {
		lappend line "Cell $row.$col"
	}
	$tablelistWidget insert end $line
}
pack $tablelistWidget -expand 1 -fill both
itcluno::Tablelist2OOTable::Tablelist2SpreadSheet $tablelistWidget new_document ${tableBaseName}1 [list 2 4]

tcluno_soffice::windowTitle [new_document cget -desktop] "TCLUNO - DEMO: Simple Copy / SpreadSheet"
}; # END OF EXAMPLE-CODE

set name "Tablelist2OOTable:Property Copy / SpreadSheet"
set description($name) {
Copies a tablelist to a SpreadSheet trying to adopt as many properties as possible
}; # END OF EXAMPLE-DESCRIPTION
set example($name) {
package require itcluno

catch {itcl::delete object new_document}

package require tablelist

set top .top
catch {destroy $top}
toplevel $top

itcluno::SpreadSheet new_document

set sheetNames [new_document getSheetNames]
scan [lindex $sheetNames 0] {%[^0-9]*%d} tableBaseName dummy
set tablelistWidget [tablelist::tablelist $top.tablelistSpreadSheet \
	-columns [list 0 Column1 right 0 Column2 right 0 Column3 right \
		0 Column4 right 0 Column5 right 0 Column6 right 0 Column7 right] \
	-font [list Courier 8] -background "lightblue" -titlecolumns 2]
for {set row 0} {$row < 10} {incr row} {
	set line [list]
	for {set col 0} {$col < 8} {incr col} {
		lappend line "Cell $row.$col"
	}
	$tablelistWidget insert end $line
}
$tablelistWidget rowconfigure 5 -background red -font [list Arial 20 bold]
$tablelistWidget cellconfigure 2,3 -background green -font [list Arial 10 bold italic underline]
$tablelistWidget columnconfigure 1 -align left

pack $tablelistWidget -expand 1 -fill both

itcluno::Tablelist2OOTable::Tablelist2SpreadSheet $tablelistWidget new_document ${tableBaseName}1 C3

tcluno_soffice::windowTitle [new_document cget -desktop] "TCLUNO - DEMO: Property Copy / SpreadSheet"
}; # END OF EXAMPLE-CODE

set name "Tablelist2OOTable:Simple Copy / Writer"
set description($name) {
Copies a tablelist to a Writer document without adopting properties
}; # END OF EXAMPLE-DESCRIPTION
set example($name) {
package require itcluno

catch {itcl::delete object new_document ::textTable1}

package require tablelist

set top .top
catch {destroy $top}
toplevel $top

itcluno::Writer new_document

set tablelistWidget [tablelist::tablelist $top.tablelistWriter \
	-columns [list 0 Column1 right 0 Column2 right 0 Column3 right \
		0 Column4 right 0 Column5 right 0 Column6 right 0 Column7 right]]
for {set row 0} {$row < 10} {incr row} {
	set line [list]
	for {set col 0} {$col < 8} {incr col} {
		lappend line "Cell $row.$col"
	}
	$tablelistWidget insert end $line
}
pack $tablelistWidget -expand 1 -fill both
itcluno::Tablelist2OOTable::Tablelist2TextTable $tablelistWidget ::textTable1 new_document

tcluno_soffice::windowTitle [new_document cget -desktop] "TCLUNO - DEMO: Simple Copy / Writer"
}; # END OF EXAMPLE-CODE

set name "Tablelist2OOTable:Property Copy / Writer"
set description($name) {
Copies a tablelist to a Writer document trying to adopt as many properties as possible
}; # END OF EXAMPLE-DESCRIPTION
set example($name) {
package require itcluno

catch {itcl::delete object new_document ::textTable2}

package require tablelist

set top .top
catch {destroy $top}
toplevel $top

itcluno::Writer new_document

set tablelistWidget [tablelist::tablelist $top.tablelistWriter \
	-columns [list 0 Column1 right 0 Column2 right 0 Column3 right \
		0 Column4 right 0 Column5 right 0 Column6 right 0 Column7 right] \
	-font [list Courier 8] -background "lightblue"]
for {set row 0} {$row < 10} {incr row} {
	set line [list]
	for {set col 0} {$col < 8} {incr col} {
		lappend line "Cell $row.$col"
	}
	$tablelistWidget insert end $line
}
$tablelistWidget rowconfigure 5 -background red -font [list Arial 20 bold]
$tablelistWidget cellconfigure 2,3 -background green -font [list Arial 10 bold italic underline]
$tablelistWidget columnconfigure 1 -align left

pack $tablelistWidget -expand 1 -fill both

itcluno::Tablelist2OOTable::Tablelist2TextTable $tablelistWidget ::textTable2 new_document

tcluno_soffice::windowTitle [new_document cget -desktop] "TCLUNO - DEMO: Property Copy / Writer"
}; # END OF EXAMPLE-CODE


