set name "SpreadSheet:Simply fill cells"
set description($name) {
simply fill cells with text, numbers and currencies
}; # END OF EXAMPLE-DESCRIPTION
set example($name) {
package require itcluno

catch {itcl::delete object new_document}

::itcluno::SpreadSheet new_document
set values [list \
		[list Bundesland Stadt Konzern Kunde AE UMB] \
		[list Bayern München Bahn Hallo -10 234] \
		[list NRW Köln Post Blabla 20 456] \
		[list NRW Köln Post Blabla 50 789] \
		[list NRW Düsseldorf Post "Weiß nicht" 30 123] \
	]

new_document setCellValue Tabelle1 [list 3 5] $values

new_document setCellValue Tabelle1 A1  \
	[list [list "This text simply appears at the upper left corner"]]
new_document setCellValue Tabelle1 A2 [list [list 1.1 2.2 3.3 =SUM(A2:C2)]]
new_document setCellValue Tabelle1 A3 -1.1
new_document setCellFormat Tabelle1 H7:I10 CURRENCY

tcluno_soffice::windowTitle [new_document cget -desktop] "TCLUNO - DEMO: Simply fill cells"
}; # END OF EXAMPLE-CODE

set name "SpreadSheet:Inserting, activate, move and Renaming Sheets"
set description($name) {
Each step within this example is displayed in the SpreadSheet.\nHave a look at it
}; # END OF EXAMPLE-DESCRIPTION
set example($name) {
package require itcluno

set waitTime 3000
set row 0
catch {itcl::delete object new_document}

::itcluno::SpreadSheet new_document
set sheetNames [new_document getSheetNames]
set sheet0 [lindex $sheetNames 0]
scan $sheet0 {%[^0-9]*%d} tableBaseName dummy
update idletasks
after $waitTime
new_document setCellValue $sheet0 [list 0 $row] \
	[list [list "Inserted new Sheet at end"]]
incr row
new_document insertSheet "Position at end"
update idletasks
after $waitTime
new_document setCellValue $sheet0 [list 0 $row] \
	[list [list "Inserted new Sheet at beginning"]]
incr row
new_document insertSheet "First Sheet" 0
update idletasks
after $waitTime
new_document setCellValue $sheet0 [list 0 $row] \
	[list [list "Renamed this sheet to \"Renamed first Sheet\""]]
incr row
new_document renameSheet ${tableBaseName}1 "Renamed first Sheet"
update idletasks
after $waitTime
new_document setCellValue "Renamed first Sheet" [list 0 $row] \
	[list [list "moved Sheet ${tableBaseName}2 to sheet with index 1"]]
incr row
new_document moveSheet ${tableBaseName}2 1
update idletasks
after $waitTime
new_document setCellValue "Position at end" \
	[list 0 0] [list [list "now this sheet is active"]]
new_document activateSheet "Position at end"

tcluno_soffice::windowTitle [new_document cget -desktop] "TCLUNO - DEMO: Inserting, activate, move and Renaming Sheets"
}; # END OF EXAMPLE-CODE

set name "SpreadSheet:Properties"
set description($name) {
Fills the cells A1:B3 and displays their properties below them
}; # END OF EXAMPLE-DESCRIPTION
set example($name) {
package require itcluno

catch {itcl::delete object new_document}

::itcluno::SpreadSheet new_document
set sheetNames [new_document getSheetNames]
set sheet0 [lindex $sheetNames 0]
new_document columnWidth $sheet0 [list 0 1 2 3] 5000
array set properties \
	[itcluno::OfficeUtilities::tkFont2ooFont \
	[list Times 30 bold italic underline]]
array set properties \
	[itcluno::OfficeUtilities::tkColor2ooColor CellBackColor green]
set properties(CharUnderlineColor) 0xff0000
set properties(CharUnderlineHasColor) True
new_document setCellRangeProperties $sheet0 A1:B3 [array get properties]
new_document setCellValue $sheet0 [list 0 0] [list [list A1 B1] [list A2 B2]]

array set properties [new_document getCellRangeProperties $sheet0 A1:B3]
set propList [list]
foreach e [lsort [array names properties]] {
	lappend propList [list $e $properties($e)]
}
new_document setCellValue $sheet0 A4 $propList
new_document setBorder $sheet0 \
	[list 1 3 1 [expr {[llength [array names properties]]+2}]] \
	LeftBorder \
	[list Color 0x0000ff InnerLineWidth 10 OuterLineWidth 20 LineDistance 30]

tcluno_soffice::windowTitle [new_document cget -desktop] "TCLUNO - DEMO: Properties"
}; # END OF EXAMPLE-CODE

set name "SpreadSheet:Pivot tables"
set description($name) {
Fills a cellrange in the first sheet and creates DataPilot-tables (also known as Pivot-tables) in the second and third sheet
}; # END OF EXAMPLE-DESCRIPTION
set example($name) {
package require itcluno

catch {itcl::delete object new_document}

::itcluno::SpreadSheet new_document
set values [list \
		[list Bundesland Stadt Konzern Kunde AE UMB] \
		[list Bayern München Bahn Hallo -10 234] \
		[list NRW Köln Post Blabla 20 456] \
		[list NRW Köln Post Blabla 50 789] \
		[list NRW Düsseldorf Post "Weiß nicht" 30 123] \
	]

set noColumns [expr {[llength [lindex $values 0]]-1}]
set noRows [expr {[llength $values]-1}]
set sourceRange [list 0 0 $noColumns $noRows]
new_document setCellValue Tabelle1 [list 0 0] $values
new_document setCellFormat Tabelle1 $sourceRange CURRENCY
new_document saveFile pivot_table.sxc
set t1 [new_document createPivotTable \
	Tabelle2 A1 \
	Tabelle1 $sourceRange \
	[list Bundesland] \
	[list Konzern Kunde] \
	[list [list AE SUM] [list UMB AVERAGE]]]
new_document activateSheet Tabelle2
new_document createPivotTable \
	Tabelle3 A1 \
	Tabelle1 $sourceRange \
	[list Bundesland Stadt] \
	[list Konzern Kunde] \
	[list [list AE AVERAGE] [list UMB SUM]]

tcluno_soffice::windowTitle [new_document cget -desktop] "TCLUNO - DEMO: Pivot tables"
}; # END OF EXAMPLE-CODE

set name "SpreadSheet:Charts"
set description($name) {
Creates a chart from a cellrange, as barchart and linechart
}; # END OF EXAMPLE-DESCRIPTION
set example($name) {
package require itcluno

catch {itcl::delete object new_document}

::itcluno::SpreadSheet new_document
set values [list \
		[list Month Temperature] \
		[list January -5] \
		[list February -3] \
		[list March 3] \
		[list April 15] \
	]

set sourceRange [list 0 0 [expr {[llength [lindex $values 0]]-1}] [expr {[llength $values]-1}]]
new_document setCellValue Tabelle1 [list 0 0] $values
new_document saveFile chart_table.sxc
new_document createChart Tabelle1 \
	[list 5 5 10 5 cm] \
	[list hasRowHeader 1 hasColumnHeader 1 title "Temperature Chart" type BarDiagram] \
	Tabelle1 $sourceRange
new_document createChart Tabelle1 \
	[list 5 11 10 5 cm] \
	[list hasRowHeader 1 hasColumnHeader 1 title "Temperature Chart" type LineDiagram] \
	Tabelle1 $sourceRange

tcluno_soffice::windowTitle [new_document cget -desktop] "TCLUNO - DEMO: Charts"
}; # END OF EXAMPLE-CODE

set name "SpreadSheet:Converter"
set description($name) {
Fills a cellrange, saves the document as Scalc, MS Excel, .txt (tabstop separated) and .csv (comma separated).\nThe files are named new_document.<suffix>. You are not asked, whether to overwrite them or not.
}; # END OF EXAMPLE-DESCRIPTION
set example($name) {
package require itcluno

catch {itcl::delete object new_document}

::itcluno::SpreadSheet new_document
set values [list \
		[list Bundesland Stadt Konzern Kunde AE UMB] \
		[list Bayern München Bahn Hallo 10 234] \
		[list NRW Köln Post Blabla 20 456] \
		[list NRW Köln Post Blabla 50 789] \
		[list NRW Düsseldorf Post "Weiß nicht" 30 123] \
	]

set sourceRange [list 0 0 [expr {[llength [lindex $values 0]]-1}] [expr {[llength $values]-1}]]
new_document setCellValue Tabelle1 [list 0 0] $values
new_document saveFile new_document.sxc
new_document close
itcl::delete object new_document
::itcluno::SpreadSheet new_document -filename new_document.sxc -hidden 1
new_document saveFile new_document.xls
new_document saveFile new_document.txt
new_document saveFile new_document.csv
new_document close

tcluno_soffice::windowTitle [new_document cget -desktop] "TCLUNO - DEMO: Converter"
}; # END OF EXAMPLE-CODE

set name "SpreadSheet:Borders"
set description($name) {
creates different borders
}; # END OF EXAMPLE-DESCRIPTION
set example($name) {
package require itcluno

catch {itcl::delete object new_document}

::itcluno::SpreadSheet new_document
set values [list \
		[list Month Temperature] \
		[list January -5] \
		[list February -3] \
		[list March 3] \
		[list April 15] \
	]
new_document setCellValue Tabelle1 [list 0 0] $values
new_document setBorder Tabelle1 A2:A5 RightBorder [list OuterLineWidth 100]
set greenColor [itcluno::OfficeUtilities::tkColor2ooColor Color Green]
new_document setBorder Tabelle1 B1:B1 BottomBorder \
	[eval list $greenColor [list OuterLineWidth 100]]
new_document setBorder Tabelle1 A1 TableBorder [list \
	BottomLine [eval list $greenColor [list OuterLineWidth 100]] \
	RightLine [list OuterLineWidth 100] \
	]
new_document setBorder Tabelle1 C7:F10 TableBorder [list \
	AllLines [list InnerLineWidth 50 OuterLineWidth 50 LineDistance 50] \
	ValidLines [list Horizontal Vertical Top Right Bottom Left]]

tcluno_soffice::windowTitle [new_document cget -desktop] "TCLUNO - DEMO: Borders"
}; # END OF EXAMPLE-CODE


