set ::argv -urtp
set home [ file join [pwd] .. ..]
lappend auto_path [ file join $home tclurtp]
lappend auto_path [ file join $home tcluno]
lappend auto_path [ file join $home itcluno]

proc showDescription {w} {
	update idletasks
	set cmd [$w get]
	.text delete 1.0 end
	.text insert end "Short Description of\n\n$cmd\n" description
	set cmdDescr $::description($cmd)
	regsub -all {\\n} $cmdDescr "\n" cmdDescr 
	.text insert end $cmdDescr
}
proc runCommand {w} {
	set cmd [$w get]
	uplevel #0 $::example($cmd)
	puts stderr "example finished"
}
proc saveSource {top textW} {
	set out_filename [tk_getSaveFile -parent $top]
	if {[string length $out_filename] == 0} return
	set out_fd [open $out_filename w]
	puts $out_fd [$textW get 1.0 end]
	flush $out_fd
	close $out_fd
}
proc showCommand {w} {
	update idletasks
	set cmd [$w get]
	set top .source
	catch {destroy $top}
	toplevel $top
	wm title $top "Source of $cmd"
	ScrolledWindow $top.sw
	text $top.text
	$top.text insert end $::example($cmd)
	$top.sw setwidget $top.text
	set bFrame [frame $top.bFrame]
	button $bFrame.save -text Save -command [list saveSource $top $top.text]
	button $bFrame.dismiss -text Dismiss -command [list destroy $top]
	pack $top.sw -side top -expand 1 -fill both
	pack $top.bFrame -side top -fill x
	pack $bFrame.save -side left
	pack $bFrame.dismiss -side right
}
foreach file [list Presentation.tcl SpreadSheet.tcl Tablelist2OOTable.tcl Tktable2OOTable.tcl Writer.tcl] {
	source $file
}

#set auto_path [linsert $auto_path 0 $::env(HOME)/itcluno]

package require itcluno

package require BWidget

label .cbl -text "Select a command:"
ComboBox .cb -values [lsort [array names example]] \
	-modifycmd [list showDescription .cb]
.cb setvalue @0
grid .cbl -row 1 -column 0 -sticky w
grid .cb -row 1 -column 1 -sticky we
grid columnconfigure . 1 -weight 1
ScrolledWindow .sw
text .text -wrap word
set font [.text cget -font]
.text tag configure description -font [eval list $font bold]
grid .sw -row 2 -column 0 -sticky wens -columnspan 2

grid rowconfigure . 2 -weight 1
.sw setwidget .text

button .showcmd -text "Source" \
	-command [list showCommand .cb]
grid .showcmd -row 3 -column 0
button .runcmd -text "Run" \
	-command [list runCommand .cb]
grid .runcmd -row 3 -column 1
showDescription .cb
