set name "Presentation:making a first Presentation"
set description($name) {
This example adds text to the master page. This text can be seen on all pages.\nAlso 2 new pages are created, one with a empty layout, the other one with layout no. 7 (empty layout is not counted, counting starts at 0).\nOn all pages a simple text is written. On the last page being activated at the end you will also see the tk logo.
}; # END OF EXAMPLE-DESCRIPTION
set example($name) {
package require itcluno

catch {itcl::delete object new_document}

itcluno::Presentation new_document

new_document setMasterText [list 0 0 10 1 cm] "A small itcluno Presentation"

new_document setText page1 [list 3 3 20 10 cm] "This is text for page1\non line 2\non line 3"

new_document insertPage
new_document setText page2 [list 3 3 20 10 cm] "This is text for page2\non line 2\non line 3"

#	this means: add a new page with the 9th layout style
#	the empty layout is not count
new_document insertPage end 7
new_document setPreparedText page3 0 "This is the title for page3"
set tkImage $tk_library/images/logoLarge.gif
if {[file exists $tkImage]} {
	new_document setPreparedImage page3 1 [itcluno::OfficeUtilities::filenameToURL $tkImage]
}
new_document setPreparedText page3 1 "This is text for page3\non line 2\non line 3"
new_document activatePage page3

tcluno_soffice::windowTitle [new_document cget -desktop] "TCLUNO - DEMO: making a first Presentation"
}; # END OF EXAMPLE-CODE

set name "Presentation:A Chart within a Presentation"
set description($name) {
This example creates a Chart within a Presentation\nactually the chart is displayed incorrect and does not change when called with -urtp
}; # END OF EXAMPLE-DESCRIPTION
set example($name) {
package require itcluno

catch {itcl::delete object new_document}

itcluno::Presentation new_document

new_document insertPage
set page [lindex [new_document getPageNames] end]
new_document activatePage $page

set values [list \
		[list Month Temperature "No. of Days"] \
		[list January -5 31] \
		[list February -3 28] \
		[list March 3 31] \
		[list April 15 30] \
	]
set colHeaders [lrange [lindex $values 0] 1 end]
set rowHeaders [list]
set dataValues [list]
foreach line [lrange $values 1 end] {
	lappend rowHeaders [lindex $line 0]
	lappend dataValues [lrange $line 1 end]
}

new_document setText $page [list 3 10.5 20 1 cm] "This is a small chart with changing chart types"

set chart [new_document createChart $page [list 3 2 20 8 cm]]
$chart setChart $colHeaders $rowHeaders $dataValues \
	"Temperature diagram" Bar
after 2000

$chart setChartType Line

tcluno_soffice::windowTitle [new_document cget -desktop] "TCLUNO - DEMO: A Chart within a Presentation"
}; # END OF EXAMPLE-CODE

set name "Presentation:A Spreadsheet within a Presentation"
set description($name) {
This example creates a SpreadSheet within a Presentation
}; # END OF EXAMPLE-DESCRIPTION
set example($name) {
package require itcluno

catch {itcl::delete object new_document}

itcluno::Presentation new_document

new_document insertPage
set page [lindex [new_document getPageNames] end]
new_document activatePage $page

set values [list \
		[list Month Temperature "No. of Days"] \
		[list January -5 31] \
		[list February -3 28] \
		[list March 3 31] \
		[list April 15 30] \
	]

set internalSpreadSheet [new_document createTable $page [list 3 12 20 8 cm]]
set sheetNames [$internalSpreadSheet getSheetNames]
set sheet0 [lindex $sheetNames 0]
scan $sheet0 {%[^0-9]*%d} tableBaseName dummy
$internalSpreadSheet setCellValue ${tableBaseName}1 A1 $values
$internalSpreadSheet setSheetProperties ${tableBaseName}1 \
	[itcluno::OfficeUtilities::tkFont2ooFont [list Roman 20 bold italic]]
$internalSpreadSheet columnWidth ${tableBaseName}1 [list 0 1] 4000

tcluno_soffice::windowTitle [new_document cget -desktop] "TCLUNO - DEMO: A Spreadsheet within a Presentation"
}; # END OF EXAMPLE-CODE

set name "Presentation:Inserting and activating Pages"
set description($name) {
It does what the example name says
}; # END OF EXAMPLE-DESCRIPTION
set example($name) {
package require itcluno

catch {itcl::delete object new_document}

itcluno::Presentation new_document

new_document renamePage page1 "First Page"
new_document insertPage
new_document activatePage "First Page"
after 10
set page [lindex [new_document getPageNames] end]
new_document activatePage $page

new_document insertPage
set page [lindex [new_document getPageNames] end]
new_document activatePage $page

set url http://tugm.de/TUGM.gif
if {[catch {new_document setImage $page [list 6000 6000 16760 5760] $url}]} {
	new_document setText $page [list 6 6 18 1 cm] "Could not load image $url from the internet"
} else {
	new_document setText $page [list 6 18 18 1 cm] "Image $url from the internet"
}
new_document setText "First Page" [list 3 3 20 10 cm] "Look at page 3"
new_document saveFile tugm_presentation.sxi
new_document activatePage "First Page"

tcluno_soffice::windowTitle [new_document cget -desktop] "TCLUNO - DEMO: Inserting and activating Pages"
}; # END OF EXAMPLE-CODE


