#*************************************************************************
#*
#*  $RCSfile: Writer.tcl,v $
#*
#*  $Revision: 1.5 $
#*
#*  last change: $Author: grosserw $ $Date: 2005/09/18 10:20:12 $
#*
#*  The Contents of this file are made available subject to the terms of
#*  the following license
#*
#*  - BSD License
#*
#*  see file license.terms in this directory
#*
#*  Copyright 2005 Wolfgang Grosser
#*
#*  Author: Wolfgang Grosser
#*
#*   All Rights Reserved.
#*
#*   Contributor(s): 
#*
#*
#************************************************************************/

package require Itcl

itcl::class itcluno::Writer {
	inherit OpenOffice

	protected variable textHandle ""
	protected variable _bitmapId 0
	protected variable bitmapPrefix _writer

	private variable _backgroundImage ""
	constructor {args} {eval OpenOffice::constructor private:factory/swriter $args} {}
	public method appendText {string {propertyList ""}}
	public method appendParagraph {string {propertyList ""}}
	public method appendTable {rows columns}
	public method appendTextTable {table}
	public method getStyleFamilies {}
	public method getStyles {family}
	public method getStyleProperties {family style {propertyList ""}}
	public method getPropertyValues {object {propertyList ""}}
	public method setNumberingStyles {styleName {idxList 0}}

	public method setDocumentProperties {propertyList}
	public method setStyleProperties {family style propertyList}

	public method exportToPdf {filename}

	protected method getStyleDisplayNames {family}
	protected method checkForFilter {filename filterSequence}
}

itcl::body itcluno::Writer::constructor {args} {
	set bitmapPrefix "_${this}_bitmap_@@@_"
	if {[string length $handle] != 0} {
		set document $handle
	} else {
		if {[string length $filename] == 0} {
			set filename $factory
		}
		if {[catch {checkForFilter $filename $filterSequence} msg]} {
			puts stderr $msg
			#	try opening but without guarantee what happens
			openFile $filename $filterSequence
			return
		}
		openFile $filename $filterSequence
	}
	set textHandle [$document getText]
}
itcl::body itcluno::Writer::appendText {string {propertyList ""}} {
	set textEnd [$textHandle getEnd]
	foreach {name value} $propertyList {
		$textEnd setPropertyValue $name $value
	}
	if {[string length $string] > 0} {
		$textEnd setString $string
	}
	return $textEnd
}
itcl::body itcluno::Writer::appendParagraph {string {propertyList ""}} {
	set textEnd [appendText $string $propertyList]
	set tmp $textEnd
	set textEnd [$textHandle getEnd]
	$textHandle insertControlCharacter $textEnd 0 0
# ARNULF
#	set my_text [$textHandle getText]
#	$my_text insertControlCharacter $textEnd 0 0
# ARNULF END
	return $tmp
}
itcl::body itcluno::Writer::appendTable {rows columns} {
	set tableInstance [$document createInstance com.sun.star.text.TextTable]
	set table [$tableInstance queryInterface [$tableInstance ::tcluno::getTclunoType {TypeClass com.sun.star.text.XTextTable INTERFACE}]]
	$table initialize $rows $columns
	set textEnd [$textHandle getEnd]
	set text [$textEnd getText]
	$text insertTextContent $textEnd $table 0

	return [itcluno::TextTable $this#auto -handle $table]
}
itcl::body itcluno::Writer::appendTextTable {table} {
	set textEnd [$textHandle getEnd]
	set text [$textEnd getText]
	$text insertTextContent $textEnd [$table document] 0
}
itcl::body itcluno::Writer::getStyleFamilies {} {
	set styleFamilies [$document getStyleFamilies]
	return [$styleFamilies getElementNames]
}
itcl::body itcluno::Writer::getStyles {family} {
	set styleFamily [$document getStyleFamilies]
	set family [$styleFamily getByName $family]
	return [$family getElementNames]
}
itcl::body itcluno::Writer::getStyleProperties {family style {propertyList ""}} {
	set styleFamily [$document getStyleFamilies]
	set family [$styleFamily getByName $family]
	if {[string equal $family {TCL_NONE}]} {
		return [list]
	}
	set style [$family getByName $style]
	if {[string equal $style {TCL_NONE}]} {
		return [list]
	}
	return [getPropertyValues $style $propertyList]
}
itcl::body itcluno::Writer::getPropertyValues {object {propertyList ""}} {
	return [::itcluno::OpenOffice::getPropertyValues $object $propertyList]
}
itcl::body itcluno::Writer::setNumberingStyles {styleName {idxList 0}} {
	if {[string length $styleName] > 0} {
		array set tmp [getStyleProperties NumberingStyles $styleName]
		puts stderr NumberingStyles:[array get tmp]:
		set numRules $tmp(NumberingRules)
	} else {
		set numRules [$document createInstance "com.sun.star.text.NumberingRules"]
	}
	set xNum [$numRules queryInterface [$numRules ::tcluno::getTclunoType {TypeClass com.sun.star.container.XIndexAccess INTERFACE}]]
	set xReplacer [$xNum queryInterface [$xNum ::tcluno::getTclunoType {TypeClass com.sun.star.container.XIndexReplace INTERFACE}]]
	puts stderr xNum:$xNum:
	puts stderr xReplacer:$xReplacer:
	foreach idx $idxList {
		set props($idx) [$xNum getByIndex $idx]
		puts stderr actualValues:$props($idx):
		set propList [list]

		foreach e $props($idx) {
			foreach {struct values} $e break
			set tmpVal [list]
			lappend tmpVal [lindex [lindex $values 0] 1]
			lappend tmpVal -1
			set value [lindex [lindex $values 2] 1]
			if {[string equal [lindex $tmpVal 0] {BulletFont}]} {
				set value [itcluno::OfficeUtilities::makeSequence [list [list StarSymbol 14 0 "" 0 10 0 0 0 0 0 0 0 False False 0]] com.sun.star.awt.FontDescriptor]
			}
			lappend tmpVal $value
			lappend tmpVal 0
			if {[string equal [lindex $tmpVal 0] {ParentNumbering}]} {
				set tmpVal [lreplace $tmpVal 2 2 3]
			}
			if {[string equal [lindex $tmpVal 0] {Prefix}]} {
				set tmpVal [lreplace $tmpVal 2 2 {Arnulf: }]
			}
			if {[string equal [lindex $tmpVal 0] {Suffix}]} {
				set tmpVal [lreplace $tmpVal 2 2 {:Wolfgang }]
			}
			lappend propList $tmpVal
		}
		set suffProp [itcluno::OfficeUtilities::makeSequence $propList com.sun.star.beans.PropertyValue]
		$xReplacer replaceByIndex $idx $suffProp
		puts stderr "Style: $styleName: Index: $idx"
		puts stderr newValues:\n[join [$xNum getByIndex $idx] "\n"]
	}
	setStyleProperties NumberingStyles $styleName [list NumberingRules $xReplacer]
}
itcl::body itcluno::Writer::setDocumentProperties {propertyList} {
	setPropertyValues $document $propertyList
}
itcl::body itcluno::Writer::setStyleProperties {family style propertyList} {
	set idx [lsearch -exact $propertyList {BackGraphicURL}]
	incr idx
#	if {$idx >= 0} {
#		set bitmaps [$document createInstance com.sun.star.drawing.BitmapTable]
#		incr idx
#		set _bitmapId [incr _bitmapId]
#		puts stderr "$bitmaps insertByName $bitmapPrefix$_bitmapId [lindex $propertyList $idx]"
#		puts stderr [join [tcluno_soffice::show_method_infos $bitmaps 1] "\n"]
#		puts stderr [$bitmaps hasElements]
#		$bitmaps insertByName $bitmapPrefix$_bitmapId [itcluno::OfficeUtilities::makeSequence [lindex $propertyList $idx]]
#		set newURL [$bitmaps getByName $bitmapPrefix$_bitmapId]
#		set tmpImage [$document createInstance com.sun.star.drawing.GraphicObjectShape]
#		OpenOffice::setPropertyValues $tmpImage [list GraphicURL $newURL]
#		set propertyList [lreplace $propertyList $idx $idx $newURL]
#	}
	set styleFamilies [$document getStyleFamilies]
	set styleFamily [$styleFamilies getByName $family]
	if {[string equal $styleFamily {TCL_NONE}]} {
		return
	}
	set style [$styleFamily getByName $style]
	if {[string equal $style {TCL_NONE}]} {
		return
	}
	setPropertyValues $style $propertyList
}
itcl::body itcluno::Writer::exportToPdf {filename} {
	itcluno::OpenOffice::exportToPdf $filename writer_pdf_Export
}
itcl::body itcluno::Writer::getStyleDisplayNames {family} {
	set styleFamily [$document getStyleFamilies]
	set family [$styleFamily getByName $family]
	set counter [$family getCount]
	set result [list]
	for {set i 0} {$i < $counter} {
		lappend result [[$family getByIndex $i] getPropertyValue LinkDisplayName]
	}
	return $result
}
itcl::body itcluno::Writer::checkForFilter {filename filterSequence} {
	if {[string equal [file extension $filename] {.doc}]} {
		set filterProperty [$desktop tcluno::createUnoStructHelper com.sun.star.beans.PropertyValue {FilterName -1 {MS Word 97} 0}]
		$desktop tcluno::appendUnoSequence $filterSequence $filterProperty
		return
	}
	if {[string equal [file extension $filename] {.txt}]} {
		return
	}
	if {[string equal [file extension $filename] {.rtf}]} {
		set filterProperty [$desktop tcluno::createUnoStructHelper com.sun.star.beans.PropertyValue [list FilterName -1 "Rich Text Format" 0]]
		$desktop tcluno::appendUnoSequence $filterSequence $filterProperty
		return
	}
	if {[string equal [file extension $filename] {.sxw}]} {
		return
	}
	if {[string equal $filename $factory]} {
		return
	}
	return -code error -errorinfo "unsupported extension [file extension $filename]"
}
