#*************************************************************************
#*
#*  $RCSfile$
#*
#*  $Revision$
#*
#*  last change: $Author$ $Date$
#*
#*  The Contents of this file are made available subject to the terms of
#*  the following license
#*
#*  - BSD License
#*
#*  see file license.terms in this directory
#*
#*  Copyright 2005 Wolfgang Grosser
#*
#*  Author: Wolfgang Grosser
#*
#*   All Rights Reserved.
#*
#*   Contributor(s): 
#*
#*
#************************************************************************/

package require Itcl

itcl::class itcluno::Tktable2OOTable {
	proc getValues {tktable cols rows} {
		set values [list]
		for {set row 0} {$row < $rows} {incr row} {
			lappend values [$tktable get $row,0 $row,$cols]
		}
		return $values
	}
	proc getTablePropList {tktable propArray config} {
		upvar $propArray cellProps
		set changedProps [itcluno::OfficeUtilities::getChangedConfig $config]
		set propList [list]
		foreach {prop value} $changedProps {
			if {![info exists cellProps($prop)]} continue
			lappend propList [eval $cellProps($prop) [list $value]]
		}
		return $propList
	}
	proc setTagProperties {tktable propArray document startCol startRow lastCol lastRow method} {
		upvar $propArray cellProps
		set tagList [$tktable tag names]
		set tagCount [llength $tagList]
		incr tagCount -1

		for {} {$tagCount >= 0} {incr tagCount -1} {
			set tag [lindex $tagList $tagCount]
			foreach {type} [list col row cell] {
				set cellRange [$tktable tag ${type}tag $tag]
				if {[llength $cellRange] > 0} {
					set propList [getTablePropList $tktable cellProps [$tktable tag configure $tag]]
					if {[llength $propList] == 0} continue
					set propList [join $propList { }]
					foreach range $cellRange {
						switch $type {
							row {
								set range [list $startCol [expr {$startRow+$range}] [expr {$startCol+$lastCol}] [expr {$startRow+$range}]]
							}
							col {
								set range [list [expr {$startCol+$range}] $startRow [expr {$startCol+$range}] [expr {$startRow+$lastRow}]]
							}
							cell {
								set range [split $range {,}]
								set range [list [expr {$startCol+[lindex $range 1]}] [expr {$startRow+[lindex $range 0]}]]
							}
						}
						eval $document $method [list $range $propList]
					}
				}
			}
		}
	}
	proc Tktable2TextTable {tktable tableObject document {propertyList ""}} {
		set cell_properties [list \
				-background [list itcluno::OfficeUtilities::tkColor2ooColor BackColor] \
				-font itcluno::OfficeUtilities::tkFont2ooFont \
				-foreground [list itcluno::OfficeUtilities::tkColor2ooColor CharColor] \
				-padx [list itcluno::OfficeUtilities::setPadX TextTable] \
				-pady [list itcluno::OfficeUtilities::setPadY TextTable] \
			]
		set rows [$tktable cget -rows]
		set lastRow $rows
		incr lastRow -1
		set columns [$tktable cget -cols]
		set lastCol $columns
		incr lastCol -1
		set values [getValues $tktable $lastCol $rows]
		set textTable [itcluno::TextTable $tableObject -documentobject $document -rows $rows -columns $columns]
		$document appendTextTable $textTable
		$textTable setCellValue [list 0 0] $values
		$textTable setPropertyValues $propertyList

		array set cellProps $cell_properties
		set propList [getTablePropList $tktable cellProps [$tktable configure]]
		set range [list 0 0 $lastCol $lastRow]
		$textTable setRangePropertyValues cell $range [join $propList]

		setTagProperties $tktable cellProps $textTable 0 0 $lastCol $lastRow [list setRangePropertyValues cell]
		return $textTable
	}
	proc Tktable2SpreadSheet {tktable document sheetName startCell {propertyList ""}} {
		foreach {startCol startRow} [itcluno::OfficeUtilities::cellToRowColumn $startCell] break
		set cell_properties [list \
				-background [list itcluno::OfficeUtilities::tkColor2ooColor CellBackColor] \
				-font itcluno::OfficeUtilities::tkFont2ooFont \
				-foreground [list itcluno::OfficeUtilities::tkColor2ooColor CharColor] \
				-padx [list itcluno::OfficeUtilities::setPadX SpreadSheet] \
				-pady [list itcluno::OfficeUtilities::setPadY SpreadSheet] \
				-anchor [list itcluno::OfficeUtilities::setAnchor SpreadSheet] \
			]
		set rows [$tktable cget -rows]
		set lastRow $rows
		incr lastRow -1
		set columns [$tktable cget -cols]
		set lastCol $columns
		incr lastCol -1
		set values [getValues $tktable $lastCol $rows]
		$document setCellValue $sheetName $startCell $values
		$document setSheetProperties $sheetName $propertyList

		array set cellProps $cell_properties
		set propList [getTablePropList $tktable cellProps [$tktable configure]]
		set range [list $startCol $startRow [expr {$startCol+$lastCol}] [expr {$startRow+$lastRow}]]
		array set cellProps [$document getCellRangeProperties $sheetName $range]
		$document setCellRangeProperties $sheetName $range [join $propList]

		setTagProperties $tktable cellProps $document $startCol $startRow $lastCol $lastRow [list setCellRangeProperties $sheetName]

		set colFreeze [$tktable cget -titlecols]
		incr colFreeze $startCol
		set rowFreeze [$tktable cget -titlerows]
		incr rowFreeze $startRow
		$document setFreezePosition $sheetName [list $colFreeze $rowFreeze]

		return $document
	}
}
