#*************************************************************************
#*
#*  $RCSfile$
#*
#*  $Revision$
#*
#*  last change: $Author$ $Date$
#*
#*  The Contents of this file are made available subject to the terms of
#*  the following license
#*
#*  - BSD License
#*
#*  see file license.terms in this directory
#*
#*  Copyright 2005 Wolfgang Grosser
#*
#*  Author: Wolfgang Grosser
#*
#*   All Rights Reserved.
#*
#*   Contributor(s): 
#*
#*
#************************************************************************/

package require Itcl

itcl::class itcluno::TextTable {
	inherit OpenOffice

	public variable rows
	public variable columns
	public variable documentobject

	protected variable table ""
	protected variable tableRows ""
	protected variable tableColumns ""

	private variable _allowedRangeTypes [list row column cell]

	constructor {args} {eval OpenOffice::constructor unused $args} {}

	public method setPropertyValues {propertyList}
	public method getPropertyValues {{propertyList ""}}
	public method setRangePropertyValues {type range propertyList}
	public method getRangePropertyValues {type range {propertyList ""}}

	public method insertRows {insertBefore {insertCount 1}}
	public method removeRows {removeStart {removeCount 1}}
	public method insertColumns {insertBefore {insertCount 1}}
	public method removeColumns {removeStart {removeCount 1}}

	public method setRowDescriptions {header}
	public method setColumnDescriptions {header}

	public method setCellValue {cellIndex valueList}
	public method getCellValue {cellIndex}

	protected method getRangeObject {type range}
}
itcl::body itcluno::TextTable::constructor {args} {
	if {[string length $handle] > 0} {
		set table $handle
		set tableRows [$table getRows]
		set tableColumns [$table getColumns]
	} else {
		set object [$documentobject document]
		set tableInstance [$object createInstance com.sun.star.text.TextTable]
		set table [$tableInstance queryInterface [$tableInstance ::tcluno::getTclunoType {TypeClass com.sun.star.text.XTextTable INTERFACE}]]
		$table initialize $rows $columns
		set document $table
	}
}
itcl::body itcluno::TextTable::setPropertyValues {propertyList} {
	OpenOffice::setPropertyValues $table $propertyList
}
itcl::body itcluno::TextTable::getPropertyValues {{propertyList ""}} {
	return [OpenOffice::getPropertyValues $table $propertyList]
}
itcl::body itcluno::TextTable::setRangePropertyValues {type range propertyList} {
	if {[lsearch -exact $_allowedRangeTypes $type] < 0} {
		return [list]
	}
	set object [getRangeObject $type $range]
	OpenOffice::setPropertyValues $object $propertyList
}
itcl::body itcluno::TextTable::getRangePropertyValues {type range {propertyList ""}} {
	if {[lsearch -exact $_allowedRangeTypes $type] < 0} {
		return [list]
	}
	set object [getRangeObject $type $range]
	return [OpenOffice::getPropertyValues $object $propertyList]
}
itcl::body itcluno::TextTable::insertRows {insertBefore {insertCount 1}} {
	if {[string length $tableRows] == 0} {
		set tableRows [$table getRows]
	}
	$tableRows insertByIndex $insertBefore $insertCount
}
itcl::body itcluno::TextTable::removeRows {removeStart {removeCount 1}} {
	if {[string length $tableRows] == 0} {
		set tableRows [$table getRows]
	}
	$tableRows removeByIndex $removeStart $removeCount
}
itcl::body itcluno::TextTable::insertColumns {insertBefore {insertCount 1}} {
	if {[string length $tableColumns] == 0} {
		set tableColumns [$table getColumns]
	}
	$tableColumns insertByIndex $insertBefore $insertCount
}
itcl::body itcluno::TextTable::removeColumns {removeStart {removeCount 1}} {
	if {[string length $tableColumns] == 0} {
		set tableColumns [$table getColumns]
	}
	$tableColumns removeByIndex $removeStart $removeCount
}
itcl::body itcluno::TextTable::setRowDescriptions {header} {
	$table setRowDescriptions [itcluno::OfficeUtilities::makeSequence $header]
}
itcl::body itcluno::TextTable::setColumnDescriptions {header} {
	$table setColumnDescriptions [itcluno::OfficeUtilities::makeSequence $header]
}
itcl::body itcluno::TextTable::setCellValue {cellIndex valueList} {
	foreach {column row} [itcluno::OfficeUtilities::cellToRowColumn $cellIndex] break
	set startColumn $column
	foreach valueRow $valueList {
		foreach value $valueRow {
			if {[string length $value] == 0} {
				incr column
				continue
			}
			set cellHandle [$table getCellByPosition $column $row]
			set func setString
			if {[string is double $value]} {
				set func setValue
			}
			if {[string first {=} $value] == 0} {
				set value [string range $value 1 end]
				set func setFormula
			}
			$cellHandle $func $value
			incr column
		}
		incr row
		set column $startColumn
	}
}
itcl::body itcluno::TextTable::getCellValue {cellIndex} {
	foreach {column row} [itcluno::OfficeUtilities::cellToRowColumn $cellIndex] break
	set cellHandle [$table getCellByPosition $column $row]
	return [$cellHandle getString]
}
itcl::body itcluno::TextTable::getRangeObject {type range} {
	switch $type {
		row {
			if {[string length $tableRows] == 0} {
				set tableRows [$table getRows]
			}
			set object [$tableRows getByIndex $range]
		}
		column {
			if {[string length $tableColumns] == 0} {
				set tableColumns [$table getColumns]
			}
			set object [$tableColumns getByIndex $range]
		}
		cell {
			set object [eval $table getCellRangeByPosition [itcluno::OfficeUtilities::cellRangeToRowColumnList $range]]
		}
		default {
			set object ""
		}
	}
	return $object
}
