#*************************************************************************
#*
#*  $RCSfile$
#*
#*  $Revision$
#*
#*  last change: $Author$ $Date$
#*
#*  The Contents of this file are made available subject to the terms of
#*  the following license
#*
#*  - BSD License
#*
#*  see file license.terms in this directory
#*
#*  Copyright 2005 Wolfgang Grosser
#*
#*  Author: Wolfgang Grosser
#*
#*   All Rights Reserved.
#*
#*   Contributor(s): 
#*
#*
#************************************************************************/

package require Itcl

itcl::class itcluno::Tablelist2OOTable {
	proc getValues {tablelist} {
		set headers [list]
		foreach {width text align} [$tablelist cget -columns] {
			lappend headers $text
		}
		set values [list]
		lappend values $headers
		foreach line [set [$tablelist itemlistvar]] {
			lappend values [lrange $line 0 end-1]
		}
		return $values
	}
	proc getTableHeaderPropList {tablelist backColorType} {
		set headerPropList [list]
		set foreground [$tablelist cget -labelforeground]
		lappend headerPropList [itcluno::OfficeUtilities::tkColor2ooColor CharColor $foreground]
		set background [$tablelist cget -labelbackground]
		lappend headerPropList [itcluno::OfficeUtilities::tkColor2ooColor $backColorType $background]
		set font [$tablelist cget -labelfont]
		lappend headerPropList [itcluno::OfficeUtilities::tkFont2ooFont $font]
		return $headerPropList
	}
	proc getTablePropList {tablelist propArray config} {
		upvar $propArray cellProps
		set changedProps [itcluno::OfficeUtilities::getChangedConfig $config]
		set propList [list]
		foreach {prop value} $changedProps {
			if {![info exists cellProps($prop)]} continue
			lappend propList [eval $cellProps($prop) [list $value]]
		}
		return $propList
	}
	proc makeCellRange {type row_col startCol startRow cols rows} {
		switch $type {
			row {
				set range [list $startCol [expr {$startRow+$row_col+1}] [expr {$startCol+$cols-1}] [expr {$startRow+$row_col+1}]]
			}
			column {
				set range [list [expr {$startCol+$row_col}] [expr {$startRow+1}] [expr {$startCol+$row_col}] [expr {$startRow+$rows}]]
			}
		}
		return $range
	}
	proc setColRowProperties {tablelist propArray document startCol startRow lastCol lastRow method} {
		upvar $propArray cellProps
		incr lastCol
		foreach {type endRange} [list column $lastCol row $lastRow] {
			for {set i 0} {$i < $endRange} {incr i} {
				set propList [getTablePropList $tablelist cellProps [$tablelist ${type}configure $i]]
				if {[llength $propList] == 0} continue
				set propList [join $propList { }]
				set range [makeCellRange $type $i $startCol $startRow $lastCol $lastRow]
				eval $document $method [list $range $propList]
			}
		}
	}
	proc setCellProperties {tablelist propArray document startCol startRow lastCol lastRow method} {
		upvar $propArray cellProps
		for {set i 0} {$i < $lastCol} {incr i} {
			for {set j 0} {$j < $lastRow} {incr j} {
				set changedProps [itcluno::OfficeUtilities::getChangedConfig [$tablelist cellconfigure $j,$i]]
				set propList [list]
				foreach {prop value} $changedProps {
					if {![info exists cellProps($prop)]} continue
					lappend propList [eval $cellProps($prop) [list $value]]
				}
				if {[llength $propList] == 0} continue
				set propList [join $propList { }]
				eval $document $method [list [list [expr {$startCol+$i}] [expr {$startRow+$j+1}]] $propList]
			}
		}
	}
	proc Tablelist2TextTable {tablelist tableObject document {propertyList ""}} {
		set cell_properties [list \
				-align [list itcluno::OfficeUtilities::setAnchor TextTable] \
				-background [list itcluno::OfficeUtilities::tkColor2ooColor BackColor] \
				-font itcluno::OfficeUtilities::tkFont2ooFont \
				-foreground [list itcluno::OfficeUtilities::tkColor2ooColor CharColor] \
			]
		set rows [$tablelist size]
		incr rows;				# this is the header line
		set lastRow $rows
		incr lastRow -1
		set columns [$tablelist columncount]
		set lastCol $columns
		incr lastCol -1
		set values [getValues $tablelist]
		set textTable [itcluno::TextTable $tableObject -documentobject $document -rows $rows -columns $columns]
		$document appendTextTable $textTable
		$textTable setCellValue [list 0 0] $values
		$textTable setPropertyValues $propertyList

		set headerPropList [getTableHeaderPropList $tablelist BackColor]
		set range [list 0 0 $lastCol 0]
		$textTable setRangePropertyValues cell $range [join $headerPropList]

		array set cellProps $cell_properties
		set propList [getTablePropList $tablelist cellProps [$tablelist configure]]
		set range [list 0 1 $lastCol $lastRow]
		$textTable setRangePropertyValues cell $range [join $propList]

		setColRowProperties $tablelist cellProps $textTable 0 0 $lastCol $lastRow [list setRangePropertyValues cell]
		setCellProperties $tablelist cellProps $textTable 0 0 $lastCol $lastRow [list setRangePropertyValues cell]
		return $textTable
	}
	proc Tablelist2SpreadSheet {tablelist document sheetName startCell {propertyList ""}} {
		foreach {startCol startRow} [itcluno::OfficeUtilities::cellToRowColumn $startCell] break
		set cell_properties [list \
				-align [list itcluno::OfficeUtilities::setAnchor SpreadSheet] \
				-background [list itcluno::OfficeUtilities::tkColor2ooColor CellBackColor] \
				-font itcluno::OfficeUtilities::tkFont2ooFont \
				-foreground [list itcluno::OfficeUtilities::tkColor2ooColor CharColor] \
				-padx [list itcluno::OfficeUtilities::setPadX SpreadSheet] \
				-pady [list itcluno::OfficeUtilities::setPadY SpreadSheet] \
			]
		set rows [$tablelist size]
		incr rows;				# this is the header line
		set lastRow $rows
		incr lastRow -1
		set columns [$tablelist columncount]
		set lastCol $columns
		incr lastCol -1
		set values [getValues $tablelist]
		$document setCellValue $sheetName $startCell $values

		set headerPropList [getTableHeaderPropList $tablelist CellBackColor]
		set range [list $startCol $startRow [expr {$startCol+$lastCol}] $startRow]
		$document setCellRangeProperties $sheetName $range [join $headerPropList]

		array set cellProps $cell_properties
		set propList [getTablePropList $tablelist cellProps [$tablelist configure]]
		set range [list $startCol [expr {$startRow+1}] [expr {$startCol+$lastCol}] [expr {$startRow+$lastRow}]]
		$document setCellRangeProperties $sheetName $range [join $propList]

		setColRowProperties $tablelist cellProps $document $startCol $startRow $lastCol $lastRow [list setCellRangeProperties $sheetName]
		setCellProperties $tablelist cellProps $document $startCol $startRow $lastCol $lastRow [list setCellRangeProperties $sheetName]
		set fixedCols [$tablelist cget -titlecolumns]
		incr fixedCols $startCol
		set fixedRows 1
		incr fixedRows $startRow
		$document setFreezePosition $sheetName [list $fixedCols $fixedRows]
		set col 0
		set optimizedColumns [list]
		foreach {width text align} [$tablelist cget -columns] {
			if {$width == 0} {
				lappend optimizedColumns [expr {$startCol+$col}]
			}
			incr col
		}
		if {[llength $optimizedColumns] > 0} {
			puts stderr "$document columnWidth $sheetName $optimizedColumns Optimal"
			$document columnWidth $sheetName $optimizedColumns optimal
		}
		return $document
	}
}
