#*************************************************************************
#*
#*  $RCSfile: OpenOffice.tcl,v $
#*
#*  $Revision: 1.7 $
#*
#*  last change: $Author: grosserw $ $Date: 2005/09/21 15:10:21 $
#*
#*  The Contents of this file are made available subject to the terms of
#*  the following license
#*
#*  - BSD License
#*
#*  see file license.terms in this directory
#*
#*  Copyright 2005 Wolfgang Grosser
#*
#*  Author: Wolfgang Grosser
#*
#*   All Rights Reserved.
#*
#*   Contributor(s): 
#*
#*
#************************************************************************/

package require tcluno_soffice

itcl::class itcluno::OpenOffice {
	public variable desktop ""
	public variable filename ""
	public variable hidden 0

	public variable handle ""

	protected variable document
	protected variable filterSequence
	protected variable factory ""

	protected variable clsid
	protected variable _officeController ""

	protected constructor {factoryName args} {}

	public method document {}
	public method saveFile {filename}
	protected method getPropertyValues {object {propertyList ""}}
	protected method setPropertyValues {object propertyList}
	public method close {{delegate 0}}
	public method printerOptions {{printerName ""}}
	public method print {printerProperties printProperties}

	protected method openFile {filename filterSequence}
	protected method exportToPdf {filename filter}
	protected method checkForFilter {filename filterSequence}
	protected method makeBorderStruct {borderProperties}
	protected method setTableBorder {cellRangeHandle properties}
}
itcl::body itcluno::OpenOffice::constructor {factoryName args} {
	array set clsid [list table "47BBB4CB-CE4C-4E80-A591-42D9AE74950F" \
			chart "12DCAE26-281F-416F-A234-C3086127382E" \
		]
	set factory $factoryName
	eval configure $args
	if {[string length $desktop] == 0} {
		set desktop [tcluno_soffice::initDesktop]
	}
	set filterSequence [$desktop tcluno::createUnoSequence Any]
	#	TODO: it doesn't work
	if {$hidden} {
		puts stderr isHidden
		set hiddenFilter [$desktop tcluno::createUnoStructHelper com.sun.star.beans.PropertyValue [list Hidden -1 [$desktop tcluno::getTclBoolean True] 0]]
		$desktop tcluno::appendUnoSequence $filterSequence $hiddenFilter
	}
}
itcl::body itcluno::OpenOffice::document {} {
	return $document
}
itcl::body itcluno::OpenOffice::saveFile {filename} {
	set filterSequence [$desktop tcluno::createUnoSequence Any]
	checkForFilter $filename $filterSequence
	set filename [itcluno::OfficeUtilities::filenameToURL $filename $factory]
	$document storeAsURL $filename $filterSequence
}
itcl::body itcluno::OpenOffice::getPropertyValues {object {propertyList ""}} {
	set propSet [$object getPropertySetInfo]
	set propSet [$propSet getProperties]
	set properties [list]
	#	tmpProperty has the follwing form:
	#	com.sun.star.beans.Property {{Name <name>} {Handle <handle>} {Type <type>} {Attributes <attribute>}}
	foreach tmpProperty $propSet {
		set tmpProperty [lindex $tmpProperty 1]
		set tmpProperty [lindex $tmpProperty 0]
		set tmpProperty [lindex $tmpProperty 1]
		if {[llength $propertyList] > 0} {
			if {[lsearch -exact $propertyList [lindex $tmpProperty 0]] < 0} continue
		}
		set propertyValue [$object getPropertyValue $tmpProperty]
		lappend properties $tmpProperty $propertyValue
	}
	return $properties
}
itcl::body itcluno::OpenOffice::setPropertyValues {object propertyList} {
	foreach {property value} $propertyList {
		$object setPropertyValue $property $value
	}
}
itcl::body itcluno::OpenOffice::close {{delegate 0}} {
	$document close $delegate
}
itcl::body itcluno::OpenOffice::printerOptions {{printerName ""}} {
	set printable [$document queryInterface [$document ::tcluno::getTclunoType {TypeClass com.sun.star.view.XPrintable INTERFACE}]]
	if {[string length $printerName] > 0} {
		set sequence [itcluno::OfficeUtilities::makeSequence [list [list Name -1 $printerName 0]] com.sun.star.beans.PropertyValue]
		$printable setPrinter $sequence
	}
	set tmp [list]
	set properties [$printable getPrinter]
	foreach e $properties {
		foreach {struct property} $e break
		lappend tmp [lindex [lindex $property 0] 1] [lindex [lindex $property 2] 1]
	}
	return $tmp
}
itcl::body itcluno::OpenOffice::print {printerProperties printProperties} {
	set printable [$document queryInterface [$document ::tcluno::getTclunoType {TypeClass com.sun.star.view.XPrintable INTERFACE}]]
	set properties [list]
	foreach {name value} $printerProperties {
		if {[string equal $name {Size}] || [string equal $name {PaperSize}]} {
			set value [::tcluno_soffice::createSize $value]
		}
		lappend properties [list $name -1 $value 0]
	}
	set sequence [itcluno::OfficeUtilities::makeSequence $properties com.sun.star.beans.PropertyValue]
	$printable setPrinter $sequence
	set properties [list]
	foreach {name value} $printProperties {
		if {[string equal $name {Pages}]} {
			if {[string is integer $value]} {
				set value "$value-$value"
			}
		}
		if {[string equal $name {FileName}]} {
			if {[string equal [file pathtype $value] {relative}]} {
				set value [file join [pwd] $value]
			}
		}
		lappend properties [list $name -1 $value 0]
	}
	set sequence [itcluno::OfficeUtilities::makeSequence $properties com.sun.star.beans.PropertyValue]
	$printable print $sequence
}
itcl::body itcluno::OpenOffice::openFile {filename filterSequence} {
	set filename [itcluno::OfficeUtilities::filenameToURL $filename $factory]
	set document [$desktop loadComponentFromURL $filename "_blank" 8 $filterSequence]
}
itcl::body itcluno::OpenOffice::checkForFilter {filename filterSequence} {
}
itcl::body itcluno::OpenOffice::exportToPdf {filename filter} {
	set sequence [$::tcluno_soffice::desktop tcluno::createUnoSequence Any]
	set filter [$desktop tcluno::createUnoStructHelper com.sun.star.beans.PropertyValue [list FilterName -1 $filter 0]]
	$desktop tcluno::appendUnoSequence $sequence $filter
	$document storeToURL [itcluno::OfficeUtilities::filenameToURL $filename ""] $sequence
}
itcl::body itcluno::OpenOffice::makeBorderStruct {borderProperties} {
	array set tmp $borderProperties
	foreach name [list Color InnerLineWidth OuterLineWidth LineDistance] {
		if {![info exists tmp($name)]} {
			set tmp($name) 0
		}
		lappend borderList $tmp($name)
	}
	return [$desktop tcluno::createUnoStructHelper com.sun.star.table.BorderLine $borderList]
}
itcl::body itcluno::OpenOffice::setTableBorder {cellRangeHandle borderProperties} {
	array set tmp $borderProperties
	if {[info exists tmp(AllLines)]} {
		foreach e $tmp(ValidLines) {
			set tmp(${e}Line) $tmp(AllLines)
			set tmp(Is${e}LineValid) True
		}
	}
	foreach e [list Top Bottom Left Right Horizontal Vertical] {
		if {![info exists tmp(${e}Line)]} {
			lappend borderPropertyList [$desktop tcluno::createUnoStructHelper com.sun.star.table.BorderLine [list 0 0 0 0]]
		} else {
			lappend borderPropertyList [makeBorderStruct $tmp(${e}Line)]
		}
		if {![info exists tmp(Is${e}LineValid)]} {
			lappend borderPropertyList True
		} else {
			lappend borderPropertyList $tmp(Is${e}LineValid)
		}
	}
	if {![info exists tmp(Distance)]} {
		set tmp(Distance) 0
	}
	lappend borderPropertyList $tmp(Distance)
	if {![info exists tmp(IsDistanceValid)]} {
		set tmp(IsDistanceValid) True
	}
	lappend borderPropertyList $tmp(IsDistanceValid)
	set borderPropertyStruct [$desktop tcluno::createUnoStructHelper com.sun.star.table.TableBorder $borderPropertyList]
	setPropertyValues $cellRangeHandle [list TableBorder $borderPropertyStruct]
}
