#*************************************************************************
#*
#*  $RCSfile: OfficeUtilities.tcl,v $
#*
#*  $Revision: 1.5 $
#*
#*  last change: $Author: grosserw $ $Date: 2005/09/18 10:18:11 $
#*
#*  The Contents of this file are made available subject to the terms of
#*  the following license
#*
#*  - BSD License
#*
#*  see file license.terms in this directory
#*
#*  Copyright 2005 Wolfgang Grosser
#*
#*  Author: Wolfgang Grosser
#*
#*   All Rights Reserved.
#*
#*   Contributor(s): 
#*
#*
#************************************************************************/

package require Itcl
package require tcluno_type_info

namespace eval itcluno::OfficeUtilities {
	proc makeSequence {valueList {structure ""}} {
		set sequence [$tcluno_soffice::desktop tcluno::createUnoSequence $structure]
		foreach value $valueList {
			if {[string length $structure] > 0} {
				set value [$tcluno_soffice::desktop tcluno::createUnoStructHelper $structure $value]
			}
			$tcluno_soffice::desktop tcluno::appendUnoSequence $sequence $value
		}
		return $sequence
	}

	proc charToCol {c} {
		set c [string toupper $c]
		if {[string length $c] == 1} {
			scan $c {%c} col
			return [expr {$col-64}]
		}
		return [expr {[charToCol [string index $c 0]]*26+[charToCol [string index $c 1]]}]
	}
	proc cellToRowColumn {cell} {
		if {[llength $cell] == 2} {
			return $cell
		}
		if {[scan $cell {%[^0-9]%d} aCol row] == 0} {
			return $cell
		}
		incr row -1
		set col [charToCol $aCol]
		incr col -1
		return [list $col $row]
	}
	proc cellRangeToRowColumnList {cellrange} {
		if {[llength $cellrange] == 4} {
			return $cellrange
		}
		if {[scan $cellrange {%[^:]:%[^:]} start end] == 0} {
			return $cellrange
		}
		set cellrange [list]
		eval lappend cellrange [cellToRowColumn $start]
		if {![info exists end]} {
			set end $start
		}
		eval lappend cellrange [cellToRowColumn $end]
		return $cellrange
	}

	proc constant {class value} {
		set value [tcluno_type_info::getConstantsClassValue $class $value]
		return $value
	}
	proc enum {class value} {
		set value [tcluno_type_info::getEnumClassValue $class $value]
		return $value
	}
	proc getUnitFactor {unit} {
		set factor 1
		switch $unit {
			cm {
				set factor 1000
			}
			mm {
				set factor 100
			}
			i -
			in -
			inch {
				set factor 2540
			}
		}
		return $factor
	}

	proc filenameToURL {filename {factory ""}} {
		if {[string equal $filename $factory]} {
			return $filename
		}
		if {[string equal [file pathtype $filename] {relative}]} {
			set filename [file join [pwd] $filename]
		}
		if {[string first {file:} $filename] != 0} {
			set filename file://$filename
		}
		return $filename
	}
	proc tkFont2ooFont {font} {
		set result [list]
		lappend result CharFontName [lindex $font 0]
		set height [lindex $font 1]
		if {[string length $height] > 0} {
			lappend result CharHeight [expr {abs($height)}]
		} else {
			return $result
		}
		array set fontStyles [list \
			normal [list CharWeight 100] \
			bold [list CharWeight 150] \
			roman [list] \
			italic [list CharPosture [enum com.sun.star.awt.FontSlant ITALIC]] \
			underline [list CharUnderline [constant com.sun.star.awt.FontUnderline SINGLE]] \
			strikeout [list CharStrikeout [constant com.sun.star.awt.FontStrikeout SINGLE]] \
		]

		foreach e [lrange $font 2 end] {
			eval lappend result $fontStyles([string tolower $e])
		}
		return $result
	}
	proc tkColor2ooColor {type color {w "."}} {
		if {[string first {#} $color] == 0} {
			return "$type 0x[string range $color 1 end]"
		}
		set result "$type 0x"
		foreach color [winfo rgb $w $color] {
			if {$color > 255} {
				set color [expr {$color/256}]
			}
			append result [format {%02x} $color]
		}
		return $result
	}
	proc setTextTableAnchor {anchor} {
		set result [list]
		foreach c [split $anchor ""] {
			switch $c {
				n {
					lappend result ParaVertAlignment [constant com.sun.star.text.ParagraphVertAlign TOP]
				}
				s {
					lappend result ParaVertAlignment [constant com.sun.star.text.ParagraphVertAlign BOTTOM]
				}
				w {
					lappend result ParaAdjust [enum com.sun.star.style.ParagraphAdjust LEFT]
				}
				e {
					lappend result ParaAdjust [enum com.sun.star.style.ParagraphAdjust RIGHT]
				}
			}
		}
		return $result
	}
	proc setSpreadSheetAnchor {anchor} {
		set result [list]
		foreach c [split $anchor ""] {
			switch $c {
				n {
					lappend result VertJustify [enum com.sun.star.table.CellVertJustify TOP]
				}
				s {
					lappend result VertJustify [enum com.sun.star.table.CellVertJustify BOTTOM]
				}
				w {
					lappend result HoriJustify [enum com.sun.star.table.CellHoriJustify LEFT]
				}
				e {
					lappend result HoriJustify [enum com.sun.star.table.CellHoriJustify RIGHT]
				}
			}
		}
		return $result
	}
	proc setAnchor {tabletype anchor} {
		switch $anchor {
			left {
				set anchor w
			}
			right {
				set anchor e
			}
		}
		switch $tabletype {
			TextTable {
				return [setTextTableAnchor $anchor]
			}
			SpreadSheet {
				return [setSpreadSheetAnchor $anchor]
			}
		}
	}
	proc setPadX {tabletype padding {unit 100}} {
		if {[llength $padding] == 1} {
			set leftPad $padding
			set leftPad [expr {$leftPad*$unit}]
			set rightPad $leftPad
		} else {
			foreach {leftPad rightPad} $padding break
			set leftPad [expr {$leftPad*$unit}]
			set rightPad [expr {$rightPad*$unit}]
		}
		switch $tabletype {
			TextTable {
				return [list LeftBorderDistance $leftPad RightBorderDistance $rightPad]
			}
			SpreadSheet {
				return [list ParaLeftMargin $leftPad ParaRightMargin $rightPad]
			}
		}
	}
	proc setPadY {tabletype padding {unit 100}} {
		if {[llength $padding] == 1} {
			set topPad $padding
			set topPad [expr {$topPad*$unit}]
			set bottomPad $topPad
		} else {
			foreach {topPad bottomPad} $padding break
			set topPad [expr {$topPad*$unit}]
			set bottomPad [expr {$bottomPad*$unit}]
		}
		switch $tabletype {
			TextTable {
				return [list TopBorderDistance $topPad BottomBorderDistance $bottomPad]
			}
			SpreadSheet {
				return [list ParaTopMargin $topPad ParaBottomMargin $bottomPad]
			}
		}
	}
	proc getChangedConfig {configList} {
		set result [list]
		foreach e $configList {
			if {[llength $e] == 2} continue
			if {[string equal [lindex $e 3] [lindex $e 4]]} continue
			if {[string first {unknown} [lindex $e 4]] == 0} continue
			if {[string length [lindex $e 4]] == 0} continue
			lappend result [lindex $e 0] [lindex $e 4]
		}
		return $result
	}
}
