#*************************************************************************
#*
#*  $RCSfile: ChartDocument.tcl,v $
#*
#*  $Revision: 1.4 $
#*
#*  last change: $Author: grosserw $ $Date: 2005/09/12 06:28:34 $
#*
#*  The Contents of this file are made available subject to the terms of
#*  the following license
#*
#*  - BSD License
#*
#*  see file license.terms in this directory
#*
#*  Copyright 2005 Wolfgang Grosser
#*
#*  Author: Wolfgang Grosser
#*
#*   All Rights Reserved.
#*
#*   Contributor(s): 
#*
#*
#************************************************************************/

itcl::class itcluno::ChartDocument {
	inherit OpenOffice

	protected variable document ""
	protected variable data ""

	private variable multiServiceFactory ""

	constructor {args} {eval OpenOffice::constructor unused $args} {}

	public method setChartType {type}
	public method setData {dataList}
	public method setColumnDescriptions {headerList}
	public method setRowDescriptions {headerList}
	public method setTitle {title}
	public method setChart {columnHeaders rowHeaders data title type}
}
itcl::body itcluno::ChartDocument::constructor {args} {
	set document $handle
	puts stderr "ARNULF TODO"
	puts stderr "before multiServiceFactory"
	set multiServiceFactory [$document queryInterface [$document ::tcluno::getTclunoType {TypeClass com.sun.star.lang.XMultiServiceFactory INTERFACE}]]
	puts stderr "after multiServiceFactory"
	set data [$document getData]
}
itcl::body itcluno::ChartDocument::setChartType {type} {
	set diagram [$multiServiceFactory createInstance "com.sun.star.chart.${type}Diagram"]
	$document setDiagram $diagram
}
itcl::body itcluno::ChartDocument::setData {dataList} {
	set rowSequence [list]
	set row 0
	foreach dataRow $dataList {
		lappend rowSequence [itcluno::OfficeUtilities::makeSequence $dataRow]
	}
	$data setData [itcluno::OfficeUtilities::makeSequence $rowSequence]
}
itcl::body itcluno::ChartDocument::setColumnDescriptions {headerList} {
	$data setColumnDescriptions [itcluno::OfficeUtilities::makeSequence $headerList]
}
itcl::body itcluno::ChartDocument::setRowDescriptions {headerList} {
	$data setRowDescriptions [itcluno::OfficeUtilities::makeSequence $headerList]
}
itcl::body itcluno::ChartDocument::setTitle {title} {
	set titleHandle [$document getTitle]
	setPropertyValues $titleHandle [list String $title]
}
itcl::body itcluno::ChartDocument::setChart {columnHeaders rowHeaders data title type} {
	if {[llength $columnHeaders] != [llength [lindex $data 0]]} {
		return -code error "column headers don't fit for data"
	}
	if {[llength $rowHeaders] != [llength $data]} {
		return -code error "row headers don't fit for data"
	}
	setChartType $type
	setData $data
	setColumnDescriptions $columnHeaders
	setRowDescriptions $rowHeaders
	setTitle $title
}
