/*
    dat2src.c - XY-ASCII in C-Quelltext wandeln
*/

# include <stdio.h>
# include <string.h>
# include <math.h>

int main(int argc, char *argv[])
 {
  unsigned samples;
  double value, value2, freq, t, t2;
  static char buffer[80];
  FILE *in_stream, *out_stream;

  if (argc != 3)
   {
    fprintf(stderr, "dat2src - convert XY-data to C source-file.\n"
            "Usage: dat2src data-file output-name\n");
    return(1);
   }

  if ((in_stream = fopen(argv[1], "r")) == NULL)
   {
    perror("dat2src: Can't open input file");
    return(1);
   }

  strncpy(buffer, argv[2], 77);
  strcat(buffer, ".c");
  if ((out_stream = fopen(buffer, "w")) == NULL)
   {
    perror("dat2src: Can't open output file");
    return(1);
   }

	/*- - - - - - - - - - - - - - - - - - - - - - - - -*/

  if (fgets(buffer, 80, in_stream) == NULL)		/* 1. Zeile lesen */
   {
    fprintf(stderr, "dat2src: Bad input file.\n");
    return(1);
   }
  if (sscanf(buffer, "%lf %lf", &t, &value) < 2)
   {
    fprintf(stderr, "dat2src: Bad input file.\n");
    return(1);
   }

  if (fgets(buffer, 80, in_stream) == NULL)		/* 2. Zeile lesen */
   {
    fprintf(stderr, "dat2src: Bad input file.\n");
    return(1);
   }
  if(sscanf(buffer, "%lf %lf", &t2, &value2) < 2)
   {
    fprintf(stderr, "dat2src: Bad input file.\n");
    return(1);
   }
  if (t2 <= t)
   {
    fprintf(stderr, "dat2src: Bad input file. (Bad timesteps)\n");
    return(1);
   }

  freq = rint(0.04/(t2-t))*25;	/* Frequenz auf 25Hz runden */
  samples = 2;

	/*- - - - - - - - - - - - - - - - - - - - - - - - -*/

  fprintf(out_stream, "/*\n    %s.c - Chirp-Signal-Definition\n"
         "    DO NOT EDIT! This file is generated by 'dat2src'.\n*/\n\n"
	 "const double %s[] = {\n", argv[2], argv[2]);
  fprintf(out_stream, "  %.6f,\n  %.6f", value, value2);

  while ((fgets(buffer, 80, in_stream) != NULL)
         && (sscanf(buffer, "%lf %lf", &t, &value) == 2))
   {
    fprintf(out_stream, ",\n  %.6f", value);
    samples++;
   }

  fprintf(out_stream, "\n };\n");
  fclose(out_stream);
  fclose(in_stream);

  strncpy(buffer, argv[2], 77);
  strcat(buffer, ".h");
  if ((out_stream = fopen(buffer, "w")) == NULL)
   {
    perror("dat2src: Can't open output file");
    return(1);
   }

  fprintf(out_stream, "/*\n    %s.h - Chirp-Signal-Declaration\n"
         "    DO NOT EDIT! This file is generated by 'dat2src'.\n*/\n\n", argv[2]);
  fprintf(out_stream, "# define CHIRP_LENGTH %d\n", samples);
  fprintf(out_stream, "# define SAMPLE_FREQ %.0f\n\n", freq);
  fprintf(out_stream, "extern const double %s[CHIRP_LENGTH];\n", argv[2]);

  fclose(out_stream);

  return(0);
 }
