/*
    audio.h - Funktionen zur Ansteuerung der Soundkarte

    linker Kanal: Chirp-Signal
    rechter Kanal: Sync-Signal
*/

# define SYNC_LEVEL_OUT 86
# define SYNC_LEVEL_IN 60
# define CHIRP_LEVEL_OUT1 24
# define CHIRP_LEVEL_OUT2 48
# define CHIRP_LEVEL_OUT3 86
# define CHIRP_LEVEL_IN1 18
# define CHIRP_LEVEL_IN2 60
# define CHIRP_LEVEL_IN3 86

int audio_open(int *snd_in, int *snd_out, int *mixer);
void audio_close(int *snd_in, int *snd_out, int *mixer);
int audio_init(int snd_in, int snd_out, int mixer);
int set_out_volume(int mixer, int left, int right);
int set_in_volume(int mixer, int left, int right);
void create_testsequence(void);
void create_sine(double freq);
void play_testsequence(int snd_out);
int record_sequence(int snd_in, double buffer[], int buf_size);
int acquire(int snd_in, int snd_out, double buffer[], int buf_size);
void write_record_data(FILE *stream);
