#include "framework.h"
#include "lena.h"

#include <stdio.h>
#include <stdlib.h>
#include <math.h>

GLuint texture[2];
GLuint program;
GLuint vertexShader;
GLuint fragmentShader;
GLint textureParameter;
GLint textureParameter2;
GLint beginParameter;
GLint endParameter;

float val1, val2;

float lpos[4] = {1,0.5,1,0};
int shaderActive;

inline float min(float a, float b) {
	return a > b ? b : a;
}

inline float max(float a, float b) {
	return a > b ? a : b;
}

void renderScene(void) {
	glClear(GL_COLOR_BUFFER_BIT | GL_DEPTH_BUFFER_BIT);

	glLoadIdentity();
	gluLookAt(0.0,0.0,3.0,
			  0.0,0.0,-1.0,
			  0.0f,1.0f,0.0f);
	if (shaderActive) {
		glUniform1f(beginParameter, min(val1, val2));
		glUniform1f(endParameter, max(val1, val2));
	}

	glBegin(GL_QUADS);
		glMultiTexCoord2f(GL_TEXTURE1, 0.0f,1.0f);
		glVertex3f(-1.0f, -1.0f, 0.0f);

		glMultiTexCoord2f(GL_TEXTURE1, 0.0f,0.0f);
		glVertex3f(-1.0f,  1.0f, 0.0f);

		glMultiTexCoord2f(GL_TEXTURE1, 1.0f,0.0f);
		glVertex3f( 1.0f,  1.0f, 0.0f);

		glMultiTexCoord2f(GL_TEXTURE1, 1.0f,1.0f);
		glVertex3f( 1.0f, -1.0f, 0.0f);
	glEnd();

	glutSwapBuffers();
}

void setShaders() {
	char *vs,*fs;
	shaderActive = TRUE;

	program = glCreateProgram();
	vertexShader = glCreateShader(GL_VERTEX_SHADER);
	fragmentShader = glCreateShader(GL_FRAGMENT_SHADER);

	vs = loadTextFile("shaders/texture.vert");
	fs = loadTextFile("shaders/texture.frag");

	const char* vv = vs;
	const char* ff = fs;

	glShaderSource(vertexShader, 1, &vv,NULL);
	checkError(vertexShader);
	free(vs);

	glShaderSource(fragmentShader, 1, &ff,NULL);
	checkError(fragmentShader);
	free(fs);

	glCompileShader(vertexShader);
	checkError(vertexShader);

	glCompileShader(fragmentShader);
	checkError(fragmentShader);

	glAttachShader(program,vertexShader);
	glAttachShader(program,fragmentShader);

	glLinkProgram(program);
	glUseProgram(program);

	textureParameter = glGetUniformLocation(program, "texture2");
	beginParameter = glGetUniformLocation(program, "begin");
	endParameter = glGetUniformLocation(program, "end");
	glUniform1i(textureParameter, 1);
}

void setupTexture() {
	int texSize = width * height * 4;
	char* textureBuffer = (char*)malloc(texSize);
	char* data = header_data;
	
	fprintf(stderr, "Enter loop\n");
	for (int i = 0; i < texSize; i+=4) {
		HEADER_PIXEL(data,((char*)&textureBuffer[i]));
	}
	fprintf(stderr, "Exit loop\n");
	glActiveTexture(GL_TEXTURE1);
	glGenTextures(2, &texture[0]);
	glBindTexture(GL_TEXTURE_2D, texture[0]);
	glTexImage2D(GL_TEXTURE_2D, 0,4, width, height, 0, GL_RGBA, GL_UNSIGNED_BYTE, textureBuffer);

	glTexParameteri(GL_TEXTURE_2D, GL_TEXTURE_MIN_FILTER, GL_LINEAR);
	glTexParameteri(GL_TEXTURE_2D, GL_TEXTURE_MAG_FILTER, GL_LINEAR);
	data = header_data;
	for (int i = 0; i < texSize; i+=4) {
		HEADER_PIXEL(data,((char*)&textureBuffer[i]));
	}


	glBindTexture(GL_TEXTURE_2D, texture[1]);
	glTexImage2D(GL_TEXTURE_2D, 0,4, width, height, 0, GL_RGBA, GL_UNSIGNED_BYTE, textureBuffer);

	glTexParameteri(GL_TEXTURE_2D, GL_TEXTURE_MIN_FILTER, GL_LINEAR);
	glTexParameteri(GL_TEXTURE_2D, GL_TEXTURE_MAG_FILTER, GL_LINEAR);

	free(textureBuffer);
	glEnable(GL_TEXTURE_2D);
}

void keyPressed(unsigned char key, int x, int y) {
	if (key == ' ') {
		if (shaderActive) {
			fprintf(stderr, "Deactivate shader\n");
			glUseProgram(0);
			shaderActive = FALSE;
		} else {
			fprintf(stderr, "Activate shader\n");
			glUseProgram(program);
			shaderActive = TRUE;
		}
	}
}

void mousePress(int button, int state, int x, int y) {
	if (!state)
		val1 = x / (float)windowWidth;
}

void mouseMoved(int x, int y) {
	val2 = x / (float)windowWidth;
}

int main(int argc, char **argv) {
	fprintf(stderr, "init glut\n");
	glutInit(&argc,argv);
	glutInitDisplayMode( GLUT_RGB | GLUT_DEPTH | GLUT_DOUBLE);
	glutInitWindowSize(500, 500);
	window = glutCreateWindow( "Helligkeitsbereich");
	fprintf(stderr, "init window\n");
	glutDisplayFunc(renderScene);
	glutIdleFunc(renderScene);
	glutReshapeFunc(changeSize);
	glutKeyboardFunc(keyPressed);
	glutMouseFunc(mousePress);
	glutMotionFunc(mouseMoved);
	fprintf(stderr, "init events\n");
	glEnable(GL_DEPTH_TEST);
	glClearColor(0.0,0.0,0.0,1.0);
	setupTexture();
	setShaders(); // initialize the shader
	val1 = 0.0f;
	val2 = 1.0f;
	glutMainLoop();
}
