#include "framework.h"

#include <stdio.h>
#include <stdlib.h>

GLuint program;
GLuint vertexShader;
GLuint fragmentShader;

float time;
float lpos[4] = {1,0.5,1,0};
int shaderActive;


void renderScene(void) {
	glClear(GL_COLOR_BUFFER_BIT | GL_DEPTH_BUFFER_BIT);

	glLoadIdentity();
	gluLookAt(0.0,0.0,5.0,
			  0.0,0.0,-1.0,
			  0.0f,1.0f,0.0f);

	glColor3f(0.0f,1.0f,0.0f);

	glRotatef(time,0,1,1);
	glutSolidTeapot(1);
	time+=0.1;

	glutSwapBuffers();
}

void setShaders() {
	char *vs,*fs;
	shaderActive = TRUE;

	program = glCreateProgram();
	vertexShader = glCreateShader(GL_VERTEX_SHADER);
	fragmentShader = glCreateShader(GL_FRAGMENT_SHADER);

	vs = loadTextFile("shaders/nothing.vert");
	fs = loadTextFile("shaders/red.frag");

	const char* vv = vs;
	const char* ff = fs;

	glShaderSource(vertexShader, 1, &vv,NULL);
	checkError(vertexShader);
	free(vs);

	glShaderSource(fragmentShader, 1, &ff,NULL);
	checkError(fragmentShader);
	free(fs);

	glCompileShader(vertexShader);
	checkError(vertexShader);

	glCompileShader(fragmentShader);
	checkError(fragmentShader);

	glAttachShader(program,vertexShader);
	glAttachShader(program,fragmentShader);

	glLinkProgram(program);

	checkError(program);
	glUseProgram(program);
}

void keyPressed(unsigned char key, int x, int y) {
	if (key == ' ') {
		if (shaderActive) {
			fprintf(stderr, "Deactivate shader\n");
			glUseProgram(0);
			shaderActive = FALSE;
		} else {
			fprintf(stderr, "Activate shader\n");
			glUseProgram(program);
			shaderActive = TRUE;
		}
	}
}

int main(int argc, char **argv) {
	glutInit(&argc,argv);
	glutInitDisplayMode( GLUT_RGB | GLUT_DEPTH | GLUT_DOUBLE);
	glutInitWindowSize(500, 500);
	window = glutCreateWindow( "Simple Vertexshader");

	glutDisplayFunc(renderScene);
	glutIdleFunc(renderScene);
	glutReshapeFunc(changeSize);
	glutKeyboardFunc(keyPressed);

	glEnable(GL_DEPTH_TEST);
	glClearColor(0.0,0.0,0.0,1.0);
	setShaders();// initialize the shader
	time = 0;
	
	glutMainLoop();
}
