#ifndef SHADERFRAMEWORK_H
#define SHADERFRAMEWORK_H

#define GL_GLEXT_PROTOTYPES 1

#ifdef APPLE

#include <OpenGL/gl.h>
#include <GLUT/glut.h>

#else

#include <GL/gl.h>
#include <GL/glut.h>
#include <malloc.h>

#endif

/**
 * Framework fuer verschiedene Beispiele, die Shader benutzen, die
 * in der OpenGL Shading Language verfasst sind.
 * Axel Jaeger <axeljaeger@qtforum.org>
 */

extern GLuint window;
extern GLuint windowWidth;
extern GLuint windowHeight;

void changeSize(int w, int h);
char* loadTextFile(const char* filename);
void checkError(GLuint handle);

#define TRUE 1
#define FALSE 0

#endif
