#include "framework.h"

#include <stdio.h>
#include <stdlib.h>
#include <fcntl.h>
#include <string.h>
#include <unistd.h>

GLuint window;
GLuint windowWidth;
GLuint windowHeight;

void changeSize(int w, int h) {
	// Division durch 0 verhindern
	if(h == 0)
		h = 1;

	float ratio = 1.0* w / h;

	glMatrixMode(GL_PROJECTION);
	glLoadIdentity();

	glViewport(0, 0, w, h);

	gluPerspective(45,ratio,1,1000);
	glMatrixMode(GL_MODELVIEW);

	windowWidth = w;
	windowHeight = h;
}

char *loadTextFile(const char *fn) {


	FILE *fp;
	char *content = NULL;

	int f,count;
	f = open(fn, O_RDONLY);

	count = lseek(f, 0, SEEK_END);

	close(f);

	if (fn != NULL) {
		fp = fopen(fn,"rt");

		if (fp != NULL) {


			if (count > 0) {
				content = (char *)malloc(sizeof(char) * (count+1));
				count = fread(content,sizeof(char),count,fp);
				content[count] = '\0';
			}
			fclose(fp);
		}
	}
	return content;
}

void checkError(GLuint handle) {
	GLsizei infologLength = 0;
	GLsizei charsWritten  = 0;
	char *infoLog;

	glGetShaderiv(handle, GL_INFO_LOG_LENGTH,
							  &infologLength);

	if (infologLength > 1)
	{
		infoLog = (char*)malloc(infologLength);
		glGetShaderInfoLog(handle, infologLength, &charsWritten, infoLog);
		fprintf(stderr, "Error: %s", infoLog);
		free(infoLog);
	}
}
