uniform float time;

#define PI2div3 2.094395

vec4 colorVec(float t) {
	return vec4(max(0, sin(t)),
		 max(0, sin(t+PI2div3)),
		 max(0, sin(t-PI2div3)), 1.0);
}

void main() {
	vec3 lightDirection = normalize(vec3(gl_LightSource[0].position));
	vec3 normal = gl_NormalMatrix * gl_Normal;
	float intensity = max(dot(normal, lightDirection), 0.0);
	gl_FrontColor = intensity * colorVec(time) + (1.0 - intensity) * colorVec(time + 1.5);

	gl_Position = gl_ProjectionMatrix * gl_ModelViewMatrix * gl_Vertex;
}