uniform float x;
uniform float y;

void main() {
	vec3 lightDirection = normalize(vec3(gl_LightSource[0].position));
	vec3 normal = gl_NormalMatrix * gl_Normal;
	float intensity = max(dot(normal, lightDirection), 0.0);
	gl_FrontColor = intensity * vec4(0.0,1.0,1.0,1.0);

	vec4 transVertex = gl_ModelViewMatrix * gl_Vertex;
	vec4 center = vec4(x*5,y*5,-5,1);
	float dist = distance(center.xy, transVertex.xy);
	float blend = min(1,dist / 2);

	gl_Position = gl_ProjectionMatrix * (transVertex * blend + center * (1-blend));
}