#!/bin/sh
# 
# Tcl-SOAP Beispiel mit verschachtelten
# Strukturen
# \
exec tclsh $0 $@


lappend auto_path tclsoap

package require dom
package require SOAP
package require XMLRPC
package require rpcvar

set validate false 
set SubscriptionId "Bitte eigene SubscriptionId bei Amazon anfordern"

# Typdefinition 
rpcvar::typedef {
    ResponseGroup stringValue
    Keywords stringValue
    SearchIndex stringValue
} ItemSearchRequestT

rpcvar::typedef {
    ResponseGroup stringValue
    ItemId stringValue    
} ItemLookupRequestT

# Erzeugt Kommandos
SOAP::create ItemSearch -uri http://webservices.amazon.com/AWSECommerceService/2005-07-26 \
    -proxy http://webservices.amazon.de/onca/soap?Service=AWSECommerceService \
    -params { SubscriptionId stringValue Validate stringValue Request ItemSearchRequestT }

SOAP::create ItemLookup -uri http://webservices.amazon.com/AWSECommerceService/2005-07-26 \
    -proxy http://webservices.amazon.de/onca/soap?Service=AWSECommerceService \
    -params { SubscriptionId stringValue Validate stringValue Request ItemLookupRequestT }


# Gibt eine Liste mit Ids fr eine Suche nach Schlsselwort
proc schlsselwort { schlssel } {
    set anfrage [ list ResponseGroup ItemIds Keywords $schlssel SearchIndex Books]
    set antwort [ ItemSearch $::SubscriptionId $::validate $anfrage]

    set Items [ lindex $antwort 8]
    set retval {}
    foreach { var value }  $Items {
	if {[string match Item $var]} {
	    lappend retval [lindex $value 1]
	}
    }
    return $retval
}

set asins [schlsselwort Tcl/Tk]



# Gibt Informationen fr ein Buch als Liste
proc asin2Info {asin} {
    set anfrage [ list ResponseGroup Medium ItemId $asin]
    set antwort [ ItemLookup $::SubscriptionId $::validate $anfrage]
    set Items [ lindex $antwort 8]
    set Item [lindex $Items 3]
    return $Item
}




set info [asin2Info [lindex $asins 0]]
array set Medium  $info
array set ItemAttributes $Medium(ItemAttributes)
puts "\nErstes Buch "
parray ItemAttributes








