#!/bin/sh
# 
# Einfaches Tcl-SOAP Beispiel 
# \
exec tclsh $0 $@

# Initialisierung 
lappend auto_path tclsoap1.6.7
package require xml
package require dom
package require SOAP

# Abfrage definieren
SOAP::create CtoF \
    -uri "http://www.borland.com/soapServices" \
    -proxy "http://developerdays.com/cgi-bin/tempconverter.exe/soap/ITempConverter" \
    -params { "temp" "int" } \

# ... und ausfhren
for {set c -40} {$c <= 100} {incr c 20} {
    puts "$cC = [CtoF $c]F"
}

    
# Anzeige von letztem Aufruf und Antwort
puts stderr "\nAnfrage"
puts stderr [ SOAP::dump -request CtoF ]

puts stderr " \nAntwort"
puts stderr [ SOAP::dump -reply CtoF ]

# Debugging, nur Ausgabe der Anfrage ohne sie
# zum Server zu schicken
proc SOAP::Transport::print::print {procVarName url soap} {
    puts stderr "$soap"
}
SOAP::configure CtoF -transport SOAP::Transport::print::print

puts stderr "\nDump"
CtoF 42




