#include <dlfcn.h>
#include <unistd.h>
#include <stdlib.h>
#include <string.h>
#include <stdio.h>
#include <stdarg.h>
#include <sys/time.h>
#include <faxdef.h>
#include <capitype.h>
#include <log.h>
#include <sfax.h>
#include <start.h>

/* DEFINE ****************************************************/

#define CAPI20_GO_INTERNAL_CONTROLLER 0x01
#define CAPI20_GO_EXTERNAL_EQUIPMENT  0x02
#define CAPI20_GO_HANDSET	      0x04
#define CAPI20_GO_DTMF		      0x08

#define CAPI20_B1_64KBIT_HDLC	      0x01
#define CAPI20_B1_64KBIT_TRANSPARENT  0x02
#define CAPI20_B1_V110_ASYNC	      0x04
#define CAPI20_B1_V110_SYNC	      0x08
#define CAPI20_B1_T30		      0x10
#define CAPI20_B1_64KBIT_INVERTED     0x20
#define CAPI20_B1_56KBIT_TRANSPARENT  0x40

#define CAPI20_B2_ISO7776_X75	      0x01
#define CAPI20_B2_TRANSPARENT	      0x02
#define CAPI20_B2_SDLC		      0x04
#define CAPI20_B2_LAPD		      0x08
#define CAPI20_B2_T30		      0x10
#define CAPI20_B2_PPP		      0x20
#define CAPI20_B2_TRANSPARENT_NOERR   0x40

#define CAPI20_B3_TRANSPARENT	      0x01
#define CAPI20_B3_T90		      0x02
#define CAPI20_B3_ISO8208	      0x04
#define CAPI20_B3_X25_DCE	      0x08
#define CAPI20_B3_T30		      0x10

#define _ALERT_REQ		      0x8001
#define _ALERT_CONF		      0x8101
#define _CONNECT_REQ		      0x8002
#define _CONNECT_CONF		      0x8102
#define _CONNECT_IND		      0x8202
#define _CONNECT_RESP		      0x8302
#define _CONNECT_ACTIVE_IND	      0x8203
#define _CONNECT_ACTIVE_RESP	      0x8303
#define _CONNECT_B3_ACTIVE_IND	      0x8283
#define _CONNECT_B3_ACTIVE_RESP       0x8383
#define _CONNECT_B3_REQ 	      0x8082
#define _CONNECT_B3_CONF	      0x8182
#define _CONNECT_B3_IND 	      0x8282
#define _CONNECT_B3_RESP	      0x8382
#define _CONNECT_B3_T90_ACTIVE_IND    0x8288
#define _CONNECT_B3_T90_ACTIVE_RESP   0x8388
#define _DATA_B3_REQ		      0x8086
#define _DATA_B3_CONF		      0x8186
#define _DATA_B3_IND		      0x8286
#define _DATA_B3_RESP		      0x8386
#define _DISCONNECT_B3_REQ	      0x8084
#define _DISCONNECT_B3_CONF	      0x8184
#define _DISCONNECT_B3_IND	      0x8284
#define _DISCONNECT_B3_RESP	      0x8384
#define _DISCONNECT_REQ 	      0x8004
#define _DISCONNECT_CONF	      0x8104
#define _DISCONNECT_IND 	      0x8204
#define _DISCONNECT_RESP	      0x8304
#define _FACILITY_REQ		      0x8080
#define _FACILITY_CONF		      0x8180
#define _FACILITY_IND		      0x8280
#define _FACILITY_RESP		      0x8380
#define _INFO_REQ		      0x8008
#define _INFO_CONF		      0x8108
#define _INFO_IND		      0x8208
#define _INFO_RESP		      0x8308
#define _LISTEN_REQ		      0x8005
#define _LISTEN_CONF		      0x8105
#define _MANUFACTURER_REQ	      0x80FF
#define _MANUFACTURER_CONF	      0x81FF
#define _MANUFACTURER_IND	      0x82FF
#define _MANUFACTURER_RESP	      0x83FF
#define _RESET_B3_REQ		      0x8087
#define _RESET_B3_CONF		      0x8187
#define _RESET_B3_IND		      0x8287
#define _RESET_B3_RESP		      0x8387
#define _SELECT_B_PROTOCOL_REQ	      0x8041
#define _SELECT_B_PROTOCOL_CONF       0x8141

#define GET_APPID(lp) *( (uint16*)((lp)+2) )
#define GET_SIZE(lp) *( (uint16*)(lp) )
#define GET_OPCODE(lp) *( (uint16*)((lp)+4) )
#define GET_CMD(lp) *( (uint8*)((lp)+4) )
#define GET_SUBCMD(lp) *( (uint8*)((lp)+5) )
#define GET_MSGNR(lp) *( (uint16*)((lp)+6) )
#define GET_PLCI(lp) *( (uint32*)((lp)+8) )
#define GET_NCCI(lp) *( (uint32*)((lp)+8) )


#define GET_UINT8(lp) *( (uint8*)((lp)) )
#define GET_UINT16(lp) *( (uint16*)((lp)) )
#define GET_UINT32(lp) *( (uint32*)((lp)) )

#define DATA_B3_REQ_DATA(Msg) (*(uint32  *)(Msg+8+(4)))
#define DATA_B3_REQ_DATA_LENGTH(Msg)           (*(uint16  *)(Msg+8+(8)))
#define DATA_B3_IND_DATA_HANDLE(Msg)           (*(uint16 *)(Msg+8+(10)))
#define DATA_B3_CONF_DATA_HANDLE(Msg)           (*(uint16 *)(Msg+8+(4)))

#define MAX_SF_TASKS  4

#define _MAX_MSGSIZE 512

/* TYPEDEF/STRUCT ********************************************/

typedef uint8 * STRUCT;



void *hCapi;
LOAD CapiFuncs[] = {
  { NULL, "capi20_register"},
  { NULL, "capi20_release"},
  { NULL, "capi20_put_message"},
  { NULL, "capi20_get_message"},
  { NULL, "capi20_waitformessage"},
  { NULL, "capi20_get_manufacturer"},
  { NULL, "capi20_get_version"},
  { NULL, "capi20_get_serial_number"},
  { NULL, "capi20_get_profile"},
  { NULL, "capi20_isinstalled"},
  { NULL, "capi20_fileno"},
  { NULL, "ALERT_REQ"},
  { NULL, "CONNECT_REQ"}, 
  { NULL, "CONNECT_B3_REQ"},
  { NULL, "DATA_B3_REQ"},
  { NULL, "DISCONNECT_B3_REQ"},
  { NULL, "DISCONNECT_REQ"},
  { NULL, "FACILITY_REQ"},
  { NULL, "INFO_REQ"},
  { NULL, "LISTEN_REQ"},
  { NULL, "MANUFACTURER_REQ"},
  { NULL, "RESET_B3_REQ"},
  { NULL, "SELECT_B_PROTOCOL_REQ"},
  { NULL, "CONNECT_RESP"},
  { NULL, "CONNECT_ACTIVE_RESP"},
  { NULL, "CONNECT_B3_ACTIVE_RESP"},
  { NULL, "CONNECT_B3_RESP"},
  { NULL, "CONNECT_B3_T90_ACTIVE_RESP"},
  { NULL, "DATA_B3_RESP"},
  { NULL, "DISCONNECT_B3_RESP"},
  { NULL, "DISCONNECT_RESP"},
  { NULL, "FACILITY_RESP"},
  { NULL, "INFO_RESP"},
  { NULL, "MANUFACTURER_RESP"},
  { NULL, "RESET_B3_RESP"},
  { NULL, "capi_get_cmsg"},
  { NULL, "capi_put_cmsg"},
  { NULL, "capi_cmsg_header"},
  { NULL, NULL}
};


int LoadCapi( char *sName )
{
  int ret = 0;
  const char *error;
  PLOAD pl = CapiFuncs;
  hCapi = dlopen( sName, RTLD_LAZY );
  if( hCapi )
    {
      while( pl->sName )
	{
	  pl->pFunc = dlsym( hCapi, pl->sName );
	  error = dlerror();
	  if( error )
	    {
	      ret = -1;
	      TRACE(("unable to load %s\n", pl->sName ));
	      break;
	    }
	  pl++;
	}
    }
  else
    {
      TRACE(("unable to open %s\n", sName ));
      ret = 1;
    }
  if( !ret )
    {
      TRACE(("Capi initialized\n"));
    }
  return ret;
}


void _init( void )
{
  LoadCapi( "libcapi20.so.2" );
  start();
  //  FaxStart(NULL, NULL);
}

void _fini( void )
{
  FaxStop();
}




/*-------------------------------------------------------------------------
/  Funktion  : DATA_B3_REQ
/--------------------------------------------------------------------------
/  Inhalt    :
/  Parameter :
/  Rueckgabe :
/    0x0000            No error
/    All other values  Coded as described in parameter info class 0x11xx
/--------------------------------------------------------------------------
/  Geaendert :
/------------------------------------------------------------------------*/
unsigned long REAL_DATA_B3_REQ(  unsigned short wApplID,
			    unsigned short wMsgNoAppl,
			    unsigned long  dwNCCI,
			    unsigned char *lpData,
			    unsigned short   wDataLength,
			    unsigned short   wDataHandle,
			    unsigned short   wFlags )
{

  int i = 8;
  unsigned char pM[_MAX_MSGSIZE];

  *(unsigned long  *)(pM+i) = dwNCCI;
  i+= sizeof(unsigned long);
  *(unsigned long  *)(pM+i) = (unsigned long) lpData;
  i+= sizeof(unsigned long);
  *(unsigned short  *)(pM+i)  = wDataLength;
  i+= sizeof(unsigned short);
  *(unsigned short  *)(pM+i)  = wDataHandle;
  i+= sizeof(unsigned short);
  *(unsigned short  *)(pM+i)  = wFlags;
  i+= sizeof(unsigned short);

  if (wMsgNoAppl >= 0x7FFF) wMsgNoAppl = 0;

  *(unsigned short  *) pM = (unsigned short) i;
  *(unsigned short  *) (pM+2) = wApplID;
  *(unsigned short  *) (pM+4) = _DATA_B3_REQ;
  *(unsigned short  *) (pM+6) = wMsgNoAppl;

  return REAL_CAPI_PUT_MSG( wApplID, (unsigned char *) pM );
}

/*-------------------------------------------------------------------------
/  Funktion  : DATA_B3_RESP
/--------------------------------------------------------------------------
/  Inhalt    :
/  Parameter :
/  Rueckgabe :
/    0x0000            No error
/    All other values  Coded as described in parameter info class 0x11xx
/--------------------------------------------------------------------------
/  Geaendert :
/------------------------------------------------------------------------*/
unsigned long REAL_DATA_B3_RESP(  unsigned short wApplID,
                    unsigned short wMsgNr,
                    unsigned long dwNCCI,
                    unsigned short wDataHandle )
{

  int i = 8;
  unsigned char pM[_MAX_MSGSIZE];

  *(unsigned long  *)(pM+i) = dwNCCI;
  i+= sizeof(unsigned long );
  *(unsigned short  *)(pM+i) = wDataHandle;
  i+= sizeof(unsigned short);

  *(unsigned short  *) pM = (unsigned short) i;
  *(unsigned short  *) (pM+2) = wApplID;
  *(unsigned short  *) (pM+4) = _DATA_B3_RESP;
  *(unsigned short  *) (pM+6) = wMsgNr;

  return REAL_CAPI_PUT_MSG( wApplID, (unsigned char *) pM );
}

unsigned long REAL_CONNECT_B3_ACTIVE_RESP(  unsigned short wApplID,
					    unsigned short wMsgNr,
					    unsigned long dwNCCI )
{

  int i = 8;
  unsigned char pM[_MAX_MSGSIZE];

  *(unsigned long *)(pM+i) = dwNCCI;
  i+= sizeof(unsigned long);

  *(unsigned short *) pM     = (unsigned short) i;
  *(unsigned short *) (pM+2) = wApplID;
  *(unsigned short *) (pM+4) = _CONNECT_B3_ACTIVE_RESP;
  *(unsigned short *) (pM+6) = wMsgNr;

  return REAL_CAPI_PUT_MSG( wApplID, pM );
}

/*-------------------------------------------------------------------------
/  Funktion  : DISCONNECT_B3_RESP
/--------------------------------------------------------------------------
/  Inhalt    :
/  Parameter :
/  Rueckgabe :
/    0x0000            No error
/    All other values  Coded as described in parameter info class 0x11xx
/--------------------------------------------------------------------------
/  Geaendert :
/------------------------------------------------------------------------*/
unsigned long REAL_DISCONNECT_B3_RESP(  unsigned short wApplID,
					unsigned short wMsgNr,
					unsigned long dwNCCI )
{

  int i = 8;
  unsigned char pM[_MAX_MSGSIZE];

  *(unsigned long *)(pM+i) = dwNCCI;
  i+= sizeof(unsigned long);

  *(unsigned short *) pM = (unsigned short) i;
  *(unsigned short *) (pM+2) = wApplID;
  *(unsigned short *) (pM+4) = _DISCONNECT_B3_RESP;
  *(unsigned short *) (pM+6) = wMsgNr;

  return REAL_CAPI_PUT_MSG( wApplID, pM );
}

unsigned long REAL_DISCONNECT_REQ(  unsigned short wApplID,
				    unsigned short wMsgNoAppl,
				    unsigned long dwPLCI,
				    unsigned char *lpAdditionalInfo )
{

  int i = 8;
  int j;
  unsigned char pM[_MAX_MSGSIZE];

  *(unsigned long *)(pM+i) = dwPLCI;
  i+= sizeof(unsigned long);

  for( j = 0; j < lpAdditionalInfo[0] + 1; j++,i++ )
    pM[i] = lpAdditionalInfo[j];

  if (wMsgNoAppl >= 0x7FFF) wMsgNoAppl = 0;

  *(unsigned short *) pM = (unsigned short) i;
  *(unsigned short *) (pM+2) = wApplID;
  *(unsigned short *) (pM+4) = _DISCONNECT_REQ;
  *(unsigned short *) (pM+6) = wMsgNoAppl;

  return REAL_CAPI_PUT_MSG( wApplID, pM );
}

unsigned long REAL_DISCONNECT_RESP(  unsigned short wApplID,
				     unsigned short wMsgNr,
				     unsigned long dwPLCI )
{

  int i = 8;
  unsigned char pM[_MAX_MSGSIZE];

  *(unsigned long *)(pM+i) = dwPLCI;
  i+= sizeof(unsigned long);

  *(unsigned short *) pM = (unsigned short) i;
  *(unsigned short *) (pM+2) = wApplID;
  *(unsigned short *) (pM+4) = _DISCONNECT_RESP;
  *(unsigned short *) (pM+6) = wMsgNr;

  return REAL_CAPI_PUT_MSG( wApplID, pM );
}


unsigned long REAL_DISCONNECT_B3_REQ(  unsigned short wApplID,
				       unsigned short wMsgNoAppl,
				       unsigned long dwNCCI,
				       unsigned char *lpNCPI )
{

  int i = 8;
  int j;
  unsigned char pM[_MAX_MSGSIZE];

  *(unsigned long *)(pM+i) = dwNCCI;
  i+= sizeof(unsigned long);

  for( j = 0; j < lpNCPI[0] + 1; j++,i++ )
    pM[i] = lpNCPI[j];

  if (wMsgNoAppl >= 0x7FFF) wMsgNoAppl = 0;

  *(unsigned short *) pM = (unsigned short) i;
  *(unsigned short *) (pM+2) = wApplID;
  *(unsigned short *) (pM+4) = _DISCONNECT_B3_REQ;
  *(unsigned short *) (pM+6) = wMsgNoAppl;

  return REAL_CAPI_PUT_MSG( wApplID, pM );
}



unsigned capi20_register (unsigned MaxLogicalConnection,
			  unsigned MaxBDataBlocks,
			  unsigned MaxBDataLen,
			  unsigned *ApplIDp)
{
  unsigned ret = 0;
  FaxStart(NULL, NULL);
  ret = REAL_CAPI_REGISTER( MaxLogicalConnection,
			    MaxBDataBlocks,
			    MaxBDataLen,
			    ApplIDp);
  return ret;
}

unsigned capi20_release (unsigned ApplID)
{
  unsigned ret;
  ret = REAL_CAPI_RELEASE( ApplID );
  return ret;
}


unsigned capi20_waitformessage(unsigned ApplID, struct timeval *TimeOut)
{
  return REAL_CAPI_WAITMSG( ApplID, TimeOut );
}

unsigned char *capi20_get_manufacturer (unsigned Ctrl, unsigned char *Buf)
{
  return REAL_CAPI_GET_MANU( Ctrl, Buf );
}

unsigned char *capi20_get_version (unsigned Ctrl, unsigned char *Buf)
{
  return REAL_CAPI_GET_VER( Ctrl, Buf );
}

unsigned char *capi20_get_serial_number (unsigned Ctrl, unsigned char *Buf)
{
  return REAL_CAPI_GET_SER( Ctrl, Buf );
}

unsigned capi20_get_profile (unsigned Ctrl, unsigned char *Buf)
{
  unsigned rvl = REAL_CAPI_GET_PROF( Ctrl, Buf );
  unsigned long *pProf = ( unsigned long *)Buf;
  if( !rvl && Ctrl && Ret.pFunc[0] )
    {
      pProf[2] |= 0x00000010;
      pProf[3] |= 0x00000010;
      pProf[4] |= 0x00000010;
    }
    return rvl;
}

unsigned capi20_isinstalled (void)
{
  return REAL_CAPI_INSTALLED();
}

int capi20_fileno( unsigned ApplId )
{
  return REAL_CAPI_FILENO( ApplId );
}

/* FUNCTION **************************************************
 *  NAME	CAPI2SF_PUT_MESSAGE
 *  COMMENT
 *************************************************************
 *  ====>
 *  <====
 *************************************************************/
unsigned capi20_put_message (unsigned wAppID, unsigned char *pBuffer)
{
  uint8 *pB1Protocol;
  uint8 *pB2Protocol;
  uint8 *pB3Protocol;
  uint16 wBLength, wB1Length, wB2Length, wB3Length;
  uint16 wFormatB3 = 0;


  uint32 ret;
  
  PFAX pFax = FaxFindEntity( wAppID, 0, 0 );



  if( GET_NCCI( pBuffer ) == 0 || GET_PLCI( pBuffer ) == 0 )
    {
      TRACE(("Upps SF_Get_Message %X\n", GET_OPCODE( pBuffer ) ));
    }
  


  switch( GET_OPCODE( pBuffer ) )
    {
    case _CONNECT_REQ:
      {
	uint8 *pMsg = pBuffer + 8 + 4 + 2;    /* skip msg hdr, 'Cntrllr', 'CIP' */
	uint8 bLen;
	char CalledParty[40];
	bLen = *pMsg++;
	memset( CalledParty, 0, 40 );
	if( bLen > 0 )
	  {
	    memcpy( CalledParty, pMsg + 1, bLen - 1 );
	    TRACE(("==> Connect_Request Number: %s\n", CalledParty ));
	  }
	pMsg += bLen;   /* skip 'Called Party Number' */
	bLen = *pMsg++; pMsg += bLen;
	bLen = *pMsg++; pMsg += bLen;   /* skip 'Called Party Subaddress' */
	bLen = *pMsg++; pMsg += bLen;   /* skip 'Calling Party Subaddress' */
	
	wBLength = *pMsg;
	pB1Protocol = pMsg + 7;
	wB1Length = *pB1Protocol++;
	pB2Protocol = pB1Protocol + wB1Length;
	wB2Length = *pB2Protocol++;
	pB3Protocol = pB2Protocol + wB2Length;
	wB3Length = *pB3Protocol++;
	
	if( wB3Length >= 4 )
	  wFormatB3 = *(uint16*)(pB3Protocol+2);
	if( pMsg[0] > 6 )
	  {
	    if( (( pMsg[1] == 4 && pMsg[3] == 4 && pMsg[5] == 4 ) || 
		 ( pMsg[1] == 28 && pMsg[3] == 28 && pMsg[5] == 28 )) && 
		wFormatB3 != 0x0C00 )
	      {
		pMsg[1] = 4;
		pMsg[3] = 4;
		pMsg[5] = 4;
	      
		if( pFax )
		  FaxFreeEntity( pFax );

		if( FaxNewEntity( wAppID,  pMsg, 0 ))
		  {
		    pMsg[1] = 1;
		    pMsg[3] = 1;
		    pMsg[5] = 0;
		  }
	      }

	  }
	break;
      }
    case _CONNECT_RESP:
      {
	
	uint8 *pMsg = pBuffer + 8 + 4 + 2;    /* skip msg hdr, 'PLCI', 'Reject' */
	wBLength = *pMsg;
	pB1Protocol = pMsg + 7;
	wB1Length = *pB1Protocol++;
	pB2Protocol = pB1Protocol + wB1Length;
	wB2Length = *pB2Protocol++;
	pB3Protocol = pB2Protocol + wB2Length;
	wB3Length = *pB3Protocol++;
	
	TRACE(("_CONNECT_RESP\n"));
	
	if( wB3Length >= 4 )
	  wFormatB3 = *(uint16*)(pB3Protocol+2);
	if( pMsg[0] > 6 )
	  {
	    

	    if( (( pMsg[1] == 4 && pMsg[3] == 4 && pMsg[5] == 4 ) || 
		 ( pMsg[1] == 28 && pMsg[3] == 28 && pMsg[5] == 28 )) && 
		wFormatB3 != 0x0C00 )
	      {
		pMsg[1] = 4;
		pMsg[3] = 4;
		pMsg[5] = 4;

	      
		if( pFax )
		  FaxFreeEntity( pFax );
			      
		if( FaxNewEntity( wAppID,  pMsg, GET_PLCI(pBuffer) ))
		  {
		    pMsg[1] = 1;
		    pMsg[3] = 1;
		    pMsg[5] = 0;
		  }

	      }
	    
	  }
	break;
      }
    
    case _DISCONNECT_REQ:
      if( pFax && pFax->fStarted )
	{
	  TRACE(("sf got DISCONNECT_REQ\n" )); 
	  return Fax_Put_Message( pFax, pBuffer);
	}
      break;
      
    case _DISCONNECT_RESP:
      break;

    case _CONNECT_B3_ACTIVE_RESP:
      break;
      
    case _DATA_B3_REQ:
      if( pFax )
	{
	  return Fax_Put_Message( pFax, pBuffer);
	}
      break;
      
    case _DATA_B3_RESP:
      if( pFax )
	{
	  return Fax_Put_Message( pFax, pBuffer);
	}

      break;
      
    case _DISCONNECT_B3_REQ:
      if( pFax )
	{
	  return Fax_Put_Message( pFax, pBuffer);
	}
      break;
      
    case _DISCONNECT_B3_RESP:
      if( pFax )
	{
	  return 0;
	}
      break;

    }
  ret = REAL_CAPI_PUT_MSG( wAppID, pBuffer );
  return ret;
}


/* FUNCTION **************************************************
 *  NAME	CAPI2SF_GET_MESSAGE
 *  COMMENT
 *************************************************************
 *  ====>
 *  <====
 *************************************************************/
unsigned capi20_get_message (unsigned wAppID, unsigned char **Buf)
{
  uint32 wRetValue;
  uint8 *pMsg = 0;
  PFAX pFax = FaxFindEntity( wAppID, 0, 0 );


  if( pFax )
    {
      wRetValue = Fax_Get_Message( pFax, Buf);
      if( !wRetValue )
	return wRetValue;
    }

  if( 0 == ( wRetValue = (uint16)REAL_CAPI_GET_MSG( wAppID, &pMsg ) ) )
    {
      
      if( GET_NCCI( pMsg ) == 0 || GET_PLCI( pMsg ) == 0 )
	{
	  TRACE(("Upps Real_Get_Message %X\n", GET_OPCODE( pMsg ) ));
	}
      
      *Buf = pMsg;
      
      //      memcpy( pBuffer, getmess_buffer, GET_SIZE( getmess_buffer ));
      
      
      //     TRACE(("Upps SF_Get_Message %X %X\n", GET_OPCODE( pBuffer ), 
      //      GET_PLCI( pBuffer ) );

      switch( GET_OPCODE( pMsg ) )
	{
	  
	case _CONNECT_CONF:
	  {
	    if( pFax )
	      {
		pFax->dwPlci = GET_PLCI( pMsg );
		TRACE(("Connect_Conf %d %x %x\n", 
		       wAppID, pFax, pFax->dwPlci ));
	      }
	  }
	  break;
	  
	case _CONNECT_B3_IND:
	case _CONNECT_B3_CONF:
	  break;
	  
	case _CONNECT_B3_ACTIVE_IND:
	  {
	    if( pFax )
	      {
		TRACE(("StartFax\n"));
		REAL_CONNECT_B3_ACTIVE_RESP(  wAppID,
					      GET_MSGNR(pMsg),
					      GET_NCCI(pMsg));
		pFax->dwPlci = GET_PLCI( pMsg );
		TRACE(("Connect_b3_active %d %x %x\n", 
		       wAppID, pFax, pFax->dwPlci ));

		FaxStartConnection( pFax );
		return 0x1104;
	      }
	  }
	  break;


	case _DATA_B3_CONF:
	  {
	    //TRACE(("Data_B3_Conf %d %x %x\n", 
	    //   wAppID, pFax, pFax->dwPlci ));
	    
	    if( pFax )
	      {
		if( FaxProcessDataConf( pFax, DATA_B3_CONF_DATA_HANDLE(pMsg) ))
		  { 
		  }		
		return 0x1104;
	      }
	  }
	  break;
	
	case _DATA_B3_IND:
	  {
	    //TRACE(("Data_B3_Ind %d %x %x\n", 
	    //	   wAppID, pFax, pFax->dwPlci ));

	    if( pFax )
	      {
		unsigned len;
		REAL_DATA_B3_RESP( GET_APPID( pMsg ),
				   GET_MSGNR(pMsg),
				   GET_NCCI(pMsg),
				   DATA_B3_IND_DATA_HANDLE(pMsg) );

		len = FaxProcessDataInd(pFax, 
					(unsigned char *)DATA_B3_REQ_DATA(pMsg),
					DATA_B3_REQ_DATA_LENGTH(pMsg));
		
		if( len )
		  {
		    int i;
		    for( i = 0; i < len/2048; i++ )
		      { 
			//  TRACE(("Do DataB3Req\n" ));
			pFax->wDataLen[pFax->whData] = 2048;
			REAL_DATA_B3_REQ(  GET_APPID( pMsg ),
					   1,
					   GET_NCCI(pMsg),
					   pFax->pDataBufr,
					   2048,
					   pFax->whData++,
					   0 );
			pFax->whData &= ( B3_BLOCKS - 1 );
			pFax->pDataBufr += 2048;
			if(pFax->pDataBufr >= &pFax->DataBuf[2048 * B3_BLOCKS])
			  pFax->pDataBufr = pFax->DataBuf;
		      }
		    len %= 2048;
		    if( len )
		      {
			pFax->wDataLen[pFax->whData] = len;
			REAL_DATA_B3_REQ(  GET_APPID( pMsg ),
					   1,
					   GET_NCCI(pMsg),
					   pFax->pDataBufr,
					   len,
					   pFax->whData++,
					   0 );

			pFax->whData &= ( B3_BLOCKS - 1 );
			pFax->pDataBufr += len;
			if(pFax->pDataBufr >= &pFax->DataBuf[2048 * B3_BLOCKS])
			  pFax->pDataBufr = pFax->DataBuf;

		      }
		  }
		if( pFax->fDisconnect > 1 )
		  {
		    pFax->fDisconnect --;
		    if( pFax->fDisconnect == 1 )
		      REAL_DISCONNECT_B3_REQ( GET_APPID( pMsg ),
					      1,
					      pFax->dwPlci,
					      "" );
		  }
		return 0x1104;
	      }
	  }
	  break;
	  
	case _DISCONNECT_B3_IND:
	  {
	    if( pFax )
	      {
		REAL_DISCONNECT_B3_RESP(  wAppID,
					  GET_MSGNR(pMsg),
					  GET_NCCI(pMsg));
		FaxStopConnection( pFax );
		if( pFax->fDisconnect )
		  REAL_DISCONNECT_REQ(  GET_APPID( pMsg ),
					1,
					GET_NCCI(pMsg),
					"" );		   
		
		return 0x1104;
	      }
	  }
	  break;

	case _DISCONNECT_B3_CONF:
	  {
	    if( pFax )
	      {
		return 0x1104;
	      }
	  }
	  break;

	case _DISCONNECT_IND:
	  {
	    if( pFax )
	      {
		TRACE(("got real disconnect\n" ));
		FaxFreeEntity( pFax );
	      }
	  }	  
	  break;
	}
      
    }  
  return wRetValue;
}



unsigned ALERT_REQ(_cmsg *cmsg, _cword ApplId, 
		   _cword Messagenumber
		   ,_cdword adr
		   ,_cstruct BChannelinformation
		   ,_cstruct Keypadfacility
		   ,_cstruct Useruserdata
		   ,_cstruct Facilitydataarray)
{
  return _REAL_ALERT_REQ( cmsg, ApplId, 
			  Messagenumber
			  ,adr
			  ,BChannelinformation
			  ,Keypadfacility
			  ,Useruserdata
			  ,Facilitydataarray);
}

unsigned CONNECT_REQ(_cmsg *cmsg, _cword ApplId, 
		     _cword Messagenumber
		     ,_cdword adr
		     ,_cword CIPValue
		     ,_cstruct CalledPartyNumber
		     ,_cstruct CallingPartyNumber
		     ,_cstruct CalledPartySubaddress
		     ,_cstruct CallingPartySubaddress
		     ,_cword B1protocol
		     ,_cword B2protocol
		     ,_cword B3protocol
		     ,_cstruct B1configuration
		     ,_cstruct B2configuration
		     ,_cstruct B3configuration
		     ,_cstruct BC
		     ,_cstruct LLC
		     ,_cstruct HLC
		     ,_cstruct BChannelinformation
		     ,_cstruct Keypadfacility
		     ,_cstruct Useruserdata
		     ,_cstruct Facilitydataarray)
{
  return _REAL_CONNECT_REQ( cmsg, ApplId, 
			    Messagenumber
			    ,adr
			    ,CIPValue
			    ,CalledPartyNumber
			    ,CallingPartyNumber
			    ,CalledPartySubaddress
			    ,CallingPartySubaddress
			    ,B1protocol
			    ,B2protocol
			    ,B3protocol
			    ,B1configuration
			    ,B2configuration
			    ,B3configuration
			    ,BC
			    ,LLC
			    ,HLC
			    ,BChannelinformation
			    ,Keypadfacility
			    ,Useruserdata
			    ,Facilitydataarray);
}

unsigned CONNECT_B3_REQ(_cmsg *cmsg, _cword ApplId, 
			_cword Messagenumber
			,_cdword adr
			,_cstruct NCPI)
{
  return _REAL_CONNECT_B3_REQ( cmsg, ApplId, 
			 Messagenumber
			 ,adr
			 ,NCPI);
}

unsigned DATA_B3_REQ(_cmsg *cmsg, _cword ApplId, 
		     _cword Messagenumber
		     ,_cdword adr
		     ,void * Data
		     ,_cword DataLength
		     ,_cword DataHandle
		     ,_cword Flags)
{
  return _REAL_DATA_B3_REQ( cmsg, ApplId, 
			    Messagenumber
			    ,adr
			    ,Data
			    ,DataLength
			    ,DataHandle
			    ,Flags);
}

unsigned DISCONNECT_B3_REQ(_cmsg *cmsg, _cword ApplId, 
			   _cword Messagenumber
			   ,_cdword adr
			   ,_cstruct NCPI)
{
  return _REAL_DISCONNECT_B3_REQ( cmsg, ApplId, 
				  Messagenumber
				  ,adr
				  ,NCPI);
}

unsigned DISCONNECT_REQ(_cmsg *cmsg, _cword ApplId, 
			_cword Messagenumber
			,_cdword adr
			,_cstruct BChannelinformation
			,_cstruct Keypadfacility
			,_cstruct Useruserdata
			,_cstruct Facilitydataarray)
{
  return _REAL_DISCONNECT_REQ( cmsg, ApplId, 
			       Messagenumber
			       ,adr
			       ,BChannelinformation
			       ,Keypadfacility
			       ,Useruserdata
			       ,Facilitydataarray);
}

unsigned FACILITY_REQ(_cmsg *cmsg, _cword ApplId, 
		      _cword Messagenumber
		      ,_cdword adr
		      ,_cword FacilitySelector
		      ,_cstruct FacilityRequestParameter)
{
  return _REAL_FACILITY_REQ( cmsg, ApplId, 
			     Messagenumber
			     ,adr
			     ,FacilitySelector
			     ,FacilityRequestParameter);
}

unsigned INFO_REQ(_cmsg *cmsg, _cword ApplId, 
		  _cword Messagenumber
		  ,_cdword adr
		  ,_cstruct CalledPartyNumber
		  ,_cstruct BChannelinformation
		  ,_cstruct Keypadfacility
		  ,_cstruct Useruserdata
		  ,_cstruct Facilitydataarray)
{
  return _REAL_INFO_REQ( cmsg, ApplId, 
			 Messagenumber
			 ,adr
			 ,CalledPartyNumber
			 ,BChannelinformation
			 ,Keypadfacility
			 ,Useruserdata
			 ,Facilitydataarray);
}

unsigned LISTEN_REQ (_cmsg *cmsg, _cword ApplId, 
		     _cword Messagenumber
		     ,_cdword adr
		     ,_cdword InfoMask
		     ,_cdword CIPmask
		     ,_cdword CIPmask2
		     ,_cstruct CallingPartyNumber
		     ,_cstruct CallingPartySubaddress)
{
  return _REAL_LISTEN_REQ ( cmsg, ApplId, 
			    Messagenumber
			    ,adr
			    ,InfoMask
			    ,CIPmask
			    ,CIPmask2
			    ,CallingPartyNumber
			    ,CallingPartySubaddress);
}

unsigned MANUFACTURER_REQ(_cmsg *cmsg, _cword ApplId, 
			  _cword Messagenumber
			  ,_cdword adr
			  ,_cdword ManuID
			  ,_cdword Class
			  ,_cdword Function
			  ,_cstruct ManuData)
{
  return _REAL_MANUFACTURER_REQ( cmsg, ApplId, 
				 Messagenumber
				 ,adr
				 ,ManuID
				 ,Class
				 ,Function
				 ,ManuData);
}

unsigned RESET_B3_REQ(_cmsg *cmsg, _cword ApplId, 
		      _cword Messagenumber
		      ,_cdword adr
		      ,_cstruct NCPI)
{
  return _REAL_RESET_B3_REQ( cmsg, ApplId, 
			    Messagenumber
			    ,adr
			   ,NCPI);
}

unsigned SELECT_B_PROTOCOL_REQ(_cmsg *cmsg, _cword ApplId, 
			       _cword Messagenumber
			       ,_cdword adr
			       ,_cword B1protocol
			       ,_cword B2protocol
			       ,_cword B3protocol
			       ,_cstruct B1configuration
			       ,_cstruct B2configuration
			       ,_cstruct B3configuration)
{
  return _REAL_SELECT_B_PROTOCOL_REQ( cmsg, ApplId, 
				      Messagenumber
				      ,adr
				      ,B1protocol
				      ,B2protocol
				      ,B3protocol
				      ,B1configuration
				      ,B2configuration
				      ,B3configuration);
}


unsigned CONNECT_RESP(_cmsg *cmsg, _cword ApplId, 
		      _cword Messagenumber
		      ,_cdword adr
		      ,_cword Reject
		      ,_cword B1protocol
		      ,_cword B2protocol
		      ,_cword B3protocol
		      ,_cstruct B1configuration
		      ,_cstruct B2configuration
		      ,_cstruct B3configuration
		      ,_cstruct ConnectedNumber
		      ,_cstruct ConnectedSubaddress
		      ,_cstruct LLC
		      ,_cstruct BChannelinformation
		      ,_cstruct Keypadfacility
		      ,_cstruct Useruserdata
		      ,_cstruct Facilitydataarray)
{
  return _REAL_CONNECT_RESP( cmsg, ApplId, 
			     Messagenumber
			     ,adr
			     ,Reject
			     ,B1protocol
			     ,B2protocol
			     ,B3protocol
			     ,B1configuration
			     ,B2configuration
			     ,B3configuration
			     ,ConnectedNumber
			     ,ConnectedSubaddress
			     ,LLC
			     ,BChannelinformation
			     ,Keypadfacility
			     ,Useruserdata
			     ,Facilitydataarray);
}

unsigned CONNECT_ACTIVE_RESP(_cmsg *cmsg, _cword ApplId, 
			     _cword Messagenumber
			     ,_cdword adr)
{
  return _REAL_CONNECT_ACTIVE_RESP( cmsg, ApplId, 
				    Messagenumber
				    ,adr);
}

unsigned CONNECT_B3_ACTIVE_RESP(_cmsg *cmsg, _cword ApplId, 
				_cword Messagenumber
				,_cdword adr)
{
  return _REAL_CONNECT_B3_ACTIVE_RESP( cmsg, ApplId, 
				       Messagenumber
				       ,adr);
}


unsigned CONNECT_B3_RESP(_cmsg *cmsg, _cword ApplId, 
			 _cword Messagenumber
			 ,_cdword adr
			 ,_cword Reject
			 ,_cstruct NCPI)
{
  return _REAL_CONNECT_B3_RESP( cmsg, ApplId, 
				Messagenumber
				,adr
				,Reject
				,NCPI);
}

unsigned CONNECT_B3_T90_ACTIVE_RESP(_cmsg *cmsg, _cword ApplId, 
				    _cword Messagenumber
				    ,_cdword adr)
{
  return _REAL_CONNECT_B3_T90_ACTIVE_RESP( cmsg, ApplId, 
					   Messagenumber
					   ,adr);
}

unsigned DATA_B3_RESP(_cmsg *cmsg, _cword ApplId, 
		      _cword Messagenumber
		      ,_cdword adr
		      ,_cword DataHandle)
{
  return _REAL_DATA_B3_RESP( cmsg, ApplId, 
			     Messagenumber
			     ,adr
			     ,DataHandle);
}

unsigned DISCONNECT_B3_RESP(_cmsg *cmsg, _cword ApplId, 
			    _cword Messagenumber
			    ,_cdword adr)
{
  return _REAL_DISCONNECT_B3_RESP( cmsg, ApplId, 
				   Messagenumber
				   ,adr);
}

unsigned DISCONNECT_RESP(_cmsg *cmsg, _cword ApplId, 
			 _cword Messagenumber
			 ,_cdword adr)
{
  return _REAL_DISCONNECT_RESP( cmsg, ApplId, 
				Messagenumber
				,adr);
}

unsigned FACILITY_RESP(_cmsg *cmsg, _cword ApplId, 
		       _cword Messagenumber
		       ,_cdword adr
		       ,_cword FacilitySelector
		       ,_cstruct FacilityResponseParameters)
{
  return _REAL_FACILITY_RESP( cmsg, ApplId, 
			      Messagenumber
			      ,adr
			      ,FacilitySelector
			      ,FacilityResponseParameters);
}

unsigned INFO_RESP(_cmsg *cmsg, _cword ApplId, 
		   _cword Messagenumber
		   ,_cdword adr)
{
  return _REAL_INFO_RESP( cmsg, ApplId, 
			  Messagenumber
			  ,adr);
}

unsigned MANUFACTURER_RESP(_cmsg *cmsg, _cword ApplId, 
			   _cword Messagenumber
			   ,_cdword adr
			   ,_cdword ManuID
			   ,_cdword Class
			   ,_cdword Function
			   ,_cstruct ManuData)
{
  return _REAL_MANUFACTURER_RESP( cmsg, ApplId, 
				  Messagenumber
				  ,adr
				  ,ManuID
				  ,Class
				  ,Function
				  ,ManuData);
}

unsigned RESET_B3_RESP(_cmsg *cmsg, _cword ApplId, 
		       _cword Messagenumber
		       ,_cdword adr)
{
  return _REAL_RESET_B3_RESP( cmsg, ApplId, 
			      Messagenumber
			      ,adr);
}


unsigned capi_get_cmsg(_cmsg *cmsg, unsigned applid)
{
  return _real_capi_get_cmsg( cmsg, applid);
}

unsigned capi_put_cmsg(_cmsg *cmsg)
{
  return _real_capi_put_cmsg( cmsg );
}

unsigned capi_cmsg_header (_cmsg *cmsg, unsigned _ApplId, _cbyte _Command, _cbyte _Subcommand, _cword _Messagenumber, _cdword _Controller)
{
  return _real_capi_cmsg_header ( cmsg, _ApplId, _Command, 
				  _Subcommand, _Messagenumber, _Controller);
}


void _trace( const char * pszFmt, ...)
{
  static char szLine[256];
  va_list pVA;

  va_start( pVA, pszFmt );
  vsprintf( szLine, pszFmt, pVA );
  va_end( pVA );
  //printf( szLine );
}




