#ifndef _CAPITYPE_H
#define _CAPITYPE_H

typedef struct _load
{
  void *pFunc;
  const char *sName;
}LOAD, *PLOAD;

#define ALERT_REQ_ID  11
#define CONNECT_REQ_ID 12 
#define CONNECT_B3_REQ_ID 13
#define DATA_B3_REQ_ID 14
#define DISCONNECT_B3_REQ_ID 15
#define DISCONNECT_REQ_ID 16
#define FACILITY_REQ_ID 17
#define INFO_REQ_ID 18
#define LISTEN_REQ_ID 19
#define MANUFACTURER_REQ_ID 20
#define RESET_B3_REQ_ID 21
#define SELECT_B_PROTOCOL_REQ_ID 22
#define CONNECT_RESP_ID 23
#define CONNECT_ACTIVE_RESP_ID 24
#define CONNECT_B3_ACTIVE_RESP_ID 25
#define CONNECT_B3_RESP_ID 26
#define CONNECT_B3_T90_ACTIVE_RESP_ID 27
#define DATA_B3_RESP_ID 28
#define DISCONNECT_B3_RESP_ID 29
#define DISCONNECT_RESP_ID 30
#define FACILITY_RESP_ID 31
#define INFO_RESP_ID 32
#define MANUFACTURER_RESP_ID 33
#define RESET_B3_RESP_ID 34
#define capi_get_cmsg_ID 35
#define capi_put_cmsg_ID 36
#define capi_cmsg_header_ID 37


typedef unsigned char _cbyte;
typedef unsigned char _cmsg;
typedef unsigned short _cword;
typedef unsigned long _cdword;
typedef unsigned char * _cstruct;


#define REAL_CAPI_REGISTER(A,B,C,D) (*((REGISTER)CapiFuncs[0].pFunc))(A,B,C,D)
#define REAL_CAPI_RELEASE(A) (*((RELEASE)CapiFuncs[1].pFunc))(A)
#define REAL_CAPI_PUT_MSG(A,B) (*((PUTMSG)CapiFuncs[2].pFunc))(A,B)
#define REAL_CAPI_GET_MSG(A,B) (*((GETMSG)CapiFuncs[3].pFunc))(A,B)
#define REAL_CAPI_WAITMSG(A,B) (*((WAITMSG)CapiFuncs[4].pFunc))(A,B)
#define REAL_CAPI_GET_MANU(A,B) (*((GETMANU)CapiFuncs[5].pFunc))(A,B)
#define REAL_CAPI_GET_VER(A,B) (*((GETVER)CapiFuncs[6].pFunc))(A,B)
#define REAL_CAPI_GET_SER(A,B) (*((GETSER)CapiFuncs[7].pFunc))(A,B)
#define REAL_CAPI_GET_PROF(A,B) (*((GETPROF)CapiFuncs[8].pFunc))(A,B)
#define REAL_CAPI_INSTALLED (*((INSTALLED)CapiFuncs[9].pFunc))
#define REAL_CAPI_FILENO(A) (*((FILENO)CapiFuncs[10].pFunc))(A)

#define _REAL_ALERT_REQ(A,B,C,D,E,F,G,H) \
( *((PALERT_REQ)CapiFuncs[ALERT_REQ_ID].pFunc ))(A,B,C,D,E,F,G,H)

#define _REAL_CONNECT_REQ(A,B,C,D,E,F,G,H,I,J,K,L,M,N,O,P,Q,R,S,T,U,V) \
( *((PCONNECT_REQ)CapiFuncs[CONNECT_REQ_ID].pFunc ))(A,B,C,D,E,F,G,H,I,J,K,L,M,N,O,P,Q,R,S,T,U,V) 


#define _REAL_CONNECT_B3_REQ(A,B,C,D,E) \
( *((PCONNECT_B3_REQ)CapiFuncs[CONNECT_B3_REQ_ID].pFunc ))(A,B,C,D,E)

#define _REAL_DATA_B3_REQ(A,B,C,D,E,F,G,H) \
( *((PDATA_B3_REQ)CapiFuncs[DATA_B3_REQ_ID].pFunc ))(A,B,C,D,E,F,G,H)

#define _REAL_DISCONNECT_B3_REQ(A,B,C,D,E) \
( *((PDISCONNECT_B3_REQ)CapiFuncs[DISCONNECT_B3_REQ_ID].pFunc ))(A,B,C,D,E)

#define _REAL_DISCONNECT_REQ(A,B,C,D,E,F,G,H) \
( *((PDISCONNECT_REQ)CapiFuncs[DISCONNECT_REQ_ID].pFunc ))(A,B,C,D,E,F,G,H)

#define _REAL_FACILITY_REQ(A,B,C,D,E,F) \
( *((PFACILITY_REQ)CapiFuncs[FACILITY_REQ_ID].pFunc ))(A,B,C,D,E,F)

#define _REAL_INFO_REQ(A,B,C,D,E,F,G,H,I) \
( *((PINFO_REQ)CapiFuncs[INFO_REQ_ID].pFunc ))(A,B,C,D,E,F,G,H,I)

#define _REAL_LISTEN_REQ(A,B,C,D,E,F,G,H,I) \
( *((PLISTEN_REQ)CapiFuncs[LISTEN_REQ_ID].pFunc ))(A,B,C,D,E,F,G,H,I)

#define _REAL_MANUFACTURER_REQ(A,B,C,D,E,F,G,H) \
( *((PMANUFACTURER_REQ)CapiFuncs[MANUFACTURER_REQ_ID].pFunc ))(A,B,C,D,E,F,G,H)

#define _REAL_RESET_B3_REQ(A,B,C,D,E) \
( *((PRESET_B3_REQ)CapiFuncs[RESET_B3_REQ_ID].pFunc ))(A,B,C,D,E)

#define _REAL_SELECT_B_PROTOCOL_REQ(A,B,C,D,E,F,G,H,I,J) \
( *((PSELECT_B_PROTOCOL_REQ)CapiFuncs[SELECT_B_PROTOCOL_REQ_ID].pFunc ))(A,B,C,D,E,F,G,H,I,J)

#define _REAL_CONNECT_RESP(A,B,C,D,E,F,G,H,I,J,K,L,M,N,O,P,Q,R) \
( *((PCONNECT_RESP)CapiFuncs[CONNECT_RESP_ID].pFunc ))(A,B,C,D,E,F,G,H,I,J,K,L,M,N,O,P,Q,R) 

#define _REAL_CONNECT_ACTIVE_RESP(A,B,C,D) \
( *((PCONNECT_ACTIVE_RESP)CapiFuncs[CONNECT_ACTIVE_RESP_ID].pFunc ))(A,B,C,D)

#define _REAL_CONNECT_B3_ACTIVE_RESP(A,B,C,D) \
( *((PCONNECT_B3_ACTIVE_RESP)CapiFuncs[CONNECT_B3_ACTIVE_RESP_ID].pFunc ))(A,B,C,D)

#define _REAL_CONNECT_B3_RESP(A,B,C,D,E,F) \
( *((PCONNECT_B3_RESP)CapiFuncs[CONNECT_B3_RESP_ID].pFunc ))(A,B,C,D,E,F)

#define _REAL_CONNECT_B3_T90_ACTIVE_RESP(A,B,C,D) \
( *((PCONNECT_B3_T90_ACTIVE_RESP)CapiFuncs[CONNECT_B3_T90_ACTIVE_RESP_ID].pFunc ))(A,B,C,D)

#define _REAL_DATA_B3_RESP(A,B,C,D,E) \
( *((PDATA_B3_RESP)CapiFuncs[DATA_B3_RESP_ID].pFunc ))(A,B,C,D,E)

#define _REAL_DISCONNECT_B3_RESP(A,B,C,D) \
( *((PDISCONNECT_B3_RESP)CapiFuncs[DISCONNECT_B3_RESP_ID].pFunc ))(A,B,C,D)

#define _REAL_DISCONNECT_RESP(A,B,C,D) \
( *((PDISCONNECT_RESP)CapiFuncs[DISCONNECT_RESP_ID].pFunc ))(A,B,C,D)

#define _REAL_FACILITY_RESP(A,B,C,D,E,F) \
( *((PFACILITY_RESP)CapiFuncs[FACILITY_RESP_ID].pFunc ))(A,B,C,D,E,F)

#define _REAL_INFO_RESP(A,B,C,D) \
( *((PINFO_RESP)CapiFuncs[INFO_RESP_ID].pFunc ))(A,B,C,D)

#define _REAL_MANUFACTURER_RESP(A,B,C,D,E,F,G,H) \
( *((PMANUFACTURER_RESP)CapiFuncs[MANUFACTURER_RESP_ID].pFunc ))(A,B,C,D,E,F,G,H)

#define _REAL_RESET_B3_RESP(A,B,C,D) \
( *((PRESET_B3_RESP)CapiFuncs[RESET_B3_RESP_ID].pFunc ))(A,B,C,D)


#define _real_capi_get_cmsg(A,B) \
( *((pcapi_get_cmsg)CapiFuncs[capi_get_cmsg_ID].pFunc ))(A,B)

#define _real_capi_put_cmsg(A) \
( *((pcapi_put_cmsg)CapiFuncs[capi_put_cmsg_ID].pFunc ))(A)

#define _real_capi_cmsg_header(A,B,C,D,E,F) \
( *((pcapi_cmsg_header)CapiFuncs[capi_cmsg_header_ID].pFunc ))(A,B,C,D,E,F)


typedef unsigned ( * REGISTER)(unsigned MaxLogicalConnection,
			       unsigned MaxBDataBlocks,
			       unsigned MaxBDataLen,
			       unsigned *ApplIDp);

typedef unsigned ( * RELEASE) (unsigned ApplID);

typedef unsigned ( * PUTMSG) (unsigned ApplID, unsigned char *Msg);

typedef unsigned ( * GETMSG) (unsigned ApplID, unsigned char **Buf);

typedef unsigned ( * WAITMSG)(unsigned ApplID, struct timeval *TimeOut);

typedef unsigned char * ( * GETMANU)(unsigned Ctrl, unsigned char *Buf);

typedef unsigned char * ( * GETVER)(unsigned Ctrl, unsigned char *Buf);

typedef unsigned char * ( * GETSER)(unsigned Ctrl, unsigned char *Buf);

typedef unsigned ( * GETPROF)(unsigned Controller, unsigned char *Buf);

typedef unsigned ( * INSTALLED)(void);

typedef int ( * FILENO)( unsigned AppplId);


typedef unsigned ( *PALERT_REQ )(_cmsg *cmsg, _cword ApplId, 
				 _cword Messagenumber
				 ,_cdword adr
				 ,_cstruct BChannelinformation
				 ,_cstruct Keypadfacility
				 ,_cstruct Useruserdata
				 ,_cstruct Facilitydataarray);

typedef unsigned ( *PCONNECT_REQ )(_cmsg *cmsg, _cword ApplId, 
				   _cword Messagenumber
				   ,_cdword adr
				   ,_cword CIPValue
				   ,_cstruct CalledPartyNumber
				   ,_cstruct CallingPartyNumber
				   ,_cstruct CalledPartySubaddress
				   ,_cstruct CallingPartySubaddress
				   ,_cword B1protocol
				   ,_cword B2protocol
				   ,_cword B3protocol
				   ,_cstruct B1configuration
				   ,_cstruct B2configuration
				   ,_cstruct B3configuration
				   ,_cstruct BC
				   ,_cstruct LLC
				   ,_cstruct HLC
				   ,_cstruct BChannelinformation
				   ,_cstruct Keypadfacility
				   ,_cstruct Useruserdata
				   ,_cstruct Facilitydataarray);

typedef unsigned ( *PCONNECT_B3_REQ )(_cmsg *cmsg, _cword ApplId, 
				      _cword Messagenumber
				      ,_cdword adr
				      ,_cstruct NCPI);

typedef unsigned ( *PDATA_B3_REQ )(_cmsg *cmsg, _cword ApplId, 
				   _cword Messagenumber
				   ,_cdword adr
				   ,void * Data
				   ,_cword DataLength
				   ,_cword DataHandle
				   ,_cword Flags);

typedef unsigned ( *PDISCONNECT_B3_REQ )(_cmsg *cmsg, _cword ApplId, 
					 _cword Messagenumber
					 ,_cdword adr
					 ,_cstruct NCPI);

typedef unsigned ( *PDISCONNECT_REQ )(_cmsg *cmsg, _cword ApplId, 
				      _cword Messagenumber
				      ,_cdword adr
				      ,_cstruct BChannelinformation
				      ,_cstruct Keypadfacility
				      ,_cstruct Useruserdata
				      ,_cstruct Facilitydataarray);

typedef unsigned ( *PFACILITY_REQ )(_cmsg *cmsg, _cword ApplId, 
				    _cword Messagenumber
				    ,_cdword adr
				    ,_cword FacilitySelector
				    ,_cstruct FacilityRequestParameter);

typedef unsigned ( *PINFO_REQ )(_cmsg *cmsg, _cword ApplId, 
				_cword Messagenumber
				,_cdword adr
				,_cstruct CalledPartyNumber
				,_cstruct BChannelinformation
				,_cstruct Keypadfacility
				,_cstruct Useruserdata
				,_cstruct Facilitydataarray);

typedef unsigned ( *PLISTEN_REQ )(_cmsg *cmsg, _cword ApplId, 
				 _cword Messagenumber
				 ,_cdword adr
				 ,_cdword InfoMask
				 ,_cdword CIPmask
				 ,_cdword CIPmask2
				 ,_cstruct CallingPartyNumber
				 ,_cstruct CallingPartySubaddress);

typedef unsigned ( *PMANUFACTURER_REQ )(_cmsg *cmsg, _cword ApplId, 
					_cword Messagenumber
					,_cdword adr
					,_cdword ManuID
					,_cdword Class
					,_cdword Function
					,_cstruct ManuData);

typedef unsigned ( *PRESET_B3_REQ )(_cmsg *cmsg, _cword ApplId, 
				    _cword Messagenumber
				    ,_cdword adr
				    ,_cstruct NCPI);

typedef unsigned ( *PSELECT_B_PROTOCOL_REQ )(_cmsg *cmsg, _cword ApplId, 
					     _cword Messagenumber
					     ,_cdword adr
					     ,_cword B1protocol
					     ,_cword B2protocol
					     ,_cword B3protocol
					     ,_cstruct B1configuration
					     ,_cstruct B2configuration
					     ,_cstruct B3configuration);

typedef unsigned ( *PCONNECT_RESP )(_cmsg *cmsg, _cword ApplId, 
				    _cword Messagenumber
				    ,_cdword adr
				    ,_cword Reject
				    ,_cword B1protocol
				    ,_cword B2protocol
				    ,_cword B3protocol
				    ,_cstruct B1configuration
				    ,_cstruct B2configuration
				    ,_cstruct B3configuration
				    ,_cstruct ConnectedNumber
				    ,_cstruct ConnectedSubaddress
				    ,_cstruct LLC
				    ,_cstruct BChannelinformation
				    ,_cstruct Keypadfacility
				    ,_cstruct Useruserdata
				    ,_cstruct Facilitydataarray);

typedef unsigned ( *PCONNECT_ACTIVE_RESP )(_cmsg *cmsg, _cword ApplId, 
					   _cword Messagenumber
					   ,_cdword adr);

typedef unsigned ( *PCONNECT_B3_ACTIVE_RESP )(_cmsg *cmsg, _cword ApplId, 
					      _cword Messagenumber
					      ,_cdword adr);

typedef unsigned ( *PCONNECT_B3_RESP )(_cmsg *cmsg, _cword ApplId, 
				       _cword Messagenumber
				       ,_cdword adr
				       ,_cword Reject
				       ,_cstruct NCPI);

typedef unsigned ( *PCONNECT_B3_T90_ACTIVE_RESP )(_cmsg *cmsg, _cword ApplId, 
						  _cword Messagenumber
						  ,_cdword adr);

typedef unsigned ( *PDATA_B3_RESP )(_cmsg *cmsg, _cword ApplId, 
				    _cword Messagenumber
				    ,_cdword adr
				    ,_cword DataHandle);

typedef unsigned ( *PDISCONNECT_B3_RESP )(_cmsg *cmsg, _cword ApplId, 
					  _cword Messagenumber
					  ,_cdword adr);

typedef unsigned ( *PDISCONNECT_RESP )(_cmsg *cmsg, _cword ApplId, 
				       _cword Messagenumber
				       ,_cdword adr);

typedef unsigned ( *PFACILITY_RESP )(_cmsg *cmsg, _cword ApplId, 
				     _cword Messagenumber
				     ,_cdword adr
				     ,_cword FacilitySelector
				     ,_cstruct FacilityResponseParameters);

typedef unsigned ( *PINFO_RESP )(_cmsg *cmsg, _cword ApplId, 
				 _cword Messagenumber
				 ,_cdword adr);

typedef unsigned ( *PMANUFACTURER_RESP )(_cmsg *cmsg, _cword ApplId, 
					 _cword Messagenumber
					 ,_cdword adr
					 ,_cdword ManuID
					 ,_cdword Class
					 ,_cdword Function
					 ,_cstruct ManuData);

typedef unsigned ( *PRESET_B3_RESP )(_cmsg *cmsg, _cword ApplId, 
				     _cword Messagenumber
				     ,_cdword adr);




typedef unsigned ( *pcapi_get_cmsg)(_cmsg *cmsg, unsigned applid);

typedef unsigned ( *pcapi_put_cmsg)(_cmsg *cmsg);

typedef unsigned ( *pcapi_cmsg_header )(_cmsg *cmsg, unsigned _ApplId, 
					_cbyte _Command, _cbyte _Subcommand, 
					_cword _Messagenumber, 
					_cdword _Controller);


#endif


