#ifdef _LINUX_
#include <unistd.h>
#include <sys/time.h>
#else
#include <time.h>
#endif
#include "defs.h"
#include "tools.h"
#include "libstub.h"
#include "lib.h"
#include "driver.h"
#include "capidrv.h"

static char *	invalid_msg   = "Invalid application id #%d.\n";

void enter_critical (void) 
{
}

void leave_critical (void) 
{
}	

void lock (void) 
{
}

void unlock (void) 
{
}	

int msg2stack (unsigned char * msg)
{

  if( capi_card->pMsgRead[0] == 1 )
    {
      memcpy( msg, &capi_card->pMsgRead[1], 
	      *(( unsigned short*)&capi_card->pMsgRead[1]) );
      capi_card->pMsgRead[0] = 0;
      capi_card->pMsgRead += 256;
      if( capi_card->pMsgRead >= capi_card->pMsgEnd )
	capi_card->pMsgRead = capi_card->msgbuf;
	  
      return 1;
    }  
  else
    {
      if( capi_card->pMsgRead[0] > 0 )
	(capi_card->pMsgRead[0]) -= 1;
      return 0;
    }
}

void msg2capi (unsigned char * msg) 
{
  HandleCapiMsg( msg );
}




unsigned FaxPutMsg(unsigned ApplID, unsigned char *Msg)
{
  unsigned dwRet = 0xFFFFFFFF;
  if( capi_card->pMsgWrite[0] == 0 )
    {
      memcpy( &capi_card->pMsgWrite[1], Msg, *(( unsigned short*)Msg) ); 
      capi_card->pMsgWrite[0] = 3;
      capi_card->pMsgWrite += 256;
      if( capi_card->pMsgWrite >= capi_card->pMsgEnd )
	capi_card->pMsgWrite = capi_card->msgbuf;
      dwRet = 0;
    }  
  else
    TRACE(("Capi queue overflow !!!! %ld\n", 
	   (unsigned long)( capi_card->pMsgWrite - capi_card->msgbuf) ));
  
  return dwRet;
}

void init (
	unsigned len, 
	void  (* reg) (void *, unsigned),
	void  (* rel) (void *),
	void  (* dwn) (void)) 
{

  capi_card->length   = len;
  capi_card->reg_func = reg;
  capi_card->rel_func = rel;
  capi_card->dwn_func = dwn;
} /* init */

void Register_Appl ( unsigned short appl, 
		     card_t *card,
		     unsigned datablkcnt, 
		     unsigned datablklen ) 
{
  appl_t *		appp;
  void *			ptr;
  unsigned		nc = 1;

  TRACE(("REGISTER(appl:%u)\n", appl));
  appp = create_appl (
		      card->appls, 
		      appl, 
		      nc, 
		      datablkcnt, 
		      datablklen
		      );
  if (NULL == appp) {
    TRACE(("Unable to create application record.\n"));
    return;
  }
  ptr = hcalloc (card->length);
  if (NULL == ptr) {
    printl ("Not enough memory for application data.\n");
    remove_appl (card->appls, appp);
  } else {
    lock ();
    card->count++;
    appp->data = ptr;
    appp->ctrl = NULL;
    unlock ();
    (*card->reg_func) (ptr, appl);
  }
} /* register_appl */


void Release_Appl (unsigned short appl, card_t *card ) 
{	
  appl_t *		appp;
  unsigned char    request[8];
  TRACE(("RELEASE(appl:%u)\n", appl));
  if (NULL == (appp = search_appl (card->appls, appl))) 
    {
      TRACE(("Attempt to release unknown application (id #%u)\n", appl));
      return;
    }
  request[0] = 8;
  request[1] = 0;
  request[2] = appl & 0xFF;
  request[3] = (appl >> 8) & 0xFF;
  request[4] = 0xFE;
  request[5] = 0x80;
  
  FaxPutMsg( 0, request);
  FaxPoll( 4 );
  appp->dying = TRUE;
} /* release_appl */


/*---------------------------------------------------------------------------*\
\*---------------------------------------------------------------------------*/
void * first_data (int * res) {
	appl_t * appp;

	assert (res);
	appp = first_appl (capi_card->appls);
	*res = (appp != NULL) ? 0 : -1;
	return (appp != NULL) ? appp->data  : NULL;
} /* first_data */

/*---------------------------------------------------------------------------*\
\*---------------------------------------------------------------------------*/
void * next_data (int * res) {
	appl_t * appp;

	assert (res);
	if (NULL != (appp = get_appl (capi_card->appls, *res))) {
		appp = next_appl (capi_card->appls, appp);
	}
	*res = (appp != NULL) ? 1 + *res : -1;
	return (appp != NULL) ? appp->data  : NULL;
} /* next_data */

/*---------------------------------------------------------------------------*\
\*---------------------------------------------------------------------------*/
int appl_profile (unsigned appl_id, unsigned * bs, unsigned * bc) {
	appl_t * appp;

	appp = search_appl (capi_card->appls, appl_id);
	if (NULL == appp) {
		return 0;
	}
	if (bs) { 
		*bs = appp->blk_size; 
	}
	if (bc) { 
		*bc = appp->blk_count; 
	}
	return 1;
} /* appl_profile */


/*---------------------------------------------------------------------------*\
\*---------------------------------------------------------------------------*/
void new_ncci (
	unsigned	appl_id, 
	unsigned		ncci,
	unsigned	winsize,
	unsigned	blksize
) {
	appl_t *	appp;
	ncci_t *	nccip;

	TRACE(("NEW NCCI(appl:%u,ncci:0x%08X)\n", appl_id, ncci));
	if (NULL == (appp = search_appl (capi_card->appls, appl_id))) {
		printl (invalid_msg, appl_id);
		return;
	}
	nccip = create_ncci (
			capi_card->appls, 
			appp, 
			ncci, 
			winsize, 
			blksize
			);
	if (NULL == nccip) {
		 TRACE(("Cannot handle new NCCI...\n"));
		return;
	}
} /* new_ncci */

/*---------------------------------------------------------------------------*\
\*---------------------------------------------------------------------------*/
void free_ncci (unsigned appl_id, unsigned ncci) {
	appl_t *	appp;
	ncci_t *	nccip;

	appp = search_appl (capi_card->appls, appl_id);
	if (NULL == appp) {
		printl ( invalid_msg, appl_id);
		return;
	}
	assert (appp->ctrl);
	if (0xFFFFFFFF == ncci) {		/* 2nd phase RELEASE */
		capi_card->count--;
		TRACE(("FREE APPL(appl:%u)\n", appl_id));

		(*capi_card->rel_func) (appp->data);
		remove_appl (capi_card->appls, appp);
	} else if (NULL != (nccip = locate_ncci (appp, ncci))) {
		TRACE(("FREE NCCI(appl:%u,ncci:0x%08X)\n", appl_id, ncci));
		remove_ncci (capi_card->appls, appp, nccip);
	} else {
		printl ( "Attempt to free unknown NCCI.\n");
	}
} /* free_ncci */

/*---------------------------------------------------------------------------*\
\*---------------------------------------------------------------------------*/
unsigned char * data_block (unsigned appl_id, unsigned ncci, unsigned handle) {
	appl_t * appp;
 
	appp = search_appl (capi_card->appls, appl_id);
	if (NULL == appp) {
		printl (invalid_msg, appl_id);
		return NULL;
	}
	return ncci_data_buffer (capi_card->appls, appp, ncci, handle);
} /* data_block */

/*---------------------------------------------------------------------------*\
\*---------------------------------------------------------------------------*/
void * data_by_id (unsigned appl_id) {
	appl_t * appp;

	appp = search_appl (capi_card->appls, appl_id);
	return (appp != NULL) ? appp->data : NULL;
} /* data_by_id */



