
//#include "driver.h"

#ifdef __KERNEL__
#include <linux/malloc.h>
#else
#include <stdio.h>
#include <stdarg.h>
#include <stdlib.h>
#endif

#include "libdefs.h"

#include "tools.h"


extern void *pHeapBase;
extern lib_callback_t *capi_lib;

/*---------------------------------------------------------------------------*\
\*---------------------------------------------------------------------------*/
void * hmalloc (unsigned size) 
{
  void * mem = NULL;
#ifdef __KERNEL__
  mem = kmalloc( GFP_ATOMIC, size );
#else
  mem = malloc( size );
#endif 

  return mem;

} /* hmalloc */

/*---------------------------------------------------------------------------*\
\*---------------------------------------------------------------------------*/
void * hcalloc (unsigned size) 
{
  void * mem = hmalloc( size );
  if( mem )
    memset( mem, 0x00, size );
  return mem;
} /* hcalloc */

/*---------------------------------------------------------------------------*\
\*---------------------------------------------------------------------------*/
void hfree (void * mem) 
{
#ifdef __KERNEL__
  kfree( mem );
#else
 free( mem );
#endif
}



void message (const char * fmt, ...)
{
  va_list	args;
  char	buffer [80];
  
  va_start (args, fmt);
  vsprintf(buffer, fmt, args);
  TRACE((buffer));
  va_end (args);
}



