#ifndef _SFAX_H
#define _SFAX_H

#define B3_BLOCKS  4

typedef struct fax
{
  unsigned short wApplId;
  unsigned long dwPlci;
  unsigned long dwPlciInternal;
  unsigned char BProt[64];
  unsigned char DataBuf[2048 * B3_BLOCKS];
  unsigned char *pDataBufw;
  unsigned char *pDataBufr;
  unsigned length;
  unsigned blocklength;
  unsigned short wDataLen[B3_BLOCKS];
  unsigned short whData;
  unsigned byteswritten;
  unsigned char *pRxData;
  unsigned char *pRxDataEnd;
  unsigned fInbound;
  unsigned fStartSend;
  unsigned fStarted;
  unsigned fDisconnect;
  unsigned char bCh;
  unsigned char         msgbuf[(2048+ 256)*8];
  unsigned char *       pMsgRead;
  unsigned char *       pMsgWrite;
  unsigned char *       pMsgEnd;
  struct fax *pNext;
} FAX, *PFAX;


typedef int ( *DATA_FUNC) ( unsigned char *pData, 
			    unsigned len, unsigned  hscx );

int FaxStart( DATA_FUNC TxCB, DATA_FUNC RxCB );
int FaxStop( void );
PFAX FaxNewEntity( unsigned short wApplId, 
		   unsigned char *pBProt, 
		   unsigned dwPlci );
PFAX FaxFindEntity( unsigned short wApplId, unsigned long dwPlci,
		    unsigned long dwPlciMask );
void FaxFreeEntity( PFAX pFax );
unsigned FaxProcessDataConf( PFAX pFax, unsigned short whData );
unsigned FaxProcessDataInd( PFAX pFax, 
			    unsigned char *pData, unsigned short length );


unsigned long FaxStartConnection( PFAX pFax );
unsigned long FaxStopConnection( PFAX pFax );
unsigned long FaxPoll( unsigned param );
void FaxNextWrite( int hscx );
void FaxNextRead( int hscx );
unsigned Fax_Put_Message( PFAX pFax, unsigned char *Buf);
unsigned Fax_Put_MessageInternal( PFAX pFax, unsigned char *Buf);
unsigned Fax_Get_Message( PFAX pFax, unsigned char **Buf);

#endif
