#ifndef _LINUXCAPI_H
#define _LINUXCAPI_H

#define __NO_CAPIUTILS__

#ifdef _LINUX_
#ifndef __KERNEL__
#include "/usr/include/capi20.h"
#endif
#endif

#include <c20type.h>

#ifdef _LINUX_
#define CAPI_REGISTER(a,b,c,d,e )\
capi20_register (b,c,d,e)

#define CAPI_RELEASE(a) capi20_release (a)

#ifdef SFAX
#define CAPI_PUT_MESSAGE(a,b) FaxPutMsg(a,b)
#else
#define CAPI_PUT_MESSAGE(a,b) capi20_put_message(a,b)
#endif

#define CAPI_GET_MESSAGE(a,b) capi20_get_message (a,b)

#define CAPI_WAIT_FOR_SIGNAL(a){\
                                struct timeval time;\
                                time.tv_sec = 1;\
				time.tv_usec = 0;\
				capi20_waitformessage(a,&time);\
                               }

#define CAPI_GET_MANUFACTURER(a,b) capi20_get_manufacturer (a,b)

#define CAPI_GET_VERSION(a,b) capi20_get_version (a,b)

#define CAPI_GET_SERIAL_NUMBER(a,b) capi20_get_serial_number (a,b)

#define CAPI_GET_PROFILE(b,a) capi20_get_profile(a,b)

#define CAPI_INSTALLED capi20_isinstalled
#else
#ifdef SFAX
#define CAPI_PUT_MESSAGE(a,b) FaxPutMsg(a,b)
#else
#define CAPI_PUT_MESSAGE(a,b) capi20_put_message(a,b)
#endif

#endif

typedef struct tagCAPI_PROFILE
{
  WORD  Number;          /* Number of installed controllers    */
  WORD  Channels;        /* Number of supported B-channels     */
  DWORD Global_Options;  /* Global Options (bit field)         */
  DWORD B1_Protocols;    /* B1 protocol support (bit field)    */
  DWORD B2_Protocols;    /* B2 protocol support (bit field)    */
  DWORD B3_Protocols;    /* B3 protocol support (bit field)    */
  DWORD reserved[6];     /* reserved for COMMON-ISDN_API usage */
  DWORD ManuInfo[5];     /* manufacturer specific information  */
} CAPI_PROFILE, * PCAPI_PROFILE;

#endif







