/* 
 * libdefs.h
 * Copyright (C) 2002, AVM GmbH. All rights reserved.
 * 
 * This Software is  free software. You can redistribute and/or
 * modify such free software under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * 
 * The free software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public
 * License along with this Software; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA, or see
 * http://www.opensource.org/licenses/lgpl-license.html
 * 
 * Contact: AVM GmbH, Alt-Moabit 95, 10559 Berlin, Germany, email: info@avm.de
 */

#ifndef __have_libdefs_h__
#define __have_libdefs_h__

#include <stdarg.h>

typedef void (* register_cb) (void *, unsigned);
typedef void (* release_cb) (void *);
typedef void (* down_cb) (void);

typedef enum {

	timer_end	= 0,
	timer_restart	= 1
} restart_t;

typedef restart_t (* timerfunc_t) (unsigned long);

typedef struct __data {

	unsigned	num;
	char *		buffer;
} appldata_t;

typedef struct __lib {

	void (* init) (unsigned, register_cb, release_cb, down_cb);
	char * (* params) (void);
	int (* get_message) (unsigned char *);
	void (* put_message) (unsigned char *);
	unsigned char * (* get_data_block) (unsigned, unsigned long, unsigned);
	void (* free_data_block) (unsigned, unsigned char *);
	int (* new_ncci) (unsigned, unsigned long, unsigned, unsigned);
	void (* free_ncci) (unsigned, unsigned long);
	unsigned (* block_size) (unsigned);
	unsigned (* window_size) (unsigned);
	unsigned (* card) (void);
	void * (* appl_data) (unsigned);
	appldata_t * (* appl_1st_data) (appldata_t *);
	appldata_t * (* appl_next_data) (appldata_t *);
	void * (* malloc) (unsigned);
	void (* free) (void *);
	unsigned long (* msec) (void);
	int (* timer_new) (unsigned);
	void (* timer_delete) (void);
	int (* timer_start) (unsigned, unsigned long, unsigned long, timerfunc_t);
	int (* timer_stop) (unsigned);
	void (* timer_poll) (void);
	void (* printf) (char *, va_list);
	void (* puts) (char *);
	void (* putl) (long);
	void (* puti) (int);
	void (* putc) (char);
	void (* putnl) (void);
	void (* _enter_critical) (const char *, int);
	void (* _leave_critical) (const char *, int);
	void (* enter_critical) (void);
	void (* leave_critical) (void);
	void (* enter_cache_sensitive_code) (void);
	void (* leave_cache_sensitive_code) (void);

	char *		name;
	unsigned	udata;
	void *		pdata;
} lib_interface_t;

typedef struct __f {
	
	unsigned	nfuncs;
	void	     (* sched_ctrl) (unsigned);
	void         (* wakeup_ctrl) (unsigned);
} functions_t, * functions_p;

typedef struct __cb {

	unsigned (* cm_start) (void);
	char * (* cm_init) (unsigned, unsigned);
	int (* cm_activate) (void);
	int (* cm_exit) (void);
	unsigned (* cm_handle_events) (void);
	int (* cm_schedule) (void);
	void (* cm_timer_irq_control) (unsigned);
	void (* cm_register_ca_functions) (functions_p);
	unsigned (* check_controller) (unsigned, unsigned *);

	void * (* lib_heap_init) (void *, unsigned);
	void (* lib_heap_exit) (void *);
	void * (* lib_heap_alloc) (void *, unsigned);
	void (* lib_heap_free) (void *, void *);
} lib_callback_t;

#endif

