#ifndef _IO_H
#define _IO_H


#define TGT_CFG 1
#define TGT_ISAC 2
#define TGT_HSCX0 3
#define TGT_HSCX1 4
#define TGT_ISAC_FIFO 5
#define TGT_HSCX0_FIFO 6
#define TGT_HSCX1_FIFO 7

#define REG_READ 0
#define REG_WRITE 1


typedef unsigned long (*TGT_FUNC)( unsigned port, unsigned length, 
				   unsigned char *pData, int access, 
				   int block );
typedef struct _tgt
{
  TGT_FUNC pFunc; 
  unsigned char bMem[2][256];
  unsigned dwFlags;
  int datacnt;
  int readcnt;
  int writecnt;
} TGT, *PTGT; 

unsigned char InpByte (unsigned port);
void OutpByte (unsigned port, unsigned char data); 
unsigned long InpDWord (unsigned port);
void OutpDWord (unsigned port, unsigned long data);
void InpByteBlock (unsigned port, unsigned char * buffer, unsigned length);
void OutpByteBlock (unsigned port, unsigned char * buffer, unsigned length);
void InpDWordBlock (unsigned port, unsigned char * buffer, unsigned length); 
void OutpDWordBlock (unsigned port, unsigned char * buffer, unsigned length);

unsigned char _InpByte (unsigned port);
void _OutpByte (unsigned port, unsigned char data); 
unsigned long _InpDWord (unsigned port);
void _OutpDWord (unsigned port, unsigned long data);
void _InpByteBlock (unsigned port, unsigned char * buffer, unsigned length);
void _OutpByteBlock (unsigned port, unsigned char * buffer, unsigned length);
void _InpDWordBlock (unsigned port, unsigned char * buffer, unsigned length); 
void _OutpDWordBlock (unsigned port, unsigned char * buffer, unsigned length);


void target_init( void );
void target_exit( void );
void disable( void );
void enable( void );

#endif
